/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.xmiuml.ehi;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.xmiuml.ehi.ErrorListener;
import ch.ehi.umleditor.xmiuml.ehi.MyHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLInterlisDecoder {
    String fileName;
    XMLReader parser;
    boolean xmlParsed = true;
    InputSource inputSource = null;
    InputStream inputStream = null;

    public Object decode(String path) throws IOException {
        Object obj = this.parse(path);
        return obj;
    }

    private Object parse(String path) throws IOException {
        Object object = null;
        try {
            this.parser = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException exSax) {
            throw new IOException("Unable to create the XML-Reader");
        }
        MyHandler myHandler = new MyHandler();
        ErrorListener errorListener = new ErrorListener();
        this.parser.setContentHandler(myHandler);
        this.parser.setErrorHandler(errorListener);
        myHandler.setErrorHandler(errorListener);
        try {
            this.inputStream = new FileInputStream(new File(path));
            this.inputSource = new InputSource(this.inputStream);
            this.parser.parse(this.inputSource);
            object = myHandler.getUmlModel();
            this.inputStream.close();
            if (object == null) {
                return null;
            }
            this.inputStream = new FileInputStream(new File(path));
            this.inputSource = new InputSource(this.inputStream);
            myHandler.setSecondPass(true);
            this.parser.parse(this.inputSource);
            Map unref = myHandler.getUnreferencedObjects();
            if (unref.size() > 0) {
                for (String tid : unref.keySet()) {
                    LauncherView.getInstance().log("decoder", "Object <" + tid + "> is never used");
                }
            }
            EhiLogger.traceState("root-object: " + object);
            this.inputStream.close();
        }
        catch (SAXParseException exSax) {
            Exception ex = exSax;
            if (exSax.getException() != null) {
                ex = exSax.getException();
            }
            LauncherView.getInstance().log("decode", "Err - Message: " + ex.getMessage());
            LauncherView.getInstance().log("decode", "System ID: " + exSax.getSystemId());
            LauncherView.getInstance().log("decode", "Err at line: " + exSax.getLineNumber());
            EhiLogger.logError(ex);
            throw new IOException(ex.getMessage());
        }
        catch (SAXException exSax) {
            Throwable ex = exSax;
            if (ex instanceof InvocationTargetException) {
                InvocationTargetException iex = (InvocationTargetException)ex;
                ex = iex.getTargetException();
            }
            throw new IOException(ex.getLocalizedMessage());
        }
        return object;
    }
}

