/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import org.netbeans.beaninfo.editors.StringCustomEditor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class FileEditor
extends PropertyEditorSupport
implements ExPropertyEditor,
PropertyChangeListener {
    static final String PROPERTY_SHOW_DIRECTORIES = "directories";
    static final String PROPERTY_SHOW_FILES = "files";
    static final String PROPERTY_FILTER = "filter";
    static final String PROPERTY_CURRENT_DIR = "currentDir";
    static final String PROPERTY_BASE_DIR = "baseDir";
    static final String PROPERTY_FILE_HIDING = "file_hiding";
    private int mode = 2;
    private boolean directories = true;
    private boolean files = true;
    private boolean fileHiding = false;
    private javax.swing.filechooser.FileFilter fileFilter;
    private File currentDirectory;
    private File baseDirectory;
    static File lastCurrentDir;
    private PropertyEnv env;
    private JFileChooser chooser;
    private boolean editable = true;

    public void attachEnv(PropertyEnv propertyEnv) {
        Object object;
        Object object2;
        Object object3;
        this.env = propertyEnv;
        this.directories = true;
        this.files = true;
        this.fileFilter = null;
        this.fileHiding = false;
        Object object4 = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_SHOW_DIRECTORIES);
        if (object4 instanceof Boolean) {
            this.directories = (Boolean)object4;
        }
        if ((object3 = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_SHOW_FILES)) instanceof Boolean) {
            this.files = (Boolean)object3;
        }
        if ((object2 = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_FILTER)) instanceof FilenameFilter) {
            this.fileFilter = new DelegatingFilenameFilter((FilenameFilter)object2);
        } else if (object2 instanceof javax.swing.filechooser.FileFilter) {
            this.fileFilter = (javax.swing.filechooser.FileFilter)object2;
        } else if (object2 instanceof FileFilter) {
            this.fileFilter = new DelegatingFileFilter((FileFilter)object2);
        }
        Object object5 = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_CURRENT_DIR);
        if (object5 instanceof File) {
            this.currentDirectory = (File)object5;
            if (!this.currentDirectory.isDirectory()) {
                Logger.getAnonymousLogger().warning("java.io.File will not accept currentDir=" + this.currentDirectory);
                this.currentDirectory = null;
            }
        }
        if ((object = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_BASE_DIR)) instanceof File) {
            this.baseDirectory = (File)object;
            if (!this.baseDirectory.isDirectory() || !this.baseDirectory.isAbsolute()) {
                Logger.getAnonymousLogger().warning("java.io.File will not accept baseDir=" + this.baseDirectory);
                this.baseDirectory = null;
            }
        }
        this.mode = this.files ? (this.directories ? 2 : 0) : (this.directories ? 1 : 2);
        Object object6 = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_FILE_HIDING);
        if (object6 instanceof Boolean) {
            this.fileHiding = (Boolean)object6;
        }
        if (propertyEnv.getFeatureDescriptor() instanceof Node.Property) {
            Node.Property property = (Node.Property)propertyEnv.getFeatureDescriptor();
            this.editable = property.canWrite();
        }
    }

    @Override
    public String getAsText() {
        File file = (File)this.getValue();
        if (file == null) {
            return "";
        }
        String string = file.getPath();
        if ("".equals(string)) {
            string = ".";
        }
        return string;
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("null");
        }
        if ("".equals(string)) {
            this.setValue(null);
            return;
        }
        if (".".equals(string)) {
            string = "";
        }
        this.setValue(new File(string));
    }

    @Override
    public Component getCustomEditor() {
        if (!this.editable) {
            String string = "";
            Object object = this.getValue();
            if (object instanceof File) {
                string = ((File)object).getAbsolutePath();
            }
            return new StringCustomEditor(string, false, true, null, this, this.env);
        }
        if (this.chooser == null) {
            this.chooser = FileEditor.createHackedFileChooser();
            File file = (File)this.getValue();
            if (file != null && !file.isAbsolute() && this.baseDirectory != null) {
                file = new File(this.baseDirectory, file.getPath());
            }
            if (this.currentDirectory != null) {
                this.chooser.setCurrentDirectory(this.currentDirectory);
            } else if (file != null && file.getParentFile() != null) {
                this.chooser.setCurrentDirectory(file.getParentFile());
                this.chooser.setSelectedFile(file);
            } else if (lastCurrentDir != null) {
                this.chooser.setCurrentDirectory(lastCurrentDir);
            }
            this.chooser.setFileSelectionMode(this.mode);
            if (this.fileFilter != null) {
                this.chooser.setFileFilter(this.fileFilter);
            }
            switch (this.mode) {
                case 2: {
                    this.chooser.setDialogTitle(FileEditor.getString("CTL_DialogTitleFilesAndDirs"));
                    break;
                }
                case 0: {
                    this.chooser.setDialogTitle(FileEditor.getString("CTL_DialogTitleFiles"));
                    break;
                }
                case 1: {
                    this.chooser.setDialogTitle(FileEditor.getString("CTL_DialogTitleDirs"));
                }
            }
            this.chooser.setFileHidingEnabled(this.fileHiding);
            this.chooser.setControlButtonsAreShown(false);
            this.chooser.addPropertyChangeListener("SelectedFileChangedProperty", this);
            HelpCtx.setHelpIDString((JComponent)this.chooser, (String)this.getHelpCtx().getHelpID());
        }
        return this.chooser;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public String getJavaInitializationString() {
        File file = (File)this.getValue();
        if (file == null) {
            return "null";
        }
        if (this.baseDirectory != null && !file.isAbsolute()) {
            return "new java.io.File(" + FileEditor.stringify(this.baseDirectory.getPath()) + ", " + FileEditor.stringify(file.getPath()) + ")";
        }
        return "new java.io.File(" + FileEditor.stringify(file.getAbsolutePath()) + ")";
    }

    static String stringify(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2 + 2);
        stringBuilder.append('\"');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' || c == '\"') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    private HelpCtx getHelpCtx() {
        return new HelpCtx(FileEditor.class);
    }

    private static String getString(String string) {
        return NbBundle.getBundle(FileEditor.class).getString(string);
    }

    static String getChildRelativePath(File file, File file2) {
        if (file2.equals(file)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(file2.getPath().length());
        stringBuilder.append(file2.getName());
        for (File file3 = file2.getParentFile(); file3 != null; file3 = file3.getParentFile()) {
            if (file3.equals(file)) {
                return stringBuilder.toString();
            }
            stringBuilder.insert(0, File.separatorChar);
            stringBuilder.insert(0, file3.getName());
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        if (!this.files && file.isFile()) {
            return;
        }
        if (!this.directories && file.isDirectory()) {
            return;
        }
        if (this.baseDirectory != null && (string = FileEditor.getChildRelativePath(this.baseDirectory, file)) != null) {
            file = new File(string);
        }
        this.setValue(new File(file.getPath()));
        lastCurrentDir = jFileChooser.getCurrentDirectory();
    }

    public static JFileChooser createHackedFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        FileEditor.hackFileChooser(jFileChooser);
        return jFileChooser;
    }

    public static void hackFileChooser(final JFileChooser jFileChooser) {
        jFileChooser.getAccessibleContext().setAccessibleDescription(FileEditor.getString("ACSD_FileEditor"));
        final Object object = jFileChooser.getInputMap(1).get(KeyStroke.getKeyStroke(27, 0));
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object2;
                Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (object != null && (object2 = jFileChooser.getActionMap().get(object)) != null) {
                    object2.actionPerformed(actionEvent);
                }
                if (component.getParent() == null) {
                    return;
                }
                object2 = jFileChooser.getTopLevelAncestor();
                if (object2 instanceof Dialog && ((Dialog)object2).isVisible()) {
                    ((Dialog)object2).setVisible(false);
                    ((Dialog)object2).dispose();
                }
            }
        };
        jFileChooser.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "close");
        jFileChooser.getActionMap().put("close", abstractAction);
    }

    static class DelegatingFilenameFilter
    extends javax.swing.filechooser.FileFilter {
        private FilenameFilter filter;

        public DelegatingFilenameFilter(FilenameFilter filenameFilter) {
            this.filter = filenameFilter;
        }

        @Override
        public boolean accept(File file) {
            return this.filter.accept(file.getParentFile(), file.getName());
        }

        @Override
        public String getDescription() {
            return null;
        }
    }

    static class DelegatingFileFilter
    extends javax.swing.filechooser.FileFilter {
        private FileFilter filter;

        public DelegatingFileFilter(FileFilter fileFilter) {
            this.filter = fileFilter;
        }

        @Override
        public boolean accept(File file) {
            return this.filter.accept(file);
        }

        @Override
        public String getDescription() {
            return null;
        }
    }

    private static class ButtonHider
    implements PropertyChangeListener {
        private ButtonHider() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("ControlButtonsAreShownChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
                JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
                try {
                    this.hideShowButtons(jFileChooser, Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
                }
                catch (Exception exception) {
                    Logger.getLogger(FileEditor.class.getName()).log(Level.WARNING, null, exception);
                }
            }
        }

        private void hideShowButtons(Container container, boolean bl) {
            if (container instanceof JComboBox || container instanceof JScrollBar) {
                return;
            }
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] instanceof Container) {
                    this.hideShowButtons((Container)componentArray[i], bl);
                }
                if (!(componentArray[i] instanceof AbstractButton)) continue;
                componentArray[i].setVisible(bl);
            }
        }
    }
}

