/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvectors;

import com.carrotsearch.hppc.ObjectLongHashMap;
import com.carrotsearch.hppc.cursors.ObjectLongCursor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BoostAttribute;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;

public final class TermVectorsFields
extends Fields {
    private final ObjectLongHashMap<String> fieldMap;
    private final BytesReference termVectors;
    final boolean hasTermStatistic;
    final boolean hasFieldStatistic;
    public final boolean hasScores;

    public TermVectorsFields(BytesReference headerRef, BytesReference termVectors) throws IOException {
        StreamInput header = headerRef.streamInput();
        this.fieldMap = new ObjectLongHashMap();
        String headerString = header.readString();
        assert (headerString.equals("TV"));
        int version = header.readInt();
        assert (version == -1);
        this.hasTermStatistic = header.readBoolean();
        this.hasFieldStatistic = header.readBoolean();
        this.hasScores = header.readBoolean();
        int numFields = header.readVInt();
        for (int i = 0; i < numFields; ++i) {
            this.fieldMap.put((Object)header.readString(), header.readVLong());
        }
        header.close();
        this.termVectors = termVectors;
    }

    public Iterator<String> iterator() {
        final Iterator iterator = this.fieldMap.iterator();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public String next() {
                return (String)((ObjectLongCursor)iterator.next()).key;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Terms terms(String field) throws IOException {
        int keySlot = this.fieldMap.indexOf((Object)field);
        if (keySlot < 0) {
            return null;
        }
        long readOffset = this.fieldMap.indexGet(keySlot);
        return new TermVector(this.termVectors, readOffset);
    }

    public int size() {
        return this.fieldMap.size();
    }

    int readPotentiallyNegativeVInt(StreamInput stream) throws IOException {
        return stream.readVInt() - 1;
    }

    long readPotentiallyNegativeVLong(StreamInput stream) throws IOException {
        return stream.readVLong() - 1L;
    }

    private final class TermVectorPostingsEnum
    extends PostingsEnum {
        private boolean hasPositions;
        private boolean hasOffsets;
        private boolean hasPayloads;
        int curPos = -1;
        int doc = -1;
        private int freq;
        private int[] startOffsets;
        private int[] positions;
        private BytesRefBuilder[] payloads;
        private int[] endOffsets;

        private TermVectorPostingsEnum() {
        }

        private PostingsEnum reset(int[] positions, int[] startOffsets, int[] endOffsets, BytesRefBuilder[] payloads, int freq) {
            this.curPos = -1;
            this.doc = -1;
            this.hasPositions = positions != null;
            this.hasOffsets = startOffsets != null;
            this.hasPayloads = payloads != null;
            this.freq = freq;
            this.startOffsets = startOffsets;
            this.endOffsets = endOffsets;
            this.payloads = payloads;
            this.positions = positions;
            return this;
        }

        public int nextDoc() throws IOException {
            this.doc = this.doc == -1 ? 0 : Integer.MAX_VALUE;
            return this.doc;
        }

        public int docID() {
            return this.doc;
        }

        public int advance(int target) throws IOException {
            while (this.nextDoc() < target && this.doc != Integer.MAX_VALUE) {
            }
            return this.doc;
        }

        public int freq() throws IOException {
            return this.freq;
        }

        public int startOffset() throws IOException {
            assert (this.curPos < this.freq && this.curPos >= 0);
            return this.hasOffsets ? this.startOffsets[this.curPos] : -1;
        }

        public int nextPosition() throws IOException {
            assert (this.curPos + 1 < this.freq);
            ++this.curPos;
            return this.hasPositions ? this.positions[this.curPos] : -1;
        }

        public BytesRef getPayload() throws IOException {
            BytesRefBuilder payload;
            assert (this.curPos < this.freq && this.curPos >= 0);
            if (this.hasPayloads && (payload = this.payloads[this.curPos]) != null) {
                return payload.get();
            }
            return null;
        }

        public int endOffset() throws IOException {
            assert (this.curPos < this.freq && this.curPos >= 0);
            return this.hasOffsets ? this.endOffsets[this.curPos] : -1;
        }

        public long cost() {
            return 1L;
        }
    }

    private final class TermVector
    extends Terms {
        private final StreamInput perFieldTermVectorInput;
        private final long readOffset;
        private long numTerms;
        private boolean hasPositions;
        private boolean hasOffsets;
        private boolean hasPayloads;
        private long sumTotalTermFreq;
        private long sumDocFreq;
        private int docCount;

        public TermVector(BytesReference termVectors, long readOffset) throws IOException {
            this.perFieldTermVectorInput = termVectors.streamInput();
            this.readOffset = readOffset;
            this.reset();
        }

        private void reset() throws IOException {
            this.perFieldTermVectorInput.reset();
            this.perFieldTermVectorInput.skip(this.readOffset);
            this.numTerms = this.perFieldTermVectorInput.readVLong();
            this.hasPositions = this.perFieldTermVectorInput.readBoolean();
            this.hasOffsets = this.perFieldTermVectorInput.readBoolean();
            this.hasPayloads = this.perFieldTermVectorInput.readBoolean();
            this.sumTotalTermFreq = TermVectorsFields.this.hasFieldStatistic ? TermVectorsFields.this.readPotentiallyNegativeVLong(this.perFieldTermVectorInput) : -1L;
            this.sumDocFreq = TermVectorsFields.this.hasFieldStatistic ? TermVectorsFields.this.readPotentiallyNegativeVLong(this.perFieldTermVectorInput) : -1L;
            this.docCount = TermVectorsFields.this.hasFieldStatistic ? TermVectorsFields.this.readPotentiallyNegativeVInt(this.perFieldTermVectorInput) : -1;
        }

        public TermsEnum iterator() throws IOException {
            this.reset();
            return new TermsEnum(){
                int currentTerm = 0;
                int freq = 0;
                int docFreq = -1;
                long totalTermFrequency = -1L;
                int[] positions = new int[1];
                int[] startOffsets = new int[1];
                int[] endOffsets = new int[1];
                BytesRefBuilder[] payloads = new BytesRefBuilder[1];
                final BytesRefBuilder spare = new BytesRefBuilder();
                BoostAttribute boostAtt = (BoostAttribute)this.attributes().addAttribute(BoostAttribute.class);

                public BytesRef next() throws IOException {
                    if ((long)this.currentTerm++ < TermVector.this.numTerms) {
                        int termVectorSize = TermVector.this.perFieldTermVectorInput.readVInt();
                        this.spare.grow(termVectorSize);
                        TermVector.this.perFieldTermVectorInput.readBytes(this.spare.bytes(), 0, termVectorSize);
                        this.spare.setLength(termVectorSize);
                        if (TermVectorsFields.this.hasTermStatistic) {
                            this.docFreq = TermVectorsFields.this.readPotentiallyNegativeVInt(TermVector.this.perFieldTermVectorInput);
                            this.totalTermFrequency = TermVectorsFields.this.readPotentiallyNegativeVLong(TermVector.this.perFieldTermVectorInput);
                        }
                        this.freq = TermVectorsFields.this.readPotentiallyNegativeVInt(TermVector.this.perFieldTermVectorInput);
                        this.growBuffers();
                        this.writeInfos(TermVector.this.perFieldTermVectorInput);
                        if (TermVectorsFields.this.hasScores) {
                            this.boostAtt.setBoost(TermVector.this.perFieldTermVectorInput.readFloat());
                        }
                        return this.spare.get();
                    }
                    return null;
                }

                private void writeInfos(StreamInput input) throws IOException {
                    for (int i = 0; i < this.freq; ++i) {
                        if (TermVector.this.hasPositions) {
                            this.positions[i] = input.readVInt();
                        }
                        if (TermVector.this.hasOffsets) {
                            this.startOffsets[i] = input.readVInt();
                            this.endOffsets[i] = input.readVInt();
                        }
                        if (!TermVector.this.hasPayloads) continue;
                        int payloadLength = input.readVInt();
                        if (this.payloads[i] == null) {
                            this.payloads[i] = new BytesRefBuilder();
                        }
                        this.payloads[i].grow(payloadLength);
                        input.readBytes(this.payloads[i].bytes(), 0, payloadLength);
                        this.payloads[i].setLength(payloadLength);
                    }
                }

                private void growBuffers() {
                    if (TermVector.this.hasPositions) {
                        this.positions = ArrayUtil.grow((int[])this.positions, (int)this.freq);
                    }
                    if (TermVector.this.hasOffsets) {
                        this.startOffsets = ArrayUtil.grow((int[])this.startOffsets, (int)this.freq);
                        this.endOffsets = ArrayUtil.grow((int[])this.endOffsets, (int)this.freq);
                    }
                    if (TermVector.this.hasPayloads && this.payloads.length < this.freq) {
                        this.payloads = Arrays.copyOf(this.payloads, ArrayUtil.oversize((int)this.freq, (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF));
                    }
                }

                public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public void seekExact(long ord) throws IOException {
                    throw new UnsupportedOperationException("Seek is not supported");
                }

                public BytesRef term() throws IOException {
                    return this.spare.get();
                }

                public long ord() throws IOException {
                    throw new UnsupportedOperationException("ordinals are not supported");
                }

                public int docFreq() throws IOException {
                    return this.docFreq;
                }

                public long totalTermFreq() throws IOException {
                    return this.totalTermFrequency;
                }

                public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
                    TermVectorPostingsEnum retVal = reuse instanceof TermVectorPostingsEnum ? (TermVectorPostingsEnum)reuse : new TermVectorPostingsEnum();
                    return retVal.reset(TermVector.this.hasPositions ? this.positions : null, TermVector.this.hasOffsets ? this.startOffsets : null, TermVector.this.hasOffsets ? this.endOffsets : null, TermVector.this.hasPayloads ? this.payloads : null, this.freq);
                }
            };
        }

        public long size() throws IOException {
            return this.numTerms;
        }

        public long getSumTotalTermFreq() throws IOException {
            return this.sumTotalTermFreq;
        }

        public long getSumDocFreq() throws IOException {
            return this.sumDocFreq;
        }

        public int getDocCount() throws IOException {
            return this.docCount;
        }

        public boolean hasFreqs() {
            return true;
        }

        public boolean hasOffsets() {
            return this.hasOffsets;
        }

        public boolean hasPositions() {
            return this.hasPositions;
        }

        public boolean hasPayloads() {
            return this.hasPayloads;
        }
    }
}

