/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.joda.DateMathParser;
import org.elasticsearch.common.lucene.all.AllTermQuery;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.TypeFieldMapper;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.search.DocValueFormat;
import org.joda.time.DateTimeZone;

public abstract class MappedFieldType
extends FieldType {
    private String name;
    private float boost;
    private boolean docValues;
    private NamedAnalyzer indexAnalyzer;
    private NamedAnalyzer searchAnalyzer;
    private NamedAnalyzer searchQuoteAnalyzer;
    private SimilarityProvider similarity;
    private Object nullValue;
    private String nullValueAsString;
    private boolean eagerGlobalOrdinals;

    protected MappedFieldType(MappedFieldType ref) {
        super((FieldType)ref);
        this.name = ref.name();
        this.boost = ref.boost();
        this.docValues = ref.hasDocValues();
        this.indexAnalyzer = ref.indexAnalyzer();
        this.searchAnalyzer = ref.searchAnalyzer();
        this.searchQuoteAnalyzer = ref.searchQuoteAnalyzer();
        this.similarity = ref.similarity();
        this.nullValue = ref.nullValue();
        this.nullValueAsString = ref.nullValueAsString();
        this.eagerGlobalOrdinals = ref.eagerGlobalOrdinals;
    }

    public MappedFieldType() {
        this.setTokenized(true);
        this.setStored(false);
        this.setStoreTermVectors(false);
        this.setOmitNorms(false);
        this.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        this.setBoost(1.0f);
    }

    public abstract MappedFieldType clone();

    public IndexFieldData.Builder fielddataBuilder() {
        throw new IllegalArgumentException("Fielddata is not supported on field [" + this.name() + "] of type [" + this.typeName() + "]");
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        MappedFieldType fieldType = (MappedFieldType)((Object)o);
        if (this.similarity == null || fieldType.similarity == null ? this.similarity != fieldType.similarity : !Objects.equals(this.similarity.name(), fieldType.similarity.name())) {
            return false;
        }
        return this.boost == fieldType.boost && this.docValues == fieldType.docValues && Objects.equals(this.name, fieldType.name) && Objects.equals((Object)this.indexAnalyzer, (Object)fieldType.indexAnalyzer) && Objects.equals((Object)this.searchAnalyzer, (Object)fieldType.searchAnalyzer) && Objects.equals((Object)this.searchQuoteAnalyzer(), (Object)fieldType.searchQuoteAnalyzer()) && Objects.equals(this.eagerGlobalOrdinals, fieldType.eagerGlobalOrdinals) && Objects.equals(this.nullValue, fieldType.nullValue) && Objects.equals(this.nullValueAsString, fieldType.nullValueAsString);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.name, Float.valueOf(this.boost), this.docValues, this.indexAnalyzer, this.searchAnalyzer, this.searchQuoteAnalyzer, this.eagerGlobalOrdinals, this.similarity == null ? null : this.similarity.name(), this.nullValue, this.nullValueAsString});
    }

    public abstract String typeName();

    private void checkTypeName(MappedFieldType other) {
        if (!this.typeName().equals(other.typeName())) {
            throw new IllegalArgumentException("mapper [" + this.name + "] cannot be changed from type [" + this.typeName() + "] to [" + other.typeName() + "]");
        }
        if (((Object)((Object)this)).getClass() != ((Object)((Object)other)).getClass()) {
            throw new IllegalStateException("Type names equal for class " + ((Object)((Object)this)).getClass().getSimpleName() + " and " + ((Object)((Object)other)).getClass().getSimpleName());
        }
    }

    public void checkCompatibility(MappedFieldType other, List<String> conflicts, boolean strict) {
        boolean mergeWithIndexed;
        this.checkTypeName(other);
        boolean indexed = this.indexOptions() != IndexOptions.NONE;
        boolean bl = mergeWithIndexed = other.indexOptions() != IndexOptions.NONE;
        if (indexed != mergeWithIndexed || this.tokenized() != other.tokenized()) {
            conflicts.add("mapper [" + this.name() + "] has different [index] values");
        }
        if (this.stored() != other.stored()) {
            conflicts.add("mapper [" + this.name() + "] has different [store] values");
        }
        if (this.hasDocValues() != other.hasDocValues()) {
            conflicts.add("mapper [" + this.name() + "] has different [doc_values] values");
        }
        if (this.omitNorms() && !other.omitNorms()) {
            conflicts.add("mapper [" + this.name() + "] has different [norms] values, cannot change from disable to enabled");
        }
        if (this.storeTermVectors() != other.storeTermVectors()) {
            conflicts.add("mapper [" + this.name() + "] has different [store_term_vector] values");
        }
        if (this.storeTermVectorOffsets() != other.storeTermVectorOffsets()) {
            conflicts.add("mapper [" + this.name() + "] has different [store_term_vector_offsets] values");
        }
        if (this.storeTermVectorPositions() != other.storeTermVectorPositions()) {
            conflicts.add("mapper [" + this.name() + "] has different [store_term_vector_positions] values");
        }
        if (this.storeTermVectorPayloads() != other.storeTermVectorPayloads()) {
            conflicts.add("mapper [" + this.name() + "] has different [store_term_vector_payloads] values");
        }
        if (this.indexAnalyzer() == null || "default".equals(this.indexAnalyzer().name())) {
            if (other.indexAnalyzer() != null && !"default".equals(other.indexAnalyzer().name())) {
                conflicts.add("mapper [" + this.name() + "] has different [analyzer]");
            }
        } else if (other.indexAnalyzer() == null || "default".equals(other.indexAnalyzer().name())) {
            conflicts.add("mapper [" + this.name() + "] has different [analyzer]");
        } else if (!this.indexAnalyzer().name().equals(other.indexAnalyzer().name())) {
            conflicts.add("mapper [" + this.name() + "] has different [analyzer]");
        }
        if (!Objects.equals(this.similarity(), other.similarity())) {
            conflicts.add("mapper [" + this.name() + "] has different [similarity]");
        }
        if (strict) {
            if (this.omitNorms() != other.omitNorms()) {
                conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [omit_norms] across all types.");
            }
            if (this.boost() != other.boost()) {
                conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [boost] across all types.");
            }
            if (!Objects.equals((Object)this.searchAnalyzer(), (Object)other.searchAnalyzer())) {
                conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [search_analyzer] across all types.");
            }
            if (!Objects.equals((Object)this.searchQuoteAnalyzer(), (Object)other.searchQuoteAnalyzer())) {
                conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [search_quote_analyzer] across all types.");
            }
            if (!Objects.equals(this.nullValue(), other.nullValue())) {
                conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [null_value] across all types.");
            }
            if (this.eagerGlobalOrdinals() != other.eagerGlobalOrdinals()) {
                conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [eager_global_ordinals] across all types.");
            }
        }
    }

    public String name() {
        return this.name;
    }

    public void setName(String name) {
        this.checkIfFrozen();
        this.name = name;
    }

    public float boost() {
        return this.boost;
    }

    public void setBoost(float boost) {
        this.checkIfFrozen();
        this.boost = boost;
    }

    public boolean hasDocValues() {
        return this.docValues;
    }

    public void setHasDocValues(boolean hasDocValues) {
        this.checkIfFrozen();
        this.docValues = hasDocValues;
    }

    public NamedAnalyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public void setIndexAnalyzer(NamedAnalyzer analyzer) {
        this.checkIfFrozen();
        this.indexAnalyzer = analyzer;
    }

    public NamedAnalyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public void setSearchAnalyzer(NamedAnalyzer analyzer) {
        this.checkIfFrozen();
        this.searchAnalyzer = analyzer;
    }

    public NamedAnalyzer searchQuoteAnalyzer() {
        return this.searchQuoteAnalyzer == null ? this.searchAnalyzer : this.searchQuoteAnalyzer;
    }

    public void setSearchQuoteAnalyzer(NamedAnalyzer analyzer) {
        this.checkIfFrozen();
        this.searchQuoteAnalyzer = analyzer;
    }

    public SimilarityProvider similarity() {
        return this.similarity;
    }

    public void setSimilarity(SimilarityProvider similarity) {
        this.checkIfFrozen();
        this.similarity = similarity;
    }

    public Object nullValue() {
        return this.nullValue;
    }

    public String nullValueAsString() {
        return this.nullValueAsString;
    }

    public void setNullValue(Object nullValue) {
        this.checkIfFrozen();
        this.nullValue = nullValue;
        this.nullValueAsString = nullValue == null ? null : nullValue.toString();
    }

    public Object valueForDisplay(Object value) {
        return value;
    }

    protected boolean isSearchable() {
        return this.indexOptions() != IndexOptions.NONE;
    }

    protected boolean isAggregatable() {
        try {
            this.fielddataBuilder();
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public abstract Query termQuery(Object var1, @Nullable QueryShardContext var2);

    public Query termsQuery(List<?> values, @Nullable QueryShardContext context) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (Object value : values) {
            builder.add(this.termQuery(value, context), BooleanClause.Occur.SHOULD);
        }
        return new ConstantScoreQuery((Query)builder.build());
    }

    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
        throw new IllegalArgumentException("Field [" + this.name + "] of type [" + this.typeName() + "] does not support range queries");
    }

    public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions) {
        throw new IllegalArgumentException("Can only use fuzzy queries on keyword and text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]");
    }

    public Query prefixQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        throw new QueryShardException(context, "Can only use prefix queries on keyword and text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]", new Object[0]);
    }

    public Query regexpQuery(String value, int flags, int maxDeterminizedStates, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        throw new QueryShardException(context, "Can only use regexp queries on keyword and text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]", new Object[0]);
    }

    public Query nullValueQuery() {
        if (this.nullValue == null) {
            return null;
        }
        return new ConstantScoreQuery(this.termQuery(this.nullValue, null));
    }

    public FieldStats stats(IndexReader reader) throws IOException {
        int maxDoc = reader.maxDoc();
        Terms terms = MultiFields.getTerms((IndexReader)reader, (String)this.name());
        if (terms == null) {
            return null;
        }
        FieldStats.Text stats = new FieldStats.Text(maxDoc, terms.getDocCount(), terms.getSumDocFreq(), terms.getSumTotalTermFreq(), this.isSearchable(), this.isAggregatable(), terms.getMin(), terms.getMax());
        return stats;
    }

    public Relation isFieldWithinQuery(IndexReader reader, Object from, Object to, boolean includeLower, boolean includeUpper, DateTimeZone timeZone, DateMathParser dateMathParser, QueryRewriteContext context) throws IOException {
        return Relation.INTERSECTS;
    }

    @Nullable
    public Query queryStringTermQuery(Term term) {
        return null;
    }

    protected final void failIfNoDocValues() {
        if (!this.hasDocValues()) {
            throw new IllegalArgumentException("Can't load fielddata on [" + this.name() + "] because fielddata is unsupported on fields of type [" + this.typeName() + "]. Use doc values instead.");
        }
    }

    protected final void failIfNotIndexed() {
        if (this.indexOptions() == IndexOptions.NONE && this.pointDimensionCount() == 0) {
            throw new IllegalArgumentException("Cannot search on field [" + this.name() + "] since it is not indexed.");
        }
    }

    public boolean eagerGlobalOrdinals() {
        return this.eagerGlobalOrdinals;
    }

    public void setEagerGlobalOrdinals(boolean eagerGlobalOrdinals) {
        this.checkIfFrozen();
        this.eagerGlobalOrdinals = eagerGlobalOrdinals;
    }

    public DocValueFormat docValueFormat(@Nullable String format, DateTimeZone timeZone) {
        if (format != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom formats");
        }
        if (timeZone != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
        }
        return DocValueFormat.RAW;
    }

    public static Term extractTerm(Query termQuery) {
        while (termQuery instanceof BoostQuery) {
            termQuery = ((BoostQuery)termQuery).getQuery();
        }
        if (termQuery instanceof AllTermQuery) {
            return ((AllTermQuery)termQuery).getTerm();
        }
        if (termQuery instanceof TypeFieldMapper.TypesQuery) {
            assert (((TypeFieldMapper.TypesQuery)termQuery).getTerms().length == 1);
            return new Term("_type", ((TypeFieldMapper.TypesQuery)termQuery).getTerms()[0]);
        }
        if (!(termQuery instanceof TermQuery)) {
            throw new IllegalArgumentException("Cannot extract a term from a query of type " + termQuery.getClass() + ": " + termQuery);
        }
        return ((TermQuery)termQuery).getTerm();
    }

    public static enum Relation {
        WITHIN,
        INTERSECTS,
        DISJOINT;

    }
}

