#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: vector-binary-instances
version: 0.2.3.2
id: vector-binary-instances-0.2.3.2-5646KxzN3hJ80s4tOK0y7f
key: vector-binary-instances-0.2.3.2-5646KxzN3hJ80s4tOK0y7f
license: BSD3
maintainer: dons00@gmail.com, bos@serpentine.com, Ben Gamari <ben@smart-cactus.org>
stability: Experimental
homepage: https://github.com/bos/vector-binary-instances
synopsis: Instances of Data.Binary and Data.Serialize for vector
description:
    Instances for Binary for the types defined in the vector package,
    making it easy to serialize vectors to and from disk. We use the
    generic interface to vectors, so all vector types are supported.
    Specific instances are provided for unboxed, boxed and storable
    vectors.
    .
    To serialize a vector:
    .
    > *Data.Vector.Binary> let v = Data.Vector.fromList [1..10]
    > *Data.Vector.Binary> v
    > fromList [1,2,3,4,5,6,7,8,9,10] :: Data.Vector.Vector
    > *Data.Vector.Binary> encode v
    > Chunk "\NUL\NUL\NUL\NUL\NUL...\NUL\NUL\NUL\t\NUL\NUL\NUL\NUL\n" Empty
    .
    Which you can in turn compress before writing to disk:
    .
    > compress . encode $ v
    > Chunk "\US\139\b\NUL\NUL\N...\229\240,\254:\NUL\NUL\NUL" Empty
category: Data
author: Don Stewart
exposed: True
exposed-modules:
    Data.Vector.Binary
abi: 3e52fd32268590d4969fa280d58d9b67
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/vector-binary-instances-0.2.3.2
library-dirs: /usr/lib/ghc-8.0.1/site-local/vector-binary-instances-0.2.3.2
data-dir: /usr/share/arm-linux-ghc-8.0.1/vector-binary-instances-0.2.3.2
hs-libraries: HSvector-binary-instances-0.2.3.2-5646KxzN3hJ80s4tOK0y7f
depends:
    base-4.9.0.0 binary-0.8.3.0 vector-0.11.0.0-BEDZb5o2QOhGbIm6ky7rl6
haddock-interfaces: /usr/share/doc/haskell-vector-binary-instances/html/vector-binary-instances.haddock
haddock-html: /usr/share/doc/haskell-vector-binary-instances/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
