#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: wai-extra
version: 3.0.19
id: wai-extra-3.0.19-7cinN1107bfEgYUzpqKjj0
key: wai-extra-3.0.19-7cinN1107bfEgYUzpqKjj0
license: MIT
maintainer: michael@snoyman.com
stability: Stable
homepage: http://github.com/yesodweb/wai
synopsis: Provides some basic WAI handlers and middleware.
description:
    Provides basic WAI handler and middleware functionality:
    .
    * WAI Testing Framework
    .
    Hspec testing facilities and helpers for WAI.
    .
    * Event Source/Event Stream
    .
    Send server events to the client. Compatible with the JavaScript
    EventSource API.
    .
    * Accept Override
    .
    Override the Accept header in a request. Special handling for the
    _accept query parameter (which is used throughout WAI override the
    Accept header).
    .
    * Add Headers
    .
    WAI Middleware for adding arbitrary headers to an HTTP request.
    .
    * Clean Path
    .
    Clean a request path to a canonical form.
    .
    * GZip Compression
    .
    Negotiate HTTP payload gzip compression.
    .
    * HTTP Basic Authentication
    .
    WAI Basic Authentication Middleware which uses Authorization header.
    .
    * JSONP
    .
    \"JSON with Padding\" middleware. Automatic wrapping of JSON
    responses to convert into JSONP.
    .
    * Method Override / Post
    .
    Allows overriding of the HTTP request method via the _method query string
    parameter.
    .
    * Request Logging
    .
    Request logging middleware for development and production environments
    .
    * Request Rewrite
    .
    Rewrite request path info based on a custom conversion rules.
    .
    * Stream Files
    .
    Convert ResponseFile type responses into ResponseStream type.
    .
    * Virtual Host
    .
    Redirect incoming requests to a new host based on custom rules.
    .
    .
    API docs and the README are available at <http://www.stackage.org/package/wai-extra>.
category: Web
author: Michael Snoyman
exposed: True
exposed-modules:
    Network.Wai.Handler.CGI Network.Wai.Handler.SCGI Network.Wai.Header
    Network.Wai.Middleware.AcceptOverride
    Network.Wai.Middleware.AddHeaders Network.Wai.Middleware.Approot
    Network.Wai.Middleware.Autohead Network.Wai.Middleware.CleanPath
    Network.Wai.Middleware.Local Network.Wai.Middleware.RequestLogger
    Network.Wai.Middleware.RequestLogger.JSON
    Network.Wai.Middleware.Gzip Network.Wai.Middleware.Jsonp
    Network.Wai.Middleware.MethodOverride
    Network.Wai.Middleware.MethodOverridePost
    Network.Wai.Middleware.Rewrite Network.Wai.Middleware.StripHeaders
    Network.Wai.Middleware.Vhost Network.Wai.Middleware.HttpAuth
    Network.Wai.Middleware.StreamFile
    Network.Wai.Middleware.ForceDomain Network.Wai.Middleware.ForceSSL
    Network.Wai.Middleware.Routed Network.Wai.Parse Network.Wai.Request
    Network.Wai.UrlMap Network.Wai.Test Network.Wai.EventSource
    Network.Wai.EventSource.EventStream
hidden-modules: Network.Wai.Middleware.RequestLogger.Internal
abi: db71c8e0ceaae26de705edffb50ad9e3
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/wai-extra-3.0.19
library-dirs: /usr/lib/ghc-8.0.1/site-local/wai-extra-3.0.19
data-dir: /usr/share/arm-linux-ghc-8.0.1/wai-extra-3.0.19
hs-libraries: HSwai-extra-3.0.19-7cinN1107bfEgYUzpqKjj0
depends:
    aeson-0.11.2.0-31ZI7bFuFz27ynqHifCKlM
    ansi-terminal-0.6.2.3-AKTYR0nthhUCHW4HMZvJFX base-4.9.0.0
    base64-bytestring-1.0.0.1-In9M41tLtcS9QYt3QpGpNY
    blaze-builder-0.4.0.2-2VmGHau0mFrAjwd4n28WWF bytestring-0.10.8.1
    case-insensitive-1.2.0.7-EiN1BqaYOWgBoqFOLWTmWz containers-0.5.7.1
    cookie-0.4.2.1-DnnDAS5t2oj6QKbT9Eh839
    data-default-class-0.1.2.0-6eetmQ6CbQOLoXb6k5kODu deepseq-1.4.2.0
    directory-1.2.6.2 fast-logger-2.4.7-5q6cKzCUmhpFUH581aMKto
    http-types-0.9.1-58mzFhAgNAb9DH0XYXjd5P
    iproute-1.7.1-9hsGfRvggCmFA0ueZi5Sd9
    lifted-base-0.2.3.8-49pRtI70Gt75UpVUvp7oxA
    network-2.6.3.1-G4Up1CPKbp7DeFsnywOnGG
    old-locale-1.0.0.7-6glXNhHF891B41ZfuI8hU8
    resourcet-1.1.8-809VyiwX9IhH0X7rbGoy6q
    streaming-commons-0.1.16-67bALc5cuwv8kntiJik0Bn
    stringsearch-0.3.6.6-DVhPUcSGzzGLKEmt1U9sof
    text-1.2.2.1-FgcR4Xf0VlEHD9HLxzq9WJ time-1.6.0.1
    transformers-0.5.2.0 unix-2.7.2.0
    unix-compat-0.4.2.0-GNHotEMWE5dJ4oYFhgibIV
    vault-0.3.0.6-F37QKsKodXlCrvmF1zIJca
    void-0.7.1-BXitqvas4xpGkaFQbixoM1
    wai-3.2.1.1-3kBgN7EuSbyJsj8pT2dpLl
    wai-logger-2.3.0-7zRA0Cf9IITF25xH3p21BV
    word8-0.1.2-2E1SgvvAV2fK8vZPDHbRan
    zlib-0.6.1.2-1dMv6Gv8Q4W22Ei4thcEsU
haddock-interfaces: /usr/share/doc/haskell-wai-extra/html/wai-extra.haddock
haddock-html: /usr/share/doc/haskell-wai-extra/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
