/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Hashtable;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondIterator;
import org.jmol.script.T;
import org.jmol.shape.Shape;
import org.jmol.shapespecial.Dipole;
import org.jmol.util.C;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;

public class Dipoles
extends Shape {
    static final short DEFAULT_MAD = 10;
    static final float DEFAULT_OFFSETSIDE = 0.4f;
    public int dipoleCount = 0;
    public Dipole[] dipoles = new Dipole[4];
    private Dipole currentDipole;
    private Dipole tempDipole;
    private P3 startCoord = new P3();
    private P3 endCoord = new P3();
    private float dipoleValue;
    private boolean isUserValue;
    private boolean isBond;
    private boolean iHaveTwoEnds;
    private int atomIndex1;
    private int atomIndex2;
    private short colix;
    private V3 calculatedDipole;
    private String wildID;
    private short mad;
    private static final float E_ANG_PER_DEBYE = 0.208194f;

    public void initShape() {
    }

    public void setProperty(String propertyName, Object value, BS bs) {
        BS atomset;
        if ("init" == propertyName) {
            this.tempDipole = new Dipole();
            this.tempDipole.dipoleValue = 1.0f;
            this.tempDipole.mad = (short)10;
            this.atomIndex1 = -1;
            this.tempDipole.modelIndex = -1;
            this.dipoleValue = 0.0f;
            this.calculatedDipole = null;
            this.mad = (short)-1;
            this.iHaveTwoEnds = false;
            this.isBond = false;
            this.isUserValue = false;
            return;
        }
        if ("calculate" == propertyName) {
            try {
                this.calculatedDipole = this.vwr.calculateMolecularDipole((BS)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.info((String)("calculated molecular dipole = " + this.calculatedDipole + " " + (this.calculatedDipole == null ? "" : "" + this.calculatedDipole.length())));
            return;
        }
        if ("thisID" == propertyName) {
            this.wildID = null;
            String thisID = (String)value;
            if (thisID == null || PT.isWild((String)thisID)) {
                this.currentDipole = null;
                if (thisID != null) {
                    this.wildID = thisID.toUpperCase();
                }
                return;
            }
            this.currentDipole = this.findDipole(thisID);
            if (this.currentDipole == null) {
                this.currentDipole = this.allocDipole(thisID, "");
            }
            this.tempDipole = this.currentDipole;
            if (thisID.equals("molecular")) {
                this.getMolecular(null);
            }
            return;
        }
        if ("bonds" == propertyName) {
            this.isBond = true;
            this.currentDipole = null;
            int i = this.dipoleCount;
            while (--i >= 0) {
                if (!this.isBondDipole(i)) continue;
                return;
            }
            this.getBondDipoles();
            return;
        }
        if ("all" == propertyName) {
            this.tempDipole.lstDipoles = new Lst();
            return;
        }
        if ("on" == propertyName) {
            this.setPropertyTok(1073742335, this.isBond, 0, 0.0f);
            return;
        }
        if ("off" == propertyName) {
            this.setPropertyTok(1073742334, this.isBond, 0, 0.0f);
            return;
        }
        if ("delete" == propertyName) {
            if (this.wildID == null && this.currentDipole == null) {
                this.clear(false);
                return;
            }
            this.setPropertyTok(12291, this.isBond, 0, 0.0f);
            return;
        }
        if ("width" == propertyName) {
            this.mad = this.tempDipole.mad = (short)(((Float)value).floatValue() * 1000.0f);
            if (this.currentDipole == null) {
                this.setPropertyTok(659488, this.isBond, this.mad, 0.0f);
            }
            return;
        }
        if ("offset" == propertyName) {
            float offset = this.tempDipole.offsetAngstroms = ((Float)value).floatValue();
            if (this.currentDipole == null) {
                this.setPropertyTok(1611272194, this.isBond, 0, offset);
            }
            return;
        }
        if ("offsetPt" == propertyName) {
            this.tempDipole.offsetPt = (P3)value;
            if (this.currentDipole != null) {
                this.currentDipole.setOffsetPt(this.tempDipole.offsetPt);
            }
            return;
        }
        if ("offsetPercent" == propertyName) {
            int offsetPercent = this.tempDipole.offsetPercent = ((Integer)value).intValue();
            if (this.tempDipole.dipoleValue != 0.0f) {
                this.tempDipole.offsetAngstroms = (float)offsetPercent / 100.0f * this.tempDipole.dipoleValue;
            }
            if (this.currentDipole == null) {
                this.setPropertyTok(268435634, this.isBond, 0, (float)offsetPercent / 100.0f);
            }
            return;
        }
        if ("offsetSide" == propertyName) {
            float offsetSide = ((Float)value).floatValue();
            this.setPropertyTok(2097178, this.isBond, 0, offsetSide);
            return;
        }
        if ("cross" == propertyName) {
            this.setPropertyTok(1275069442, this.isBond, (Boolean)value != false ? 1 : 0, 0.0f);
            return;
        }
        if ("color" == propertyName) {
            this.colix = C.getColixO((Object)value);
            if (this.isBond) {
                this.setColixDipole(this.colix, 1023, bs);
            } else if (value != null) {
                this.setPropertyTok(1765808134, false, 0, 0.0f);
            }
            return;
        }
        if ("translucency" == propertyName) {
            this.setPropertyTok(603979967, this.isBond, value.equals("translucent") ? 1 : 0, 0.0f);
            return;
        }
        if ("clear" == propertyName) {
            this.currentDipole = null;
            this.clear(false);
        }
        if ("clearBonds" == propertyName) {
            this.clear(true);
        }
        if ("startSet" == propertyName) {
            BS bsAtoms = (BS)value;
            this.endCoord = null;
            this.startCoord = this.ms.getAtomSetCenter(bsAtoms);
            this.tempDipole.set2Value(this.startCoord, P3.new3((float)0.0f, (float)0.0f, (float)0.0f), this.dipoleValue);
            if (bsAtoms.cardinality() == 1) {
                this.atomIndex1 = bsAtoms.nextSetBit(0);
            }
            return;
        }
        if ("atomBitset" == propertyName) {
            atomset = (BS)value;
            switch (atomset.cardinality()) {
                case 0: {
                    return;
                }
                case 1: {
                    break;
                }
                case 2: {
                    this.atomIndex1 = atomset.nextSetBit(0);
                    this.startCoord = this.ms.at[this.atomIndex1];
                    atomset.clear(this.atomIndex1);
                    break;
                }
                default: {
                    this.getMolecular(atomset);
                    return;
                }
            }
            propertyName = "endSet";
        }
        if ("endSet" == propertyName) {
            this.iHaveTwoEnds = true;
            atomset = (BS)value;
            if (this.atomIndex1 >= 0 && atomset.cardinality() == 1) {
                this.atomIndex2 = atomset.nextSetBit(0);
                this.tempDipole.set2AtomValue(this.ms.at[this.atomIndex1], this.ms.at[this.atomIndex2], 1.0f);
                this.currentDipole = this.findDipoleFor(this.tempDipole.thisID, this.tempDipole.dipoleInfo);
                this.tempDipole.thisID = this.currentDipole.thisID;
                if (this.isSameAtoms(this.currentDipole, this.tempDipole.dipoleInfo)) {
                    this.tempDipole = this.currentDipole;
                    if (this.dipoleValue > 0.0f) {
                        this.tempDipole.dipoleValue = this.dipoleValue;
                    }
                    if (this.mad > 0) {
                        this.tempDipole.mad = this.mad;
                    }
                }
            } else {
                this.tempDipole.set2Value(this.startCoord, this.ms.getAtomSetCenter(atomset), this.dipoleValue);
            }
            return;
        }
        if ("startCoord" == propertyName) {
            this.startCoord.setT((T3)((P3)value));
            this.tempDipole.set2Value(this.startCoord, P3.new3((float)0.0f, (float)0.0f, (float)0.0f), this.dipoleValue);
            return;
        }
        if ("endCoord" == propertyName) {
            this.iHaveTwoEnds = true;
            this.endCoord.setT((T3)((P3)value));
            this.tempDipole.set2Value(this.startCoord, this.endCoord, this.dipoleValue);
            this.dumpDipoles("endCoord");
            return;
        }
        if ("value" == propertyName) {
            this.dipoleValue = ((Float)value).floatValue();
            this.isUserValue = true;
            this.tempDipole.setValue(this.dipoleValue);
            if (this.tempDipole.offsetPercent != 0) {
                this.tempDipole.offsetAngstroms = (float)this.tempDipole.offsetPercent / 100.0f * this.tempDipole.dipoleValue;
            }
            return;
        }
        if ("set" == propertyName) {
            if (this.isBond || !this.iHaveTwoEnds && this.tempDipole.bsMolecule == null) {
                return;
            }
            this.setDipole();
            this.setModelIndex();
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            int modelIndex = ((int[])((Object[])value)[2])[0];
            int i = this.dipoleCount;
            while (--i >= 0) {
                if (this.dipoles[i].modelIndex > modelIndex) {
                    --this.dipoles[i].modelIndex;
                    continue;
                }
                if (this.dipoles[i].modelIndex != modelIndex) continue;
                if (this.dipoles[i] == this.currentDipole) {
                    this.currentDipole = null;
                }
                this.dipoles = (Dipole[])AU.deleteElements((Object)this.dipoles, (int)i, (int)1);
                --this.dipoleCount;
            }
            this.currentDipole = null;
            return;
        }
    }

    private void getMolecular(BS bsMolecule) {
        V3 v;
        V3 v3 = v = bsMolecule == null ? this.calculatedDipole : null;
        if (v == null && bsMolecule == null) {
            v = this.vwr.getModelDipole();
            Logger.info((String)("file molecular dipole = " + v + " " + (v != null ? "" + v.length() : "")));
        }
        if (v == null) {
            try {
                this.calculatedDipole = v = this.vwr.calculateMolecularDipole(bsMolecule);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (v == null) {
            Logger.warn((String)"No molecular dipole found for this model; setting to {0 0 0}");
            v = new V3();
        }
        this.tempDipole.bsMolecule = bsMolecule;
        this.tempDipole.setPtVector(P3.new3((float)0.0f, (float)0.0f, (float)0.0f), V3.new3((float)(-v.x), (float)(-v.y), (float)(-v.z)));
        if (this.tempDipole.lstDipoles != null) {
            this.getAllMolecularDipoles(bsMolecule);
        }
        this.tempDipole.type = (short)4;
        if (this.currentDipole == null || this.currentDipole.thisID == null || bsMolecule == null) {
            this.tempDipole.thisID = "molecular";
        }
        this.setDipole();
    }

    private void getAllMolecularDipoles(BS bsAtoms) {
        JmolMolecule[] mols = this.ms.getMolecules();
        int i = mols.length;
        while (--i >= 0) {
            JmolMolecule m = mols[i];
            if (!m.atomList.intersects(bsAtoms)) continue;
            V3 v = null;
            try {
                v = this.vwr.calculateMolecularDipole(m.atomList);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (v == null) continue;
            P3 center = this.ms.getAtomSetCenter(m.atomList);
            this.tempDipole.lstDipoles.addLast((Object)new Object[]{v, center, m.atomList});
        }
    }

    private void setPropertyTok(int tok, boolean bondOnly, int iValue, float fValue) {
        if (this.currentDipole != null) {
            this.setPropertyFor(tok, this.currentDipole, iValue, fValue);
        } else {
            int i = this.dipoleCount;
            while (--i >= 0) {
                if (bondOnly && !this.isBondDipole(i) || this.wildID != null && !PT.isMatch((String)this.dipoles[i].thisID.toUpperCase(), (String)this.wildID, (boolean)true, (boolean)true)) continue;
                this.setPropertyFor(tok, this.dipoles[i], iValue, fValue);
            }
        }
    }

    private void setPropertyFor(int tok, Dipole dipole, int iValue, float fValue) {
        switch (tok) {
            case 1073742335: {
                dipole.visible = true;
                return;
            }
            case 1073742334: {
                dipole.visible = false;
                return;
            }
            case 12291: {
                this.deleteDipole(dipole);
                return;
            }
            case 659488: {
                dipole.mad = this.tempDipole.mad = (short)iValue;
                return;
            }
            case 1611272194: {
                dipole.offsetAngstroms = fValue;
                return;
            }
            case 268435634: {
                dipole.offsetAngstroms = fValue * dipole.dipoleValue;
                return;
            }
            case 2097178: {
                dipole.offsetSide = fValue;
                return;
            }
            case 1275069442: {
                dipole.noCross = iValue == 0;
                return;
            }
            case 1765808134: {
                dipole.colix = this.colix;
                return;
            }
            case 603979967: {
                dipole.setTranslucent(iValue == 1, this.translucentLevel);
                return;
            }
        }
        Logger.error((String)("Unkown dipole property! " + T.nameOf((int)tok)));
    }

    public boolean getPropertyData(String property, Object[] data) {
        if (property == "getNames") {
            // empty if block
        }
        if (property == "checkID") {
            String key = ((String)data[0]).toUpperCase();
            boolean isWild = PT.isWild((String)key);
            int i = this.dipoleCount;
            while (--i >= 0) {
                String id = this.dipoles[i].thisID;
                if (!id.equalsIgnoreCase(key) && (!isWild || !PT.isMatch((String)id.toUpperCase(), (String)key, (boolean)true, (boolean)true))) continue;
                data[1] = id;
                return true;
            }
            return false;
        }
        return this.getPropShape(property, data);
    }

    public Object getProperty(String property, int index) {
        if (property.equals("list")) {
            return this.getShapeState();
        }
        return null;
    }

    private void getBondDipoles() {
        float[] partialCharges = this.ms.getPartialCharges();
        if (partialCharges == null) {
            return;
        }
        this.clear(true);
        Bond[] bonds = this.ms.bo;
        int i = this.ms.bondCount;
        while (--i >= 0) {
            float c2;
            float c1;
            Bond bond = bonds[i];
            if (!bond.isCovalent() || (c1 = partialCharges[bond.atom1.i]) == (c2 = partialCharges[bond.atom2.i])) continue;
            this.setDipoleAtoms(bond.atom1, bond.atom2, c1, c2);
        }
    }

    private boolean isBondDipole(int i) {
        if (i >= this.dipoles.length || this.dipoles[i] == null) {
            return false;
        }
        return this.dipoles[i].isBondType();
    }

    private void setColixDipole(short colix, int bondTypeMask, BS bs) {
        if (colix == 2) {
            return;
        }
        BondIterator iter = this.ms.getBondIteratorForType(bondTypeMask, bs);
        while (iter.hasNext()) {
            Dipole d = this.findBondDipole(iter.next());
            if (d == null) continue;
            d.colix = colix;
        }
    }

    private void setDipole() {
        if (this.currentDipole == null) {
            this.currentDipole = this.allocDipole("", "");
        }
        this.currentDipole.set(this.tempDipole);
        this.currentDipole.isUserValue = this.isUserValue;
        this.currentDipole.modelIndex = this.vwr.am.cmi;
    }

    private void setDipoleAtoms(Atom atom1, Atom atom2, float c1, float c2) {
        Dipole dipole = this.findAtomDipole(atom1, atom2, true);
        float value = (c1 - c2) / 2.0f * atom1.distance((T3)atom2) / 0.208194f;
        if (value < 0.0f) {
            dipole.set2AtomValue(atom2, atom1, -value);
        } else {
            dipole.set2AtomValue(atom1, atom2, value);
        }
        dipole.type = (short)3;
        dipole.modelIndex = atom1.mi;
    }

    private int getDipoleIndexFor(String dipoleInfo, String thisID) {
        if (dipoleInfo != null && dipoleInfo.length() > 0) {
            int i = this.dipoleCount;
            while (--i >= 0) {
                if (!this.isSameAtoms(this.dipoles[i], dipoleInfo)) continue;
                return i;
            }
        }
        return this.getIndexFromName(thisID);
    }

    private boolean isSameAtoms(Dipole dipole, String dipoleInfo) {
        return dipole != null && dipole.isBondType() && (dipole.dipoleInfo + dipole.dipoleInfo).indexOf(dipoleInfo) >= 0;
    }

    private int getDipoleIndex(int atomIndex1, int atomIndex2) {
        int i = this.dipoleCount;
        while (--i >= 0) {
            if (this.dipoles[i] == null || this.dipoles[i].atoms[0] == null || this.dipoles[i].atoms[1] == null || (this.dipoles[i].atoms[0].i != atomIndex1 || this.dipoles[i].atoms[1].i != atomIndex2) && (this.dipoles[i].atoms[1].i != atomIndex1 || this.dipoles[i].atoms[0].i != atomIndex2)) continue;
            return i;
        }
        return -1;
    }

    private void deleteDipole(Dipole dipole) {
        if (dipole == null) {
            return;
        }
        if (this.currentDipole == dipole) {
            this.currentDipole = null;
        }
        int i = this.dipoleCount;
        while (this.dipoles[--i] != dipole) {
        }
        if (i < 0) {
            return;
        }
        for (int j = i + 1; j < this.dipoleCount; ++j) {
            this.dipoles[j - 1] = this.dipoles[j];
        }
        this.dipoles[--this.dipoleCount] = null;
    }

    private Dipole findDipole(String thisID) {
        int dipoleIndex = this.getIndexFromName(thisID);
        if (dipoleIndex >= 0) {
            return this.dipoles[dipoleIndex];
        }
        return null;
    }

    private Dipole findAtomDipole(Atom atom1, Atom atom2, boolean doAllocate) {
        int dipoleIndex = this.getDipoleIndex(atom1.i, atom2.i);
        if (dipoleIndex >= 0) {
            return this.dipoles[dipoleIndex];
        }
        return doAllocate ? this.allocDipole("", "") : null;
    }

    private Dipole findBondDipole(Bond bond) {
        Dipole d = this.findAtomDipole(bond.atom1, bond.atom2, false);
        return d == null || d.atoms[0] == null ? null : d;
    }

    private Dipole findDipoleFor(String thisID, String dipoleInfo) {
        int dipoleIndex = this.getDipoleIndexFor(dipoleInfo, thisID);
        if (dipoleIndex >= 0) {
            if (thisID.length() > 0) {
                this.dipoles[dipoleIndex].thisID = thisID;
            }
            return this.dipoles[dipoleIndex];
        }
        return this.allocDipole(thisID, dipoleInfo);
    }

    private Dipole allocDipole(String thisID, String dipoleInfo) {
        this.dipoles = (Dipole[])AU.ensureLength((Object)this.dipoles, (int)(this.dipoleCount + 1));
        if (thisID == null || thisID.length() == 0) {
            thisID = "dipole" + (this.dipoleCount + 1);
        }
        Dipole dipole = new Dipole().init(this.vwr.am.cmi, thisID, dipoleInfo, this.colix, (short)10, true);
        this.dipoles[this.dipoleCount++] = dipole;
        Dipole d = dipole;
        return d;
    }

    private void dumpDipoles(String msg) {
        int i = this.dipoleCount;
        while (--i >= 0) {
            Dipole dipole = this.dipoles[i];
            Logger.info((String)("\n\n" + msg + " dump dipole " + i + " " + dipole + " " + dipole.thisID + " " + dipole.dipoleInfo + " " + dipole.visibilityFlags + " mad=" + dipole.mad + " vis=" + dipole.visible + "\n orig" + dipole.origin + " " + " vect" + dipole.vector + " val=" + dipole.dipoleValue));
        }
        if (this.currentDipole != null) {
            Logger.info((String)(" current = " + this.currentDipole + this.currentDipole.origin));
        }
        if (this.tempDipole != null) {
            Logger.info((String)(" temp = " + this.tempDipole + " " + this.tempDipole.origin));
        }
    }

    private void clear(boolean clearBondDipolesOnly) {
        if (clearBondDipolesOnly) {
            int i = this.dipoleCount;
            while (--i >= 0) {
                if (!this.isBondDipole(i)) continue;
                this.deleteDipole(this.dipoles[i]);
            }
            return;
        }
        int i = this.dipoleCount;
        while (--i >= 0) {
            if (this.isBond && !this.isBondDipole(i)) continue;
            this.deleteDipole(this.dipoles[i]);
        }
    }

    public int getIndexFromName(String thisID) {
        if (thisID == null) {
            return -1;
        }
        int i = this.dipoleCount;
        while (--i >= 0) {
            if (this.dipoles[i] == null || !thisID.equals(this.dipoles[i].thisID)) continue;
            return i;
        }
        return -1;
    }

    public Object getShapeDetail() {
        Lst V = new Lst();
        P3 ptTemp = new P3();
        for (int i = 0; i < this.dipoleCount; ++i) {
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            Dipole dipole = this.dipoles[i];
            info.put("ID", dipole.thisID);
            info.put("vector", dipole.vector);
            info.put("origin", dipole.origin);
            if (dipole.bsMolecule != null) {
                info.put("bsMolecule", dipole.bsMolecule);
            } else if (dipole.atoms[0] != null) {
                Hashtable atomInfo = new Hashtable();
                this.ms.getAtomIdentityInfo(dipole.atoms[0].i, atomInfo, ptTemp);
                Lst atoms = new Lst();
                atoms.addLast(atomInfo);
                atomInfo = new Hashtable();
                this.ms.getAtomIdentityInfo(dipole.atoms[1].i, atomInfo, ptTemp);
                atoms.addLast(atomInfo);
                info.put("atoms", atoms);
                info.put("magnitude", Float.valueOf(dipole.vector.length()));
            }
            V.addLast(info);
        }
        return V;
    }

    private void setModelIndex() {
        if (this.currentDipole == null) {
            return;
        }
        this.currentDipole.visible = true;
        this.currentDipole.modelIndex = this.vwr.am.cmi;
    }

    public void setModelVisibilityFlags(BS bsModels) {
        int i = this.dipoleCount;
        while (--i >= 0) {
            Dipole dipole = this.dipoles[i];
            dipole.visibilityFlags = (dipole.modelIndex < 0 || bsModels.get(dipole.modelIndex)) && dipole.mad != 0 && dipole.visible && dipole.origin != null && dipole.vector != null && dipole.vector.length() != 0.0f && dipole.dipoleValue != 0.0f ? this.vf : 0;
        }
    }

    public String getShapeState() {
        if (this.dipoleCount == 0) {
            return "";
        }
        SB s = new SB();
        int thisModel = -1;
        int modelCount = this.vwr.ms.mc;
        for (int i = 0; i < this.dipoleCount; ++i) {
            Dipole dipole = this.dipoles[i];
            if (!dipole.isValid) continue;
            if (modelCount > 1 && dipole.modelIndex != thisModel) {
                thisModel = dipole.modelIndex;
                Dipoles.appendCmd((SB)s, (String)("frame " + this.vwr.getModelNumberDotted(thisModel)));
            }
            s.append(dipole.getShapeState());
            Dipoles.appendCmd((SB)s, (String)Dipoles.getColorCommandUnk((String)"dipole", (short)dipole.colix, (boolean)this.translucentAllowed));
        }
        return s.toString();
    }
}

