/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.spartan;

import java.util.Hashtable;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.spartan.SpartanArchive;
import org.jmol.adapter.smarter.Atom;

public class SpartanReader
extends BasisFunctionReader {
    @Override
    public void initializeReader() throws Exception {
        String cartesianHeader = "Cartesian Coordinates (Ang";
        if (this.isSpartanArchive(cartesianHeader)) {
            this.moData = new Hashtable();
            SpartanArchive spartanArchive = new SpartanArchive(this, "", null);
            int ac = spartanArchive.readArchive(this.line, true, 0, true);
            if (ac > 0) {
                this.asc.setAtomSetName("Spartan file");
            }
        } else if (this.line.indexOf(cartesianHeader) >= 0) {
            this.readAtoms();
            this.discardLinesUntilContains("Vibrational Frequencies");
            if (this.line != null) {
                this.readFrequencies();
            }
        }
        this.continuing = false;
    }

    private boolean isSpartanArchive(String strNotArchive) throws Exception {
        String lastLine = "";
        while (this.rd() != null) {
            if (this.line.equals("GEOMETRY")) {
                this.line = lastLine;
                return true;
            }
            if (this.line.indexOf(strNotArchive) >= 0) {
                return false;
            }
            lastLine = this.line;
        }
        return false;
    }

    private void readAtoms() throws Exception {
        this.discardLinesUntilBlank();
        while (this.rd() != null && this.parseIntRange(this.line, 0, 3) > 0) {
            Atom atom = this.asc.addNewAtom();
            atom.elementSymbol = this.parseTokenRange(this.line, 4, 6);
            atom.atomName = this.parseTokenRange(this.line, 7, 13);
            this.setAtomCoordXYZ(atom, this.parseFloatRange(this.line, 17, 30), this.parseFloatRange(this.line, 31, 44), this.parseFloatRange(this.line, 45, 58));
        }
    }

    private void readFrequencies() throws Exception {
        int ac = this.asc.atomSetAtomCounts[0];
        block0: while (true) {
            float frequency;
            int lineFreqCount;
            this.discardLinesUntilNonBlank();
            int lineBaseFreqCount = this.vibrationNumber;
            this.next[0] = 16;
            boolean[] ignore = new boolean[3];
            for (lineFreqCount = 0; lineFreqCount < 3 && !Float.isNaN(frequency = this.parseFloat()); ++lineFreqCount) {
                boolean bl = ignore[lineFreqCount] = !this.doGetVibration(++this.vibrationNumber);
                if (ignore[lineFreqCount]) continue;
                if (this.vibrationNumber > 1) {
                    this.asc.cloneFirstAtomSet(0);
                }
                this.asc.setAtomSetFrequency(null, null, "" + frequency, null);
            }
            if (lineFreqCount == 0) {
                return;
            }
            this.readLines(2);
            int i = 0;
            while (true) {
                if (i >= ac) continue block0;
                this.rd();
                for (int j = 0; j < lineFreqCount; ++j) {
                    int ichCoords = j * 23 + 10;
                    float x = this.parseFloatRange(this.line, ichCoords, ichCoords + 7);
                    float y = this.parseFloatRange(this.line, ichCoords + 7, ichCoords + 14);
                    float z = this.parseFloatRange(this.line, ichCoords + 14, ichCoords + 21);
                    if (ignore[j]) continue;
                    this.asc.addVibrationVector(i + (lineBaseFreqCount + j) * ac, x, y, z);
                }
                ++i;
            }
            break;
        }
    }
}

