/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.openscience.jmol.app.nbo.FileHndlr;
import org.openscience.jmol.app.nbo.NBODialog;
import org.openscience.jmol.app.nbo.NBODialogConfig;

class ArchiveViewer
extends JDialog
implements ActionListener {
    JScrollPane panel;
    JButton download;
    JCheckBox[] jcLinks;
    JTextField tfPath;
    NBODialog dialog;

    public ArchiveViewer(NBODialog d, URL url) {
        super((Dialog)d, "NBOrXiv files");
        this.dialog = d;
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        int width = gd.getDisplayMode().getWidth() / 2 - 250;
        int height = gd.getDisplayMode().getHeight() / 2 - 120;
        this.setLocation(width, height);
        this.setSize(new Dimension(500, 240));
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        this.panel = new JScrollPane();
        this.panel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.add((Component)this.panel, "Center");
        String[] links = this.getLinks(url);
        this.setLinks(links, null);
        Box bottom = Box.createHorizontalBox();
        this.tfPath = new JTextField(d.fileHndlr.fileDir);
        bottom.add(new JLabel("  Download to: "));
        bottom.add(this.tfPath);
        this.download = new JButton("Download");
        this.download.addActionListener(this);
        bottom.add(this.download);
        this.add((Component)bottom, "South");
    }

    private String[] getLinks(URL url) {
        BufferedReader in = null;
        SB files = new SB();
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((line = in.readLine()) != null) {
                String file;
                String[] toks = line.split("<a href=\"");
                if (toks.length <= 1 || !(file = toks[1].substring(0, toks[1].indexOf(34))).endsWith(".47")) continue;
                files.append(file + ";");
            }
            in.close();
        }
        catch (IOException line) {
            // empty catch block
        }
        String[] links = files.toString().split(";");
        return links;
    }

    private void setLinks(String[] links, String startsWith) {
        this.jcLinks = new JCheckBox[links.length];
        JPanel filePanel = new JPanel(new FlowLayout());
        if (startsWith == null) {
            startsWith = "";
        }
        ButtonGroup bg = new ButtonGroup();
        for (int i = 0; i < links.length; i += 6) {
            Box box = Box.createVerticalBox();
            for (int j = 0; j < 6 && i + j < this.jcLinks.length; ++j) {
                this.jcLinks[i + j] = new JCheckBox(links[i + j]);
                bg.add(this.jcLinks[i + j]);
                this.jcLinks[i + j].setBackground(Color.white);
                box.add(this.jcLinks[i + j]);
            }
            filePanel.add(box);
        }
        filePanel.setBackground(Color.white);
        this.panel.getViewport().add(filePanel);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        for (int i = 0; i < this.jcLinks.length; ++i) {
            int j;
            if (!this.jcLinks[i].isSelected()) continue;
            String path = this.tfPath.getText().trim();
            path = path.endsWith("/") || path.endsWith("\\") ? path + this.jcLinks[i].getText() : path + "/" + this.jcLinks[i].getText();
            File f = new File(path);
            if (f.exists() && (j = JOptionPane.showConfirmDialog(null, "File " + f.getAbsolutePath() + " already exists, do you want to overwrite contents?", "Warning", 0)) == 1) {
                return;
            }
            BufferedReader in = null;
            SB sb = new SB();
            try {
                String line;
                URL url = new URL("http://nbo6.chem.wisc.edu/jmol_nborxiv/" + this.jcLinks[i].getText());
                in = new BufferedReader(new InputStreamReader(url.openStream()));
                while ((line = in.readLine()) != null) {
                    sb.append(line + NBODialogConfig.sep);
                }
                in.close();
                FileHndlr.writeToFile(sb.toString(), f);
                this.dialog.vwr.alert("Download complete!\nFile saved to " + f.getAbsolutePath());
                this.dialog.fileHndlr.setInputFile(f);
                this.dialog.rbLocal.doClick();
                this.setVisible(false);
                this.dispose();
                continue;
            }
            catch (IOException e) {
                this.dialog.vwr.alert("Download failed!\nCheck internet connection.");
            }
        }
    }
}

