/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javajs.api.GenericBinaryDocument;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.Rdr;
import org.jmol.adapter.smarter.AtomIterator;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.BondIterator;
import org.jmol.adapter.smarter.Resolver;
import org.jmol.adapter.smarter.StructureIterator;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAdapterAtomIterator;
import org.jmol.api.JmolAdapterBondIterator;
import org.jmol.api.JmolAdapterStructureIterator;
import org.jmol.api.JmolFilesReaderInterface;
import org.jmol.script.SV;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class SmarterJmolAdapter
extends JmolAdapter {
    public static final String PATH_KEY = ".PATH";
    public static final String PATH_SEPARATOR = System.getProperty("path.separator", "/");

    @Override
    public String getFileTypeName(Object ascOrReader) {
        if (ascOrReader instanceof AtomSetCollection) {
            return ((AtomSetCollection)ascOrReader).fileTypeName;
        }
        if (ascOrReader instanceof BufferedReader) {
            return Resolver.getFileType((BufferedReader)ascOrReader);
        }
        if (ascOrReader instanceof InputStream) {
            return Resolver.getBinaryType((InputStream)ascOrReader);
        }
        return null;
    }

    @Override
    public Object getAtomSetCollectionReader(String name, String type, Object bufferedReader, Map<String, Object> htParams) {
        return SmarterJmolAdapter.staticGetAtomSetCollectionReader(name, type, bufferedReader, htParams);
    }

    public static Object staticGetAtomSetCollectionReader(String name, String type, Object bufferedReader, Map<String, Object> htParams) {
        try {
            Object ret = Resolver.getAtomCollectionReader(name, type, bufferedReader, htParams, -1);
            if (ret instanceof String) {
                try {
                    SmarterJmolAdapter.close(bufferedReader);
                }
                catch (Exception exception) {}
            } else {
                ((AtomSetCollectionReader)ret).setup(name, htParams, bufferedReader);
            }
            return ret;
        }
        catch (Throwable e) {
            try {
                SmarterJmolAdapter.close(bufferedReader);
            }
            catch (Exception exception) {
                // empty catch block
            }
            bufferedReader = null;
            Logger.error("" + e);
            return "" + e;
        }
    }

    @Override
    public Object getAtomSetCollectionFromReader(String fname, Object readerOrDocument, Map<String, Object> htParams) throws Exception {
        Object ret = Resolver.getAtomCollectionReader(fname, null, readerOrDocument, htParams, -1);
        if (ret instanceof AtomSetCollectionReader) {
            ((AtomSetCollectionReader)ret).setup(fname, htParams, readerOrDocument);
            return ((AtomSetCollectionReader)ret).readData();
        }
        return "" + ret;
    }

    @Override
    public Object getAtomSetCollection(Object ascReader) {
        return SmarterJmolAdapter.staticGetAtomSetCollection((AtomSetCollectionReader)ascReader);
    }

    public static Object staticGetAtomSetCollection(AtomSetCollectionReader a) {
        BufferedReader br = null;
        try {
            br = a.reader;
            Object ret = a.readData();
            if (!(ret instanceof AtomSetCollection)) {
                return ret;
            }
            AtomSetCollection asc = (AtomSetCollection)ret;
            if (asc.errorMessage != null) {
                return asc.errorMessage;
            }
            return asc;
        }
        catch (Throwable e) {
            try {
                Logger.info(e.toString());
            }
            catch (Exception ee) {
                Logger.error(e.toString());
            }
            try {
                br.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            br = null;
            Logger.error("" + e);
            return "" + e;
        }
    }

    @Override
    public Object getAtomSetCollectionReaders(JmolFilesReaderInterface filesReader, String[] names, String[] types, Map<String, Object> htParams, boolean getReadersOnly) {
        Viewer vwr = (Viewer)htParams.get("vwr");
        int size = names.length;
        Object reader = null;
        if (htParams.containsKey("concatenate")) {
            String s = "";
            for (int i = 0; i < size; ++i) {
                String name = names[i];
                String f = vwr.getFileAsString3(name, false, null);
                if (i > 0 && size <= 3 && f.startsWith("{")) {
                    String type = f.contains("version\":\"DSSR") ? "dssr" : (f.contains("/outliers/") ? "validation" : "domains");
                    Map<String, Object> x = vwr.parseJSON(f);
                    if (x == null) continue;
                    htParams.put(type, type.equals("dssr") ? x : SV.getVariableMap(x));
                    continue;
                }
                if (name.indexOf("|") >= 0) {
                    name = PT.rep(name, "_", "/");
                }
                if (i == 1) {
                    if (name.indexOf("/rna3dhub/") >= 0) {
                        s = s + "\n_rna3d \n;" + f + "\n;\n";
                        continue;
                    }
                    if (name.indexOf("/dssr/") >= 0) {
                        s = s + "\n_dssr \n;" + f + "\n;\n";
                        continue;
                    }
                }
                if ((s = s + f).endsWith("\n")) continue;
                s = s + "\n";
            }
            size = 1;
            reader = Rdr.getBR(s);
        }
        AtomSetCollectionReader[] readers = getReadersOnly ? new AtomSetCollectionReader[size] : null;
        AtomSetCollection[] atomsets = getReadersOnly ? null : new AtomSetCollection[size];
        AtomSetCollectionReader r = null;
        for (int i = 0; i < size; ++i) {
            try {
                htParams.put("vwr", vwr);
                if (reader == null) {
                    reader = filesReader.getBufferedReaderOrBinaryDocument(i, false);
                }
                if (!(reader instanceof BufferedReader) && !(reader instanceof GenericBinaryDocument)) {
                    return reader;
                }
                String fullPathName = names[i];
                htParams.put("fullPathName", fullPathName);
                Object ret = Resolver.getAtomCollectionReader(names[i], types == null ? null : types[i], reader, htParams, i);
                if (!(ret instanceof AtomSetCollectionReader)) {
                    return ret;
                }
                r = (AtomSetCollectionReader)ret;
                r.setup(null, null, null);
                if (r.isBinary) {
                    r.setup(names[i], htParams, filesReader.getBufferedReaderOrBinaryDocument(i, true));
                } else {
                    r.setup(names[i], htParams, reader);
                }
                reader = null;
                if (getReadersOnly) {
                    readers[i] = r;
                    continue;
                }
                ret = r.readData();
                if (!(ret instanceof AtomSetCollection)) {
                    return ret;
                }
                atomsets[i] = (AtomSetCollection)ret;
                if (atomsets[i].errorMessage == null) continue;
                return atomsets[i].errorMessage;
            }
            catch (Throwable e) {
                Logger.error("" + e);
                if (!vwr.isJS) {
                    e.printStackTrace();
                }
                return "" + e;
            }
        }
        if (getReadersOnly) {
            return readers;
        }
        return this.getAtomSetCollectionFromSet(readers, atomsets, htParams);
    }

    @Override
    public Object getAtomSetCollectionFromSet(Object readerSet, Object atomsets, Map<String, Object> htParams) {
        AtomSetCollection result;
        AtomSetCollection[] asc;
        AtomSetCollectionReader[] readers = (AtomSetCollectionReader[])readerSet;
        AtomSetCollection[] atomSetCollectionArray = asc = atomsets == null ? new AtomSetCollection[readers.length] : (AtomSetCollection[])atomsets;
        if (atomsets == null) {
            for (int i = 0; i < readers.length; ++i) {
                if (readers[i] == null) continue;
                try {
                    Object ret = readers[i].readData();
                    if (!(ret instanceof AtomSetCollection)) {
                        return ret;
                    }
                    asc[i] = (AtomSetCollection)ret;
                    if (asc[i].errorMessage == null) continue;
                    return asc[i].errorMessage;
                }
                catch (Throwable e) {
                    Logger.error("" + e);
                    return "" + e;
                }
            }
        }
        if (htParams.containsKey("trajectorySteps")) {
            result = asc[0];
            try {
                result.finalizeTrajectoryAs((Lst)htParams.get("trajectorySteps"), (Lst)htParams.get("vibrationSteps"));
            }
            catch (Exception e) {
                if (result.errorMessage == null) {
                    result.errorMessage = "" + e;
                }
            }
        } else if (asc[0].isTrajectory) {
            result = asc[0];
            for (int i = 1; i < asc.length; ++i) {
                asc[0].mergeTrajectories(asc[i]);
            }
        } else {
            result = asc.length == 1 ? asc[0] : new AtomSetCollection("Array", null, asc, null);
        }
        return result.errorMessage == null ? result : result.errorMessage;
    }

    @Override
    public Object getAtomSetCollectionFromDOM(Object DOMNode, Map<String, Object> htParams) {
        try {
            Object ret = Resolver.DOMResolve(htParams);
            if (!(ret instanceof AtomSetCollectionReader)) {
                return ret;
            }
            AtomSetCollectionReader a = (AtomSetCollectionReader)ret;
            a.setup("DOM node", htParams, null);
            ret = a.readDataObject(DOMNode);
            if (!(ret instanceof AtomSetCollection)) {
                return ret;
            }
            AtomSetCollection asc = (AtomSetCollection)ret;
            if (asc.errorMessage != null) {
                return asc.errorMessage;
            }
            return asc;
        }
        catch (Throwable e) {
            Logger.error("" + e);
            return "" + e;
        }
    }

    @Override
    public void finish(Object asc) {
        ((AtomSetCollection)asc).finish();
    }

    @Override
    public String getAtomSetCollectionName(Object asc) {
        return ((AtomSetCollection)asc).collectionName;
    }

    @Override
    public Map<String, Object> getAtomSetCollectionAuxiliaryInfo(Object asc) {
        return ((AtomSetCollection)asc).atomSetInfo;
    }

    @Override
    public int getAtomSetCount(Object asc) {
        return ((AtomSetCollection)asc).atomSetCount;
    }

    @Override
    public int getAtomSetNumber(Object asc, int atomSetIndex) {
        return ((AtomSetCollection)asc).getAtomSetNumber(atomSetIndex);
    }

    @Override
    public String getAtomSetName(Object asc, int atomSetIndex) {
        return ((AtomSetCollection)asc).getAtomSetName(atomSetIndex);
    }

    @Override
    public Map<String, Object> getAtomSetAuxiliaryInfo(Object asc, int atomSetIndex) {
        return ((AtomSetCollection)asc).getAtomSetAuxiliaryInfo(atomSetIndex);
    }

    @Override
    public int getHydrogenAtomCount(Object asc) {
        return ((AtomSetCollection)asc).getHydrogenAtomCount();
    }

    @Override
    public String[][] getBondList(Object asc) {
        return ((AtomSetCollection)asc).getBondList();
    }

    @Override
    public int getAtomCount(Object asc) {
        AtomSetCollection a = (AtomSetCollection)asc;
        return a.bsAtoms == null ? a.ac : a.bsAtoms.cardinality();
    }

    @Override
    public boolean coordinatesAreFractional(Object asc) {
        return ((AtomSetCollection)asc).coordinatesAreFractional;
    }

    @Override
    public JmolAdapterAtomIterator getAtomIterator(Object asc) {
        return new AtomIterator((AtomSetCollection)asc);
    }

    @Override
    public JmolAdapterBondIterator getBondIterator(Object asc) {
        return new BondIterator((AtomSetCollection)asc);
    }

    @Override
    public JmolAdapterStructureIterator getStructureIterator(Object asc) {
        return ((AtomSetCollection)asc).structureCount == 0 ? null : new StructureIterator((AtomSetCollection)asc);
    }

    public static void close(Object bufferedReader) throws IOException {
        if (bufferedReader instanceof BufferedReader) {
            ((BufferedReader)bufferedReader).close();
        } else {
            ((GenericBinaryDocument)bufferedReader).close();
        }
    }
}

