/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.Group;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.Style;
import com.kitfox.svg.xml.NumberWithUnits;
import com.kitfox.svg.xml.StyleAttribute;
import com.kitfox.svg.xml.StyleSheet;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class SVGRoot
extends Group {
    public static final String TAG_NAME = "svg";
    NumberWithUnits x;
    NumberWithUnits y;
    NumberWithUnits width;
    NumberWithUnits height;
    Rectangle2D.Float viewBox = null;
    public static final int PA_X_NONE = 0;
    public static final int PA_X_MIN = 1;
    public static final int PA_X_MID = 2;
    public static final int PA_X_MAX = 3;
    public static final int PA_Y_NONE = 0;
    public static final int PA_Y_MIN = 1;
    public static final int PA_Y_MID = 2;
    public static final int PA_Y_MAX = 3;
    public static final int PS_MEET = 0;
    public static final int PS_SLICE = 1;
    int parSpecifier = 0;
    int parAlignX = 2;
    int parAlignY = 2;
    final AffineTransform viewXform = new AffineTransform();
    final Rectangle2D.Float clipRect = new Rectangle2D.Float();
    private StyleSheet styleSheet;

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public void build() throws SVGException {
        Object object;
        super.build();
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getPres(styleAttribute.setName("x"))) {
            this.x = styleAttribute.getNumberWithUnits();
        }
        if (this.getPres(styleAttribute.setName("y"))) {
            this.y = styleAttribute.getNumberWithUnits();
        }
        if (this.getPres(styleAttribute.setName("width"))) {
            this.width = styleAttribute.getNumberWithUnits();
        }
        if (this.getPres(styleAttribute.setName("height"))) {
            this.height = styleAttribute.getNumberWithUnits();
        }
        if (this.getPres(styleAttribute.setName("viewBox"))) {
            object = styleAttribute.getFloatList();
            this.viewBox = new Rectangle2D.Float(object[0], object[1], object[2], object[3]);
        }
        if (this.getPres(styleAttribute.setName("preserveAspectRatio"))) {
            object = styleAttribute.getStringValue();
            if (this.contains((String)object, "none")) {
                this.parAlignX = 0;
                this.parAlignY = 0;
            } else if (this.contains((String)object, "xMinYMin")) {
                this.parAlignX = 1;
                this.parAlignY = 1;
            } else if (this.contains((String)object, "xMidYMin")) {
                this.parAlignX = 2;
                this.parAlignY = 1;
            } else if (this.contains((String)object, "xMaxYMin")) {
                this.parAlignX = 3;
                this.parAlignY = 1;
            } else if (this.contains((String)object, "xMinYMid")) {
                this.parAlignX = 1;
                this.parAlignY = 2;
            } else if (this.contains((String)object, "xMidYMid")) {
                this.parAlignX = 2;
                this.parAlignY = 2;
            } else if (this.contains((String)object, "xMaxYMid")) {
                this.parAlignX = 3;
                this.parAlignY = 2;
            } else if (this.contains((String)object, "xMinYMax")) {
                this.parAlignX = 1;
                this.parAlignY = 3;
            } else if (this.contains((String)object, "xMidYMax")) {
                this.parAlignX = 2;
                this.parAlignY = 3;
            } else if (this.contains((String)object, "xMaxYMax")) {
                this.parAlignX = 3;
                this.parAlignY = 3;
            }
            if (this.contains((String)object, "meet")) {
                this.parSpecifier = 0;
            } else if (this.contains((String)object, "slice")) {
                this.parSpecifier = 1;
            }
        }
        this.prepareViewport();
    }

    private boolean contains(String string, String string2) {
        return string.indexOf(string2) != -1;
    }

    @Override
    public SVGRoot getRoot() {
        return this;
    }

    protected void prepareViewport() {
        float f;
        float f2;
        float f3;
        float f4;
        Rectangle2D rectangle2D;
        Rectangle rectangle = this.diagram.getDeviceViewport();
        try {
            rectangle2D = this.getBoundingBox();
        }
        catch (SVGException sVGException) {
            rectangle2D = new Rectangle2D.Float();
        }
        if (this.width != null) {
            float f5 = f4 = this.x == null ? 0.0f : StyleAttribute.convertUnitsToPixels(this.x.getUnits(), this.x.getValue());
            f3 = this.width.getUnits() == 9 ? this.width.getValue() * (float)rectangle.width : StyleAttribute.convertUnitsToPixels(this.width.getUnits(), this.width.getValue());
        } else if (this.viewBox != null) {
            f4 = this.viewBox.x;
            f3 = this.viewBox.width;
            this.width = new NumberWithUnits(f3, 1);
            this.x = new NumberWithUnits(f4, 1);
        } else {
            f4 = (float)rectangle2D.getX();
            f3 = (float)rectangle2D.getWidth();
            this.width = new NumberWithUnits(f3, 1);
            this.x = new NumberWithUnits(f4, 1);
        }
        if (this.height != null) {
            float f6 = f2 = this.y == null ? 0.0f : StyleAttribute.convertUnitsToPixels(this.y.getUnits(), this.y.getValue());
            f = this.height.getUnits() == 9 ? this.height.getValue() * (float)rectangle.height : StyleAttribute.convertUnitsToPixels(this.height.getUnits(), this.height.getValue());
        } else if (this.viewBox != null) {
            f2 = this.viewBox.y;
            f = this.viewBox.height;
            this.height = new NumberWithUnits(f, 1);
            this.y = new NumberWithUnits(f2, 1);
        } else {
            f2 = (float)rectangle2D.getY();
            f = (float)rectangle2D.getHeight();
            this.height = new NumberWithUnits(f, 1);
            this.y = new NumberWithUnits(f2, 1);
        }
        this.clipRect.setRect(f4, f2, f3, f);
    }

    public void renderToViewport(Graphics2D graphics2D) throws SVGException {
        this.prepareViewport();
        Rectangle rectangle = graphics2D.getClipBounds();
        Rectangle rectangle2 = this.diagram.getDeviceViewport();
        if (this.width != null && this.height != null) {
            float f = this.x == null ? 0.0f : StyleAttribute.convertUnitsToPixels(this.x.getUnits(), this.x.getValue());
            float f2 = this.width.getUnits() == 9 ? this.width.getValue() * (float)rectangle2.width : StyleAttribute.convertUnitsToPixels(this.width.getUnits(), this.width.getValue());
            float f3 = this.y == null ? 0.0f : StyleAttribute.convertUnitsToPixels(this.y.getUnits(), this.y.getValue());
            float f4 = this.height.getUnits() == 9 ? this.height.getValue() * (float)rectangle2.height : StyleAttribute.convertUnitsToPixels(this.height.getUnits(), this.height.getValue());
            rectangle = new Rectangle((int)f, (int)f3, (int)f2, (int)f4);
        } else {
            rectangle = new Rectangle(rectangle2);
        }
        this.clipRect.setRect(rectangle);
        if (this.viewBox == null) {
            this.viewXform.setToIdentity();
        } else {
            this.viewXform.setToIdentity();
            this.viewXform.setToTranslation(rectangle.x, rectangle.y);
            this.viewXform.scale(rectangle.width, rectangle.height);
            this.viewXform.scale(1.0f / this.viewBox.width, 1.0f / this.viewBox.height);
            this.viewXform.translate(-this.viewBox.x, -this.viewBox.y);
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.transform(this.viewXform);
        super.render(graphics2D);
        graphics2D.setTransform(affineTransform);
    }

    @Override
    public void pick(Rectangle2D rectangle2D, AffineTransform affineTransform, boolean bl, List list) throws SVGException {
        if (this.viewXform != null) {
            affineTransform = new AffineTransform(affineTransform);
            affineTransform.concatenate(this.viewXform);
        }
        super.pick(rectangle2D, affineTransform, bl, list);
    }

    @Override
    public void pick(Point2D point2D, boolean bl, List list) throws SVGException {
        Point2D.Double double_ = new Point2D.Double(point2D.getX(), point2D.getY());
        if (this.viewXform != null) {
            try {
                this.viewXform.inverseTransform(point2D, double_);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new SVGException(noninvertibleTransformException);
            }
        }
        super.pick(double_, bl, list);
    }

    @Override
    public Shape getShape() {
        Shape shape = super.getShape();
        return this.viewXform.createTransformedShape(shape);
    }

    @Override
    public Rectangle2D getBoundingBox() throws SVGException {
        Rectangle2D rectangle2D = super.getBoundingBox();
        return this.viewXform.createTransformedShape(rectangle2D).getBounds2D();
    }

    public float getDeviceWidth() {
        return this.clipRect.width;
    }

    public float getDeviceHeight() {
        return this.clipRect.height;
    }

    public Rectangle2D getDeviceRect(Rectangle2D rectangle2D) {
        rectangle2D.setRect(this.clipRect);
        return rectangle2D;
    }

    @Override
    public boolean updateTime(double d) throws SVGException {
        Rectangle2D.Float float_;
        Object object;
        boolean bl = super.updateTime(d);
        StyleAttribute styleAttribute = new StyleAttribute();
        boolean bl2 = false;
        if (this.getPres(styleAttribute.setName("x")) && !((NumberWithUnits)(object = styleAttribute.getNumberWithUnits())).equals(this.x)) {
            this.x = object;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("y")) && !((NumberWithUnits)(object = styleAttribute.getNumberWithUnits())).equals(this.y)) {
            this.y = object;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("width")) && !((NumberWithUnits)(object = styleAttribute.getNumberWithUnits())).equals(this.width)) {
            this.width = object;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("height")) && !((NumberWithUnits)(object = styleAttribute.getNumberWithUnits())).equals(this.height)) {
            this.height = object;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("viewBox")) && !(float_ = new Rectangle2D.Float((float)(object = (Object)styleAttribute.getFloatList())[0], (float)object[1], (float)object[2], (float)object[3])).equals(this.viewBox)) {
            this.viewBox = float_;
            bl2 = true;
        }
        if (bl2) {
            this.build();
        }
        return bl || bl2;
    }

    public StyleSheet getStyleSheet() {
        if (this.styleSheet == null) {
            for (int i = 0; i < this.getNumChildren(); ++i) {
                SVGElement sVGElement = this.getChild(i);
                if (!(sVGElement instanceof Style)) continue;
                return ((Style)sVGElement).getStyleSheet();
            }
        }
        return this.styleSheet;
    }

    public void setStyleSheet(StyleSheet styleSheet) {
        this.styleSheet = styleSheet;
    }
}

