/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine;

import java.util.ArrayList;
import org.apache.commons.jcs.engine.AbstractCacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheListener;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheEventQueue<K, V>
extends AbstractCacheEventQueue<K, V> {
    private static final Log log = LogFactory.getLog(CacheEventQueue.class);
    private static final ICacheEventQueue.QueueType queueType = ICacheEventQueue.QueueType.SINGLE;
    private Thread processorThread;
    private final Object queueLock = new Object();
    private AbstractCacheEventQueue.Node head;
    private AbstractCacheEventQueue.Node tail = this.head = new AbstractCacheEventQueue.Node();
    private int size = 0;

    public CacheEventQueue(ICacheListener<K, V> iCacheListener, long l, String string) {
        this(iCacheListener, l, string, 10, 500);
    }

    public CacheEventQueue(ICacheListener<K, V> iCacheListener, long l, String string, int n, int n2) {
        this.initialize(iCacheListener, l, string, n, n2, null);
    }

    @Override
    public void initialize(ICacheListener<K, V> iCacheListener, long l, String string, int n, int n2, String string2) {
        if (iCacheListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listener = iCacheListener;
        this.listenerId = l;
        this.cacheName = string;
        this.maxFailure = n <= 0 ? 3 : n;
        int n3 = this.waitBeforeRetry = n2 <= 0 ? 500 : n2;
        if (log.isDebugEnabled()) {
            log.debug("Constructed: " + this);
        }
    }

    @Override
    public ICacheEventQueue.QueueType getQueueType() {
        return queueType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopProcessing() {
        Object object = this.queueLock;
        synchronized (object) {
            this.destroyed = true;
            this.processorThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.queueLock;
        synchronized (object) {
            if (!this.destroyed) {
                this.destroyed = true;
                if (log.isInfoEnabled()) {
                    log.info("Destroying queue, stats =  " + this.getStatistics());
                }
                if (this.processorThread != null) {
                    this.processorThread.interrupt();
                    this.processorThread = null;
                }
                if (log.isInfoEnabled()) {
                    log.info("Cache event queue destroyed: " + this);
                }
            } else if (log.isInfoEnabled()) {
                log.info("Destroy was called after queue was destroyed.  Doing nothing.  Stats =  " + this.getStatistics());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void put(AbstractCacheEventQueue.AbstractCacheEvent abstractCacheEvent) {
        AbstractCacheEventQueue.Node node = new AbstractCacheEventQueue.Node();
        if (log.isDebugEnabled()) {
            log.debug("Event entering Queue for " + this.cacheName + ": " + abstractCacheEvent);
        }
        node.event = abstractCacheEvent;
        Object object = this.queueLock;
        synchronized (object) {
            ++this.size;
            this.tail.next = node;
            this.tail = node;
            if (this.isWorking()) {
                if (!this.isAlive()) {
                    this.destroyed = false;
                    this.processorThread = new QProcessor(this);
                    this.processorThread.start();
                    if (log.isInfoEnabled()) {
                        log.info("Cache event queue created: " + this);
                    }
                } else {
                    this.queueLock.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractCacheEventQueue.AbstractCacheEvent take() {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.head == this.tail) {
                return null;
            }
            AbstractCacheEventQueue.Node node = this.head.next;
            AbstractCacheEventQueue.AbstractCacheEvent abstractCacheEvent = node.event;
            if (log.isDebugEnabled()) {
                log.debug("head.event = " + this.head.event);
                log.debug("node.event = " + node.event);
            }
            node.event = null;
            this.head = node;
            --this.size;
            return abstractCacheEvent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Cache Event Queue");
        ArrayList arrayList = new ArrayList();
        arrayList.add(new StatElement<Boolean>("Working", super.isWorking()));
        arrayList.add(new StatElement<Boolean>("Alive", this.isAlive()));
        arrayList.add(new StatElement<Boolean>("Empty", this.isEmpty()));
        int n = 0;
        Object object = this.queueLock;
        synchronized (object) {
            if (this.head == this.tail) {
                n = 0;
            } else {
                AbstractCacheEventQueue.Node node = this.head;
                while (node != null) {
                    node = node.next;
                    ++n;
                }
            }
            arrayList.add(new StatElement<Integer>("Size", n));
        }
        stats.setStatElements(arrayList);
        return stats;
    }

    @Override
    public boolean isEmpty() {
        return this.tail == this.head;
    }

    @Override
    public int size() {
        return this.size;
    }

    private class QProcessor
    extends Thread {
        CacheEventQueue<K, V> queue;

        QProcessor(CacheEventQueue<K, V> cacheEventQueue2) {
            super("CacheEventQueue.QProcessor-" + cacheEventQueue2.cacheName);
            this.setDaemon(true);
            this.queue = cacheEventQueue2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AbstractCacheEventQueue.AbstractCacheEvent abstractCacheEvent = null;
            while (this.queue.isAlive()) {
                abstractCacheEvent = this.queue.take();
                if (log.isDebugEnabled()) {
                    log.debug("Event from queue = " + abstractCacheEvent);
                }
                if (abstractCacheEvent == null) {
                    Object object = CacheEventQueue.this.queueLock;
                    synchronized (object) {
                        try {
                            CacheEventQueue.this.queueLock.wait(this.queue.getWaitToDieMillis());
                        }
                        catch (InterruptedException interruptedException) {
                            log.warn("Interrupted while waiting for another event to come in before we die.");
                            return;
                        }
                        abstractCacheEvent = this.queue.take();
                        if (log.isDebugEnabled()) {
                            log.debug("Event from queue after sleep = " + abstractCacheEvent);
                        }
                    }
                    if (abstractCacheEvent == null) {
                        this.queue.stopProcessing();
                    }
                }
                if (!this.queue.isWorking() || !this.queue.isAlive() || abstractCacheEvent == null) continue;
                abstractCacheEvent.run();
            }
            if (log.isDebugEnabled()) {
                log.debug("QProcessor exiting for " + this.queue);
            }
        }
    }
}

