/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.io.ProgressOutputStream;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.io.auth.DefaultAuthenticator;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public final class HttpClient {
    private URL url;
    private final String requestMethod;
    private int connectTimeout = Main.pref.getInteger("socket.timeout.connect", 15) * 1000;
    private int readTimeout = Main.pref.getInteger("socket.timeout.read", 30) * 1000;
    private byte[] requestBody;
    private long ifModifiedSince;
    private final Map<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private int maxRedirects = Main.pref.getInteger("socket.maxredirects", 5);
    private boolean useCache;
    private String reasonForRequest;
    private HttpURLConnection connection;
    private Response response;
    private boolean finishOnCloseOutput = true;

    private HttpClient(URL uRL, String string) {
        this.url = uRL;
        this.requestMethod = string;
        this.headers.put("Accept-Encoding", "gzip");
    }

    public Response connect() throws IOException {
        return this.connect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response connect(ProgressMonitor progressMonitor) throws IOException {
        HttpURLConnection httpURLConnection;
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        this.connection = httpURLConnection = (HttpURLConnection)this.url.openConnection();
        httpURLConnection.setRequestMethod(this.requestMethod);
        httpURLConnection.setRequestProperty("User-Agent", Version.getInstance().getFullAgentString());
        httpURLConnection.setConnectTimeout(this.connectTimeout);
        httpURLConnection.setReadTimeout(this.readTimeout);
        httpURLConnection.setInstanceFollowRedirects(false);
        if (this.ifModifiedSince > 0L) {
            httpURLConnection.setIfModifiedSince(this.ifModifiedSince);
        }
        httpURLConnection.setUseCaches(this.useCache);
        if (!this.useCache) {
            httpURLConnection.setRequestProperty("Cache-Control", "no-cache");
        }
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            if (entry.getValue() == null) continue;
            httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        progressMonitor.beginTask(I18n.tr("Contacting Server...", new Object[0]), 1);
        progressMonitor.indeterminateSubTask(null);
        if ("PUT".equals(this.requestMethod) || "POST".equals(this.requestMethod) || "DELETE".equals(this.requestMethod)) {
            Map.Entry<String, String> entry;
            Main.info("{0} {1} ({2}) ...", this.requestMethod, this.url, Utils.getSizeString(this.requestBody.length, Locale.getDefault()));
            httpURLConnection.setFixedLengthStreamingMode(this.requestBody.length);
            httpURLConnection.setDoOutput(true);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new ProgressOutputStream(httpURLConnection.getOutputStream(), this.requestBody.length, progressMonitor, this.finishOnCloseOutput));
            entry = null;
            try {
                ((OutputStream)bufferedOutputStream).write(this.requestBody);
            }
            catch (Throwable throwable) {
                entry = throwable;
                throw throwable;
            }
            finally {
                if (bufferedOutputStream != null) {
                    if (entry != null) {
                        try {
                            ((OutputStream)bufferedOutputStream).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)entry)).addSuppressed(throwable);
                        }
                    } else {
                        ((OutputStream)bufferedOutputStream).close();
                    }
                }
            }
        }
        boolean bl = false;
        try {
            try {
                httpURLConnection.connect();
                boolean bl2 = this.reasonForRequest != null && !this.reasonForRequest.isEmpty();
                Main.info("{0} {1}{2} -> {3}{4}", this.requestMethod, this.url, bl2 ? " (" + this.reasonForRequest + ')' : "", httpURLConnection.getResponseCode(), httpURLConnection.getContentLengthLong() > 0L ? " (" + Utils.getSizeString(httpURLConnection.getContentLengthLong(), Locale.getDefault()) + ')' : "");
                if (Main.isDebugEnabled()) {
                    Main.debug("RESPONSE: " + httpURLConnection.getHeaderFields());
                }
                if (DefaultAuthenticator.getInstance().isEnabled() && httpURLConnection.getResponseCode() == 401) {
                    DefaultAuthenticator.getInstance().addFailedCredentialHost(this.url.getHost());
                }
            }
            catch (IOException iOException) {
                Main.info("{0} {1} -> !!!", this.requestMethod, this.url);
                Main.warn(iOException);
                Main.addNetworkError(this.url, Utils.getRootCause(iOException));
                throw iOException;
            }
            if (HttpClient.isRedirect(httpURLConnection.getResponseCode())) {
                String string = httpURLConnection.getHeaderField("Location");
                if (string == null) {
                    String string2 = I18n.tr("Unexpected response from HTTP server. Got {0} response without ''Location'' header. Can''t redirect. Aborting.", httpURLConnection.getResponseCode());
                    throw new IOException(string2);
                }
                if (this.maxRedirects > 0) {
                    this.url = new URL(this.url, string);
                    --this.maxRedirects;
                    Main.info(I18n.tr("Download redirected to ''{0}''", string));
                    Response response = this.connect();
                    return response;
                }
                if (this.maxRedirects == 0) {
                    String string3 = I18n.tr("Too many redirects to the download URL detected. Aborting.", new Object[0]);
                    throw new IOException(string3);
                }
            }
            this.response = new Response(httpURLConnection, progressMonitor);
            bl = true;
            Response response = this.response;
            return response;
        }
        finally {
            if (!bl) {
                httpURLConnection.disconnect();
            }
        }
    }

    public Response getResponse() {
        return this.response;
    }

    public static HttpClient create(URL uRL) {
        return HttpClient.create(uRL, "GET");
    }

    public static HttpClient create(URL uRL, String string) {
        return new HttpClient(uRL, string);
    }

    public URL getURL() {
        return this.url;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public String getRequestHeader(String string) {
        return this.headers.get(string);
    }

    public HttpClient useCache(boolean bl) {
        this.useCache = bl;
        return this;
    }

    public HttpClient keepAlive(boolean bl) {
        return this.setHeader("Connection", bl ? null : "close");
    }

    public HttpClient setConnectTimeout(int n) {
        this.connectTimeout = n;
        return this;
    }

    public HttpClient setReadTimeout(int n) {
        this.readTimeout = n;
        return this;
    }

    public HttpClient setAccept(String string) {
        return this.setHeader("Accept", string);
    }

    public HttpClient setRequestBody(byte[] byArray) {
        this.requestBody = byArray;
        return this;
    }

    public HttpClient setIfModifiedSince(long l) {
        this.ifModifiedSince = l;
        return this;
    }

    public HttpClient setMaxRedirects(int n) {
        this.maxRedirects = n;
        return this;
    }

    public HttpClient setHeader(String string, String string2) {
        this.headers.put(string, string2);
        return this;
    }

    public HttpClient setHeaders(Map<String, String> map) {
        this.headers.putAll(map);
        return this;
    }

    public HttpClient setReasonForRequest(String string) {
        this.reasonForRequest = string;
        return this;
    }

    public HttpClient setFinishOnCloseOutput(boolean bl) {
        this.finishOnCloseOutput = bl;
        return this;
    }

    private static boolean isRedirect(int n) {
        switch (n) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    public void disconnect() {
        HttpClient.disconnect(this.connection);
    }

    private static void disconnect(HttpURLConnection httpURLConnection) {
        httpURLConnection.setConnectTimeout(100);
        httpURLConnection.setReadTimeout(100);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            Main.warn("InterruptedException in " + HttpClient.class + " during cancel");
        }
        httpURLConnection.disconnect();
    }

    static {
        CookieHandler.setDefault(new CookieManager());
    }

    public static final class Response {
        private final HttpURLConnection connection;
        private final ProgressMonitor monitor;
        private final int responseCode;
        private final String responseMessage;
        private boolean uncompress;
        private boolean uncompressAccordingToContentDisposition;

        private Response(HttpURLConnection httpURLConnection, ProgressMonitor progressMonitor) throws IOException {
            CheckParameterUtil.ensureParameterNotNull(httpURLConnection, "connection");
            CheckParameterUtil.ensureParameterNotNull(progressMonitor, "monitor");
            this.connection = httpURLConnection;
            this.monitor = progressMonitor;
            this.responseCode = httpURLConnection.getResponseCode();
            this.responseMessage = httpURLConnection.getResponseMessage();
        }

        public Response uncompress(boolean bl) {
            this.uncompress = bl;
            return this;
        }

        public Response uncompressAccordingToContentDisposition(boolean bl) {
            this.uncompressAccordingToContentDisposition = bl;
            return this;
        }

        public URL getURL() {
            return this.connection.getURL();
        }

        public String getRequestMethod() {
            return this.connection.getRequestMethod();
        }

        public InputStream getContent() throws IOException {
            InputStream inputStream;
            try {
                inputStream = this.connection.getInputStream();
            }
            catch (IOException iOException) {
                Main.debug(iOException);
                inputStream = this.connection.getErrorStream();
            }
            if (inputStream != null) {
                String string;
                inputStream = new ProgressInputStream(inputStream, this.getContentLength(), this.monitor);
                inputStream = "gzip".equalsIgnoreCase(this.getContentEncoding()) ? new GZIPInputStream(inputStream) : inputStream;
                Compression compression = Compression.NONE;
                if (this.uncompress) {
                    string = this.getContentType();
                    Main.debug("Uncompressing input stream according to Content-Type header: {0}", string);
                    compression = Compression.forContentType(string);
                }
                if (this.uncompressAccordingToContentDisposition && Compression.NONE.equals((Object)compression)) {
                    string = this.getHeaderField("Content-Disposition");
                    Matcher matcher = Pattern.compile("filename=\"([^\"]+)\"").matcher(string != null ? string : "");
                    if (matcher.find()) {
                        Main.debug("Uncompressing input stream according to Content-Disposition header: {0}", string);
                        compression = Compression.byExtension(matcher.group(1));
                    }
                }
                inputStream = compression.getUncompressedInputStream(inputStream);
            }
            return inputStream;
        }

        public BufferedReader getContentReader() throws IOException {
            return new BufferedReader(UTFInputStreamReader.create(this.getContent()));
        }

        public String fetchContent() throws IOException {
            try (Scanner scanner = new Scanner(this.getContentReader()).useDelimiter("\\A");){
                String string = scanner.hasNext() ? scanner.next() : "";
                return string;
            }
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public String getResponseMessage() {
            return this.responseMessage;
        }

        public String getContentEncoding() {
            return this.connection.getContentEncoding();
        }

        public String getContentType() {
            return this.connection.getHeaderField("Content-Type");
        }

        public long getExpiration() {
            return this.connection.getExpiration();
        }

        public long getLastModified() {
            return this.connection.getLastModified();
        }

        public long getContentLength() {
            return this.connection.getContentLengthLong();
        }

        public String getHeaderField(String string) {
            return this.connection.getHeaderField(string);
        }

        public Map<String, List<String>> getHeaderFields() {
            TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            for (Map.Entry<String, List<String>> entry : this.connection.getHeaderFields().entrySet()) {
                if (entry.getKey() == null) continue;
                treeMap.put(entry.getKey(), entry.getValue());
            }
            return Collections.unmodifiableMap(treeMap);
        }

        public void disconnect() {
            HttpClient.disconnect(this.connection);
        }
    }
}

