# is-unc-path [![NPM version](https://img.shields.io/npm/v/is-unc-path.svg?style=flat)](https://www.npmjs.com/package/is-unc-path) [![NPM monthly downloads](https://img.shields.io/npm/dm/is-unc-path.svg?style=flat)](https://npmjs.org/package/is-unc-path)  [![NPM total downloads](https://img.shields.io/npm/dt/is-unc-path.svg?style=flat)](https://npmjs.org/package/is-unc-path) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/is-unc-path.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/is-unc-path)

> Returns true if a filepath is a windows UNC file path.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save is-unc-path
```

## Usage

```js
var isUncPath = require('is-unc-path');
```

**true**

Returns true for windows UNC paths:

```js
isUncPath('\\/foo/bar');
isUncPath('\\\\foo/bar');
isUncPath('\\\\foo\\admin

**false**

Returns false for non-UNC paths:

```js
isUncPath('/foo/bar');
isUncPath('/');
isUncPath('/foo');
isUncPath('/foo/');
isUncPath('c:');
isUncPath('c:.');
isUncPath('c:./');
isUncPath('c:./file');
isUncPath('c:/');
isUncPath('c:/file');
```

**Customization**

Use `.source` to use the regex as a component of another regex:

```js
var myRegex = new RegExp(isUncPath.source + 'foo');
```

**[Rules for UNC paths](http://resources.esri.com/help/9.3/ArcGISDesktop/com/Gp_ToolRef/sharing_tools_and_toolboxes/pathnames_explained_colon_absolute_relative_unc_and_url.htm)**

* The computer name is always preceded by a double backward-slash (`\\`).
* UNC paths cannot contain a drive letter (such as `D:`)

## About

### Related projects

* [dirname-regex](https://www.npmjs.com/package/dirname-regex): Regular expression for matching the directory part of a file path. | [homepage](https://github.com/regexps/dirname-regex "Regular expression for matching the directory part of a file path.")
* [dotdir-regex](https://www.npmjs.com/package/dotdir-regex): Regex for matching dot-directories, like `.git/` | [homepage](https://github.com/regexps/dotdir-regex "Regex for matching dot-directories, like `.git/`")
* [dotfile-regex](https://www.npmjs.com/package/dotfile-regex): Regular expresson for matching dotfiles. | [homepage](https://github.com/regexps/dotfile-regex "Regular expresson for matching dotfiles.")
* [is-glob](https://www.npmjs.com/package/is-glob): Returns `true` if the given string looks like a glob pattern or an extglob pattern… [more](https://github.com/jonschlinkert/is-glob) | [homepage](https://github.com/jonschlinkert/is-glob "Returns `true` if the given string looks like a glob pattern or an extglob pattern. This makes it easy to create code that only uses external modules like node-glob when necessary, resulting in much faster code execution and initialization time, and a bet")
* [is-unc-path](https://www.npmjs.com/package/is-unc-path): Returns true if a filepath is a windows UNC file path. | [homepage](https://github.com/jonschlinkert/is-unc-path "Returns true if a filepath is a windows UNC file path.")
* [path-regex](https://www.npmjs.com/package/path-regex): Regular expression for matching the parts of a file path. | [homepage](https://github.com/regexps/path-regex "Regular expression for matching the parts of a file path.")
* [unc-path-regex](https://www.npmjs.com/package/unc-path-regex): Regular expression for testing if a file path is a windows UNC file path. Can… [more](https://github.com/regexhq/unc-path-regex) | [homepage](https://github.com/regexhq/unc-path-regex "Regular expression for testing if a file path is a windows UNC file path. Can also be used as a component of another regexp via the `.source` property.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Building docs

_(This document was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme) (a [verb](https://github.com/verbose/verb) generator), please don't edit the readme directly. Any changes to the readme must be made in [.verb.md](.verb.md).)_

To generate the readme and API documentation with [verb](https://github.com/verbose/verb):

```sh
$ npm install -g verb verb-generate-readme && verb
```

### Running tests

Install dev dependencies:

```sh
$ npm install -d && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

### License

Copyright © 2016, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT license](https://github.com/jonschlinkert/is-unc-path/blob/master/LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.2.0, on December 07, 2016._

);
isUncPath('\\foo\admin$\system32');
isUncPath('\\foo\temp');
isUncPath('\\/foo/bar');
isUncPath('\\\/foo/bar');

```
**false**

Returns false for non-UNC paths:

```js
isUncPath('/foo/bar');
isUncPath('/');
isUncPath('/foo');
isUncPath('/foo/');
isUncPath('c:');
isUncPath('c:.');
isUncPath('c:./');
isUncPath('c:./file');
isUncPath('c:/');
isUncPath('c:/file');
```

**Customization**

Use `.source` to use the regex as a component of another regex:

```js
var myRegex = new RegExp(isUncPath.source + 'foo');
```

**[Rules for UNC paths](http://resources.esri.com/help/9.3/ArcGISDesktop/com/Gp_ToolRef/sharing_tools_and_toolboxes/pathnames_explained_colon_absolute_relative_unc_and_url.htm)**

* The computer name is always preceded by a double backward-slash (`\\`).
* UNC paths cannot contain a drive letter (such as `D:`)

## About

### Related projects

* [dirname-regex](https://www.npmjs.com/package/dirname-regex): Regular expression for matching the directory part of a file path. | [homepage](https://github.com/regexps/dirname-regex "Regular expression for matching the directory part of a file path.")
* [dotdir-regex](https://www.npmjs.com/package/dotdir-regex): Regex for matching dot-directories, like `.git/` | [homepage](https://github.com/regexps/dotdir-regex "Regex for matching dot-directories, like `.git/`")
* [dotfile-regex](https://www.npmjs.com/package/dotfile-regex): Regular expresson for matching dotfiles. | [homepage](https://github.com/regexps/dotfile-regex "Regular expresson for matching dotfiles.")
* [is-glob](https://www.npmjs.com/package/is-glob): Returns `true` if the given string looks like a glob pattern or an extglob pattern… [more](https://github.com/jonschlinkert/is-glob) | [homepage](https://github.com/jonschlinkert/is-glob "Returns `true` if the given string looks like a glob pattern or an extglob pattern. This makes it easy to create code that only uses external modules like node-glob when necessary, resulting in much faster code execution and initialization time, and a bet")
* [is-unc-path](https://www.npmjs.com/package/is-unc-path): Returns true if a filepath is a windows UNC file path. | [homepage](https://github.com/jonschlinkert/is-unc-path "Returns true if a filepath is a windows UNC file path.")
* [path-regex](https://www.npmjs.com/package/path-regex): Regular expression for matching the parts of a file path. | [homepage](https://github.com/regexps/path-regex "Regular expression for matching the parts of a file path.")
* [unc-path-regex](https://www.npmjs.com/package/unc-path-regex): Regular expression for testing if a file path is a windows UNC file path. Can… [more](https://github.com/regexhq/unc-path-regex) | [homepage](https://github.com/regexhq/unc-path-regex "Regular expression for testing if a file path is a windows UNC file path. Can also be used as a component of another regexp via the `.source` property.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Building docs

_(This document was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme) (a [verb](https://github.com/verbose/verb) generator), please don't edit the readme directly. Any changes to the readme must be made in [.verb.md](.verb.md).)_

To generate the readme and API documentation with [verb](https://github.com/verbose/verb):

```sh
$ npm install -g verb verb-generate-readme && verb
```

### Running tests

Install dev dependencies:

```sh
$ npm install -d && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

### License

Copyright © 2016, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT license](https://github.com/jonschlinkert/is-unc-path/blob/master/LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.2.0, on December 07, 2016._