/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.imap;

import gnu.inet.imap.IMAPConnection;
import gnu.inet.imap.ListEntry;
import gnu.inet.imap.MailboxStatus;
import gnu.inet.imap.MessageStatus;
import gnu.inet.imap.Quota;
import gnu.mail.providers.imap.ACL;
import gnu.mail.providers.imap.IMAPMessage;
import gnu.mail.providers.imap.IMAPStore;
import gnu.mail.providers.imap.Rights;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.FolderNotFoundException;
import javax.mail.IllegalWriteException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;
import javax.mail.Store;
import javax.mail.UIDFolder;
import javax.mail.internet.MimeMessage;
import javax.mail.search.AddressTerm;
import javax.mail.search.AndTerm;
import javax.mail.search.BodyTerm;
import javax.mail.search.ComparisonTerm;
import javax.mail.search.DateTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.FromTerm;
import javax.mail.search.HeaderTerm;
import javax.mail.search.IntegerComparisonTerm;
import javax.mail.search.MessageIDTerm;
import javax.mail.search.NotTerm;
import javax.mail.search.OrTerm;
import javax.mail.search.RecipientTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SentDateTerm;
import javax.mail.search.SizeTerm;
import javax.mail.search.StringTerm;
import javax.mail.search.SubjectTerm;

public class IMAPFolder
extends Folder
implements UIDFolder {
    protected String path;
    protected int type;
    protected Flags permanentFlags = new Flags();
    protected char delimiter;
    protected int messageCount = -1;
    protected int newMessageCount = -1;
    protected long uidValidity = -1L;
    protected boolean subscribed;
    private static DateFormat searchdf = new SimpleDateFormat("d-MMM-yyyy");

    protected IMAPFolder(Store store, String path) {
        this(store, path, -1, '\u0000');
    }

    protected IMAPFolder(Store store, String path, char delimiter) {
        this(store, path, -1, delimiter);
    }

    protected IMAPFolder(Store store, String path, int type, char delimiter) {
        super(store);
        this.path = path;
        this.type = type;
        this.delimiter = delimiter;
    }

    void update(MailboxStatus status, boolean fireEvents) throws MessagingException {
        if (status == null) {
            throw new FolderNotFoundException((Folder)this);
        }
        int n = this.mode = status.readWrite ? 2 : 1;
        if (status.permanentFlags != null) {
            this.permanentFlags = this.readFlags(status.permanentFlags);
        }
        int oldMessageCount = this.messageCount;
        this.messageCount = status.messageCount;
        this.newMessageCount = status.newMessageCount;
        this.uidValidity = status.uidValidity;
        if (fireEvents) {
            if (this.messageCount > oldMessageCount) {
                Message[] m = new Message[this.messageCount - oldMessageCount];
                for (int i = oldMessageCount; i < this.messageCount; ++i) {
                    m[i - oldMessageCount] = this.getMessage(i);
                }
                this.notifyMessageAddedListeners(m);
            } else if (this.messageCount < oldMessageCount) {
                Message[] m = new Message[oldMessageCount - this.messageCount];
                for (int i = this.messageCount; i < oldMessageCount; ++i) {
                    m[i - this.messageCount] = this.getMessage(i);
                }
                this.notifyMessageRemovedListeners(false, m);
            }
        }
    }

    Flags readFlags(List sflags) {
        Flags flags = new Flags();
        int len = sflags.size();
        for (int i = 0; i < len; ++i) {
            String flag = (String)sflags.get(i);
            if (flag == "\\Answered") {
                flags.add(Flags.Flag.ANSWERED);
                continue;
            }
            if (flag == "\\Deleted") {
                flags.add(Flags.Flag.DELETED);
                continue;
            }
            if (flag == "\\Draft") {
                flags.add(Flags.Flag.DRAFT);
                continue;
            }
            if (flag == "\\Flagged") {
                flags.add(Flags.Flag.FLAGGED);
                continue;
            }
            if (flag == "\\Recent") {
                flags.add(Flags.Flag.RECENT);
                continue;
            }
            if (flag != "\\Seen") continue;
            flags.add(Flags.Flag.SEEN);
        }
        return flags;
    }

    public String getName() {
        int di = this.path.lastIndexOf(this.delimiter);
        return di == -1 ? this.path : this.path.substring(di + 1);
    }

    public String getFullName() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getType() throws MessagingException {
        block9: {
            if (this.type == -1) {
                int lsi = this.path.lastIndexOf(this.getSeparator());
                String parent = lsi == -1 ? "" : this.path.substring(0, lsi);
                String name = lsi == -1 ? this.path : this.path.substring(lsi + 1);
                IMAPConnection connection = ((IMAPStore)this.store).getConnection();
                try {
                    ListEntry[] entries = null;
                    IMAPConnection iMAPConnection = connection;
                    synchronized (iMAPConnection) {
                        entries = connection.list(parent, name);
                    }
                    if (connection.alertsPending()) {
                        ((IMAPStore)this.store).processAlerts();
                    }
                    this.type = 2;
                    if (entries.length > 0) {
                        if (!"".equals(this.path) && entries[0].isNoinferiors()) {
                            this.type |= 1;
                        }
                        break block9;
                    }
                    throw new FolderNotFoundException((Folder)this);
                }
                catch (IOException e) {
                    throw new MessagingException(e.getMessage(), (Exception)e);
                }
            }
        }
        return this.type;
    }

    public boolean exists() throws MessagingException {
        try {
            this.getType();
        }
        catch (FolderNotFoundException e) {
            return false;
        }
        return true;
    }

    public boolean hasNewMessages() throws MessagingException {
        return this.getNewMessageCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(int mode) throws MessagingException {
        IMAPStore s = (IMAPStore)this.store;
        IMAPConnection connection = s.getConnection();
        try {
            MailboxStatus status = null;
            IMAPConnection iMAPConnection = connection;
            synchronized (iMAPConnection) {
                switch (mode) {
                    case 2: {
                        status = connection.select(this.path);
                        break;
                    }
                    case 1: {
                        status = connection.examine(this.path);
                        break;
                    }
                    default: {
                        throw new MessagingException("No such mode: " + mode);
                    }
                }
                this.update(status, false);
            }
            s.setSelected(this);
            this.notifyConnectionListeners(1);
            if (connection.alertsPending()) {
                s.processAlerts();
            }
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean create(int type) throws MessagingException {
        IMAPStore s = (IMAPStore)this.store;
        IMAPConnection connection = s.getConnection();
        try {
            String newPath = this.path;
            if ((type & 2) != 0) {
                this.getSeparator();
                if (this.delimiter == '\u0000') {
                    throw new FolderNotFoundException((Folder)this, newPath);
                }
                newPath = new StringBuffer(newPath).append(this.delimiter).toString();
            }
            boolean ret = false;
            IMAPConnection iMAPConnection = connection;
            synchronized (iMAPConnection) {
                ret = connection.create(newPath);
            }
            if (ret) {
                type = -1;
                this.notifyFolderListeners(1);
            }
            if (connection.alertsPending()) {
                s.processAlerts();
            }
            return ret;
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(boolean flag) throws MessagingException {
        IMAPStore s = (IMAPStore)this.store;
        IMAPConnection connection = s.getConnection();
        try {
            boolean ret = false;
            IMAPConnection iMAPConnection = connection;
            synchronized (iMAPConnection) {
                ret = connection.delete(this.path);
            }
            if (ret) {
                this.type = -1;
                this.notifyFolderListeners(2);
            }
            if (connection.alertsPending()) {
                s.processAlerts();
            }
            return ret;
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameTo(Folder folder) throws MessagingException {
        IMAPStore s = (IMAPStore)this.store;
        IMAPConnection connection = s.getConnection();
        try {
            boolean ret = false;
            IMAPConnection iMAPConnection = connection;
            synchronized (iMAPConnection) {
                ret = connection.rename(this.path, folder.getFullName());
            }
            if (ret) {
                this.type = -1;
                this.notifyFolderRenamedListeners(folder);
            }
            if (connection.alertsPending()) {
                s.processAlerts();
            }
            return ret;
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean expunge) throws MessagingException {
        if (this.mode == -1) {
            return;
        }
        IMAPStore s = (IMAPStore)this.store;
        boolean selected = s.isSelected(this);
        if (selected) {
            s.setSelected(null);
        }
        this.mode = -1;
        this.notifyConnectionListeners(3);
        if (expunge) {
            if (!selected) {
                throw new FolderClosedException((Folder)this);
            }
            IMAPConnection connection = s.getConnection();
            try {
                boolean success = false;
                IMAPConnection iMAPConnection = connection;
                synchronized (iMAPConnection) {
                    success = connection.close();
                }
                if (connection.alertsPending()) {
                    s.processAlerts();
                }
                if (!success) {
                    throw new IllegalWriteException();
                }
            }
            catch (IOException e) {
                throw new MessagingException(e.getMessage(), (Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message[] expunge() throws MessagingException {
        if (!this.isOpen()) {
            throw new MessagingException("Folder is not open");
        }
        if (this.mode == 1) {
            throw new MessagingException("Folder was opened read-only");
        }
        IMAPStore s = (IMAPStore)this.store;
        IMAPConnection connection = s.getConnection();
        try {
            int[] messageNumbers = null;
            IMAPConnection iMAPConnection = connection;
            synchronized (iMAPConnection) {
                messageNumbers = connection.expunge();
            }
            IMAPMessage[] messages = new IMAPMessage[messageNumbers.length];
            for (int i = 0; i < messages.length; ++i) {
                messages[i] = new IMAPMessage(this, messageNumbers[i]);
            }
            this.notifyMessageRemovedListeners(true, (Message[])messages);
            if (connection.alertsPending()) {
                s.processAlerts();
            }
            return messages;
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    public boolean isOpen() {
        return this.mode != -1;
    }

    public Flags getPermanentFlags() {
        return this.permanentFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageCount() throws MessagingException {
        IMAPConnection connection;
        IMAPStore s;
        block11: {
            MailboxStatus ms = null;
            s = (IMAPStore)this.store;
            connection = s.getConnection();
            try {
                if (this.mode == -1 || this.messageCount < 0) {
                    String[] items = new String[]{"MESSAGES"};
                    IMAPConnection iMAPConnection = connection;
                    synchronized (iMAPConnection) {
                        ms = connection.status(this.path, items);
                    }
                    this.update(ms, true);
                    break block11;
                }
                IMAPConnection items = connection;
                synchronized (items) {
                    ms = connection.noop();
                }
                if (ms != null) {
                    this.update(ms, true);
                }
            }
            catch (IOException e) {
                throw new MessagingException(e.getMessage(), (Exception)e);
            }
        }
        if (connection.alertsPending()) {
            s.processAlerts();
        }
        return this.messageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNewMessageCount() throws MessagingException {
        IMAPConnection connection;
        IMAPStore s;
        block11: {
            MailboxStatus ms = null;
            s = (IMAPStore)this.store;
            connection = s.getConnection();
            try {
                if (this.mode == -1 || this.newMessageCount < 0) {
                    String[] items = new String[]{"RECENT"};
                    IMAPConnection iMAPConnection = connection;
                    synchronized (iMAPConnection) {
                        ms = connection.status(this.path, items);
                        this.update(ms, true);
                        break block11;
                    }
                }
                IMAPConnection items = connection;
                synchronized (items) {
                    ms = connection.noop();
                }
                if (ms != null) {
                    this.update(ms, true);
                }
            }
            catch (IOException e) {
                throw new MessagingException(e.getMessage(), (Exception)e);
            }
        }
        if (connection.alertsPending()) {
            s.processAlerts();
        }
        return this.newMessageCount;
    }

    public Message getMessage(int msgnum) throws MessagingException {
        if (this.mode == -1) {
            throw new FolderClosedException((Folder)this);
        }
        return new IMAPMessage(this, msgnum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendMessages(Message[] messages) throws MessagingException {
        MimeMessage[] m = new MimeMessage[messages.length];
        try {
            for (int i = 0; i < messages.length; ++i) {
                m[i] = (MimeMessage)messages[i];
            }
        }
        catch (ClassCastException e) {
            throw new MessagingException("Only MimeMessages can be appended to this folder");
        }
        IMAPStore s = (IMAPStore)this.store;
        IMAPConnection connection = s.getConnection();
        try {
            for (int i = 0; i < m.length; ++i) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                m[i].writeTo((OutputStream)out);
                byte[] content = out.toByteArray();
                out = null;
                IMAPConnection iMAPConnection = connection;
                synchronized (iMAPConnection) {
                    connection.append(this.path, null, content);
                    continue;
                }
            }
            if (connection.alertsPending()) {
                s.processAlerts();
            }
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
        this.notifyMessageAddedListeners((Message[])m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetch(Message[] messages, FetchProfile fp) throws MessagingException {
        if (!this.isOpen()) {
            throw new FolderClosedException((Folder)this);
        }
        String[] headers = fp.getHeaderNames();
        ArrayList<String> l = new ArrayList<String>();
        if (fp.contains(FetchProfile.Item.CONTENT_INFO)) {
            l.add("BODY.PEEK[]");
        } else if (fp.contains(FetchProfile.Item.ENVELOPE)) {
            l.add("BODY.PEEK[HEADER]");
        } else if (headers.length > 0) {
            StringBuffer hbuf = new StringBuffer("BODY.PEEK[HEADER.FIELDS(");
            for (int i = 0; i < headers.length; ++i) {
                if (i > 0) {
                    hbuf.append(' ');
                }
                hbuf.append(headers[i]);
            }
            hbuf.append(')');
            hbuf.append(']');
            l.add(hbuf.toString());
        }
        if (fp.contains(FetchProfile.Item.FLAGS)) {
            l.add("FLAGS");
        }
        l.add("INTERNALDATE");
        int llen = l.size();
        if (llen == 0) {
            return;
        }
        String[] commands = new String[llen];
        l.toArray(commands);
        l = null;
        IMAPMessage[] m = new IMAPMessage[messages.length];
        int[] msgnums = new int[messages.length];
        try {
            for (int i = 0; i < messages.length; ++i) {
                m[i] = (IMAPMessage)messages[i];
                msgnums[i] = m[i].getMessageNumber();
            }
        }
        catch (ClassCastException e) {
            throw new MessagingException("Only IMAPMessages can be fetched");
        }
        IMAPStore s = (IMAPStore)this.store;
        IMAPConnection connection = s.getConnection();
        try {
            IMAPConnection iMAPConnection = connection;
            synchronized (iMAPConnection) {
                MessageStatus[] ms = connection.fetch(msgnums, commands);
                block9: for (int i = 0; i < ms.length; ++i) {
                    int msgnum = ms[i].getMessageNumber();
                    for (int j = 0; j < msgnums.length; ++j) {
                        if (msgnums[j] != msgnum) continue;
                        m[j].update(ms[i]);
                        continue block9;
                    }
                }
            }
            if (connection.alertsPending()) {
                s.processAlerts();
            }
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    public Message[] search(SearchTerm term) throws MessagingException {
        return this.search(term, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message[] search(SearchTerm term, Message[] msgs) throws MessagingException {
        ArrayList<String> list = new ArrayList<String>();
        if (msgs != null) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < msgs.length; ++i) {
                int msgnum = msgs[i].getMessageNumber();
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(msgnum);
            }
            list.add(buffer.toString());
        }
        boolean isIMAPSearch = this.addTerm(term, list);
        String[] criteria = new String[list.size()];
        list.toArray(criteria);
        IMAPStore s = (IMAPStore)this.store;
        IMAPConnection connection = s.getConnection();
        try {
            Message[] messages;
            if (isIMAPSearch && criteria.length > 0) {
                int[] mn = null;
                IMAPConnection iMAPConnection = connection;
                synchronized (iMAPConnection) {
                    mn = connection.search(null, criteria);
                }
                messages = new Message[mn.length];
                for (int i = 0; i < mn.length; ++i) {
                    messages[i] = new IMAPMessage(this, mn[i]);
                }
                if (connection.alertsPending()) {
                    s.processAlerts();
                }
            } else {
                messages = msgs != null ? msgs : this.getMessages();
            }
            return super.search(term, messages);
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addTerm(SearchTerm term, List list) {
        if (term instanceof AndTerm) {
            SearchTerm[] terms = ((AndTerm)term).getTerms();
            int i = 0;
            while (i < terms.length) {
                if (!this.addTerm(terms[i], list)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (term instanceof OrTerm) {
            list.add("OR");
            SearchTerm[] terms = ((OrTerm)term).getTerms();
            int i = 0;
            while (i < terms.length) {
                if (!this.addTerm(terms[i], list)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (term instanceof NotTerm) {
            list.add("NOT");
            if (this.addTerm(((NotTerm)term).getTerm(), list)) return true;
            return false;
        }
        if (term instanceof FlagTerm) {
            FlagTerm ft = (FlagTerm)term;
            Flags f = ft.getFlags();
            boolean set = ft.getTestSet();
            Flags.Flag[] sf = f.getSystemFlags();
            for (int i = 0; i < sf.length; ++i) {
                Flags.Flag ff = sf[i];
                if (ff == Flags.Flag.ANSWERED) {
                    list.add(set ? "ANSWERED" : "UNANSWERED");
                    continue;
                }
                if (ff == Flags.Flag.DELETED) {
                    list.add(set ? "DELETED" : "UNDELETED");
                    continue;
                }
                if (ff == Flags.Flag.DRAFT) {
                    list.add(set ? "DRAFT" : "UNDRAFT");
                    continue;
                }
                if (ff == Flags.Flag.FLAGGED) {
                    list.add(set ? "FLAGGED" : "UNFLAGGED");
                    continue;
                }
                if (ff == Flags.Flag.RECENT) {
                    list.add(set ? "RECENT" : "OLD");
                    continue;
                }
                if (ff != Flags.Flag.SEEN) continue;
                list.add(set ? "SEEN" : "UNSEEN");
            }
            String[] uf = f.getUserFlags();
            int i = 0;
            while (i < uf.length) {
                StringBuffer keyword = new StringBuffer();
                keyword.append(set ? "KEYWORD" : "UNKEYWORD");
                keyword.append('\"');
                keyword.append(uf[i]);
                keyword.append('\"');
                list.add(keyword.toString());
                ++i;
            }
            return true;
        }
        if (term instanceof AddressTerm) {
            Address address = ((AddressTerm)term).getAddress();
            StringBuffer criterion = new StringBuffer();
            if (term instanceof FromTerm) {
                criterion.append("FROM");
            } else {
                if (!(term instanceof RecipientTerm)) return false;
                Message.RecipientType rt = ((RecipientTerm)term).getRecipientType();
                if (rt == Message.RecipientType.TO) {
                    criterion.append("TO");
                } else if (rt == Message.RecipientType.CC) {
                    criterion.append("CC");
                } else {
                    if (rt != Message.RecipientType.BCC) return false;
                    criterion.append("BCC");
                }
            }
            if (criterion == null) return false;
            criterion.append(' ');
            criterion.append('\"');
            criterion.append(address.toString());
            criterion.append('\"');
            list.add(criterion.toString());
            return true;
        } else if (term instanceof ComparisonTerm) {
            if (term instanceof DateTerm) {
                DateTerm dt = (DateTerm)term;
                Date date = dt.getDate();
                int comparison = dt.getComparison();
                StringBuffer criterion = new StringBuffer();
                switch (comparison) {
                    case 1: 
                    case 4: 
                    case 6: {
                        criterion.append("NOT");
                        criterion.append(' ');
                    }
                }
                if (term instanceof SentDateTerm) {
                    criterion.append("SENT");
                }
                switch (comparison) {
                    case 3: 
                    case 4: {
                        criterion.append("ON");
                        break;
                    }
                    case 2: 
                    case 6: {
                        criterion.append("BEFORE");
                        break;
                    }
                    case 1: 
                    case 5: {
                        criterion.append("SINCE");
                    }
                }
                criterion.append(' ');
                criterion.append(searchdf.format(date));
                list.add(criterion.toString());
                return true;
            } else {
                if (!(term instanceof IntegerComparisonTerm)) return true;
                IntegerComparisonTerm it = (IntegerComparisonTerm)term;
                int number = it.getNumber();
                int comparison = it.getComparison();
                if (!(term instanceof SizeTerm)) return false;
                StringBuffer criterion = new StringBuffer();
                switch (comparison) {
                    case 1: 
                    case 3: 
                    case 6: {
                        criterion.append("NOT");
                        criterion.append(' ');
                    }
                }
                switch (comparison) {
                    case 3: 
                    case 4: {
                        criterion.append("OR");
                        criterion.append(' ');
                        criterion.append("SMALLER");
                        criterion.append(' ');
                        criterion.append(number);
                        criterion.append(' ');
                        criterion.append("LARGER");
                        criterion.append(' ');
                        criterion.append(number);
                        break;
                    }
                    case 2: 
                    case 6: {
                        criterion.append("SMALLER");
                        criterion.append(' ');
                        criterion.append(number);
                        break;
                    }
                    case 1: 
                    case 5: {
                        criterion.append("LARGER");
                        criterion.append(' ');
                        criterion.append(number);
                    }
                }
                list.add(criterion.toString());
            }
            return true;
        } else {
            if (!(term instanceof StringTerm)) return false;
            String pattern = ((StringTerm)term).getPattern();
            StringBuffer criterion = new StringBuffer();
            if (term instanceof BodyTerm) {
                criterion.append("BODY");
            } else if (term instanceof HeaderTerm) {
                criterion.append("HEADER");
                criterion.append(' ');
                criterion.append(((HeaderTerm)term).getHeaderName());
            } else if (term instanceof SubjectTerm) {
                criterion.append("SUBJECT");
            } else {
                if (!(term instanceof MessageIDTerm)) return false;
                criterion.append("HEADER");
                criterion.append(' ');
                criterion.append("Message-ID");
            }
            if (criterion == null) return false;
            criterion.append(' ');
            criterion.append('\"');
            criterion.append(pattern);
            criterion.append('\"');
            list.add(criterion.toString());
        }
        return true;
    }

    public boolean isSubscribed() {
        return this.subscribed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubscribed(boolean flag) throws MessagingException {
        IMAPStore s = (IMAPStore)this.store;
        IMAPConnection connection = s.getConnection();
        try {
            IMAPConnection iMAPConnection = connection;
            synchronized (iMAPConnection) {
                if (flag) {
                    connection.subscribe(this.path);
                } else {
                    connection.unsubscribe(this.path);
                }
            }
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Folder[] list(String pattern) throws MessagingException {
        char sep = this.getSeparator();
        String spec = "".equals(this.path) ? this.path : new StringBuffer(this.path).append(sep).append(pattern).toString();
        IMAPStore s = (IMAPStore)this.store;
        IMAPConnection connection = s.getConnection();
        try {
            ListEntry[] entries;
            IMAPConnection iMAPConnection = connection;
            synchronized (iMAPConnection) {
                entries = connection.list("", spec);
            }
            if (connection.alertsPending()) {
                s.processAlerts();
            }
            return this.getFolders(entries, false);
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Folder[] listSubscribed(String pattern) throws MessagingException {
        char sep = this.getSeparator();
        String spec = "".equals(this.path) ? this.path : new StringBuffer(this.path).append(sep).append(pattern).toString();
        IMAPStore s = (IMAPStore)this.store;
        IMAPConnection connection = s.getConnection();
        try {
            ListEntry[] entries = null;
            IMAPConnection iMAPConnection = connection;
            synchronized (iMAPConnection) {
                entries = connection.lsub("", spec);
            }
            if (connection.alertsPending()) {
                s.processAlerts();
            }
            return this.getFolders(entries, true);
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    Folder[] getFolders(ListEntry[] entries, boolean subscribed) throws MessagingException {
        ArrayList<IMAPFolder> unique = new ArrayList<IMAPFolder>(entries.length);
        for (int i = 0; i < entries.length; ++i) {
            IMAPFolder f;
            int etype;
            ListEntry entry = entries[i];
            int n = etype = entry.isNoinferiors() ? 1 : 2;
            if (entry.isNoselect() || unique.contains((Object)(f = new IMAPFolder(this.store, entry.getMailbox(), etype, entry.getDelimiter())))) continue;
            unique.add(f);
            f.subscribed = subscribed;
        }
        Folder[] folders = new Folder[unique.size()];
        unique.toArray(folders);
        return folders;
    }

    public Folder getParent() throws MessagingException {
        IMAPStore s = (IMAPStore)this.store;
        IMAPConnection connection = s.getConnection();
        this.getSeparator();
        int di = this.path.lastIndexOf(this.delimiter);
        if (di == -1) {
            return s.getDefaultFolder();
        }
        return new IMAPFolder(this.store, this.path.substring(0, di), this.delimiter);
    }

    public Folder getFolder(String name) throws MessagingException {
        StringBuffer buf = new StringBuffer();
        if (this.path != null && this.path.length() > 0) {
            buf.append(this.path);
            buf.append(this.delimiter);
        }
        buf.append(name);
        return new IMAPFolder(this.store, buf.toString(), -1, this.getSeparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char getSeparator() throws MessagingException {
        if (this.delimiter == '\u0000') {
            IMAPStore s = (IMAPStore)this.store;
            IMAPConnection connection = s.getConnection();
            try {
                ListEntry[] entries = null;
                IMAPConnection iMAPConnection = connection;
                synchronized (iMAPConnection) {
                    entries = connection.list(this.path, null);
                }
                if (connection.alertsPending()) {
                    s.processAlerts();
                }
                if (entries.length <= 0) {
                    throw new FolderNotFoundException((Folder)this);
                }
                this.delimiter = entries[0].getDelimiter();
            }
            catch (IOException e) {
                throw new MessagingException(e.getMessage(), (Exception)e);
            }
        }
        return this.delimiter;
    }

    public boolean equals(Object other) {
        if (other instanceof IMAPFolder) {
            return ((IMAPFolder)((Object)other)).path.equals(this.path);
        }
        return super.equals(other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUIDValidity() throws MessagingException {
        IMAPConnection connection;
        IMAPStore s;
        block11: {
            MailboxStatus ms = null;
            s = (IMAPStore)this.store;
            connection = s.getConnection();
            try {
                if (this.mode == -1 || this.uidValidity < 0L) {
                    String[] items = new String[]{"UIDVALIDITY"};
                    IMAPConnection iMAPConnection = connection;
                    synchronized (iMAPConnection) {
                        ms = connection.status(this.path, items);
                    }
                    this.update(ms, true);
                    break block11;
                }
                IMAPConnection items = connection;
                synchronized (items) {
                    ms = connection.noop();
                }
                if (ms != null) {
                    this.update(ms, true);
                }
            }
            catch (IOException e) {
                throw new MessagingException(e.getMessage(), (Exception)e);
            }
        }
        if (connection.alertsPending()) {
            s.processAlerts();
        }
        return this.uidValidity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getMessageByUID(long uid) throws MessagingException {
        if (this.mode == -1) {
            throw new FolderClosedException((Folder)this);
        }
        MessageStatus ms = null;
        IMAPStore s = (IMAPStore)this.store;
        IMAPConnection connection = s.getConnection();
        try {
            String[] cmds = new String[]{"FLAGS"};
            IMAPConnection iMAPConnection = connection;
            synchronized (iMAPConnection) {
                ms = connection.uidFetch(uid, cmds);
            }
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
        if (connection.alertsPending()) {
            s.processAlerts();
        }
        IMAPMessage message = new IMAPMessage(this, ms.getMessageNumber());
        message.update(ms);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message[] getMessagesByUID(long start, long end) throws MessagingException {
        if (this.mode == -1) {
            throw new FolderClosedException((Folder)this);
        }
        MessageStatus[] ms = null;
        IMAPStore s = (IMAPStore)this.store;
        IMAPConnection connection = s.getConnection();
        try {
            String[] cmds = new String[]{"FLAGS"};
            IMAPConnection iMAPConnection = connection;
            synchronized (iMAPConnection) {
                ms = connection.uidFetch(start, end, cmds);
            }
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
        if (connection.alertsPending()) {
            s.processAlerts();
        }
        Message[] messages = new Message[ms.length];
        for (int i = 0; i < messages.length; ++i) {
            IMAPMessage message = new IMAPMessage(this, ms[i].getMessageNumber());
            message.update(ms[i]);
            messages[i] = message;
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message[] getMessagesByUID(long[] uids) throws MessagingException {
        if (this.mode == -1) {
            throw new FolderClosedException((Folder)this);
        }
        MessageStatus[] ms = null;
        IMAPStore s = (IMAPStore)this.store;
        IMAPConnection connection = s.getConnection();
        try {
            String[] cmds = new String[]{"FLAGS"};
            IMAPConnection iMAPConnection = connection;
            synchronized (iMAPConnection) {
                ms = connection.uidFetch(uids, cmds);
            }
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
        if (connection.alertsPending()) {
            s.processAlerts();
        }
        Message[] messages = new Message[ms.length];
        for (int i = 0; i < messages.length; ++i) {
            IMAPMessage message = new IMAPMessage(this, ms[i].getMessageNumber());
            message.update(ms[i]);
            messages[i] = message;
        }
        return messages;
    }

    public long getUID(Message message) throws MessagingException {
        if (this.mode == -1) {
            throw new FolderClosedException((Folder)this);
        }
        if (!(message instanceof IMAPMessage)) {
            throw new MethodNotSupportedException("not an IMAPMessage");
        }
        IMAPMessage m = (IMAPMessage)message;
        if (m.uid == -1L) {
            m.fetchUID();
        }
        return m.uid;
    }

    public Quota[] getQuota() throws MessagingException {
        IMAPStore s;
        if (this.mode == -1) {
            throw new FolderClosedException((Folder)this);
        }
        IMAPStore iMAPStore = s = (IMAPStore)this.store;
        synchronized (iMAPStore) {
            try {
                return s.connection.getquotaroot(this.path);
            }
            catch (IOException e) {
                throw new MessagingException(e.getMessage(), (Exception)e);
            }
        }
    }

    public synchronized int getUnreadMessageCount() throws MessagingException {
        return this.getMessageCountByCriteria("NOT SEEN");
    }

    public synchronized int getDeletedMessageCount() throws MessagingException {
        return this.getMessageCountByCriteria("DELETED");
    }

    public int getMessageCountByCriteria(String criteria) throws MessagingException {
        if (!this.isOpen()) {
            return -1;
        }
        IMAPStore s = (IMAPStore)this.store;
        IMAPConnection connection = s.getConnection();
        String[] criterias = new String[]{criteria};
        int[] ids = null;
        try {
            ids = connection.search(null, criterias);
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
        return ids.length;
    }

    public ACL[] getACL() throws MessagingException {
        if (!this.isOpen()) {
            return null;
        }
        IMAPStore s = (IMAPStore)this.store;
        IMAPConnection connection = s.getConnection();
        ArrayList<ACL> acc = new ArrayList<ACL>();
        try {
            Map acl = connection.getacl(this.path);
            for (Map.Entry entry : acl.entrySet()) {
                String name = (String)entry.getKey();
                Integer rights = (Integer)entry.getValue();
                ACL ace = new ACL(name);
                if (rights != null) {
                    ace.rights = new Rights();
                    ace.rights.rights = rights;
                }
                acc.add(ace);
            }
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
        ACL[] ret = new ACL[acc.size()];
        acc.toArray(ret);
        return ret;
    }

    public void addACL(ACL ace) throws MessagingException {
        if (!this.isOpen()) {
            return;
        }
        IMAPStore s = (IMAPStore)this.store;
        IMAPConnection connection = s.getConnection();
        try {
            Rights aceRights = ace.getRights();
            if (aceRights != null) {
                int rights = connection.listrights(this.path, ace.name);
                if (!connection.setacl(this.path, ace.name, rights |= aceRights.rights)) {
                    throw new MessagingException("can't set ACL");
                }
            }
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    public void removeACL(String name) throws MessagingException {
        if (!this.isOpen()) {
            return;
        }
        IMAPStore s = (IMAPStore)this.store;
        IMAPConnection connection = s.getConnection();
        try {
            if (!connection.deleteacl(this.path, name)) {
                throw new MessagingException("can't delete ACL");
            }
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    public void addRights(ACL ace) throws MessagingException {
        this.addACL(ace);
    }

    public void removeRights(ACL ace) throws MessagingException {
        if (!this.isOpen()) {
            return;
        }
        IMAPStore s = (IMAPStore)this.store;
        IMAPConnection connection = s.getConnection();
        try {
            Rights aceRights = ace.getRights();
            if (aceRights != null) {
                int rights = connection.listrights(this.path, ace.name);
                if (!connection.setacl(this.path, ace.name, rights -= aceRights.rights)) {
                    throw new MessagingException("can't set ACL");
                }
            }
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    public Rights listRights(String name) throws MessagingException {
        if (!this.isOpen()) {
            return null;
        }
        IMAPStore s = (IMAPStore)this.store;
        IMAPConnection connection = s.getConnection();
        try {
            Rights rights = new Rights();
            rights.rights = connection.listrights(this.path, name);
            return rights;
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    public Rights myRights() throws MessagingException {
        if (!this.isOpen()) {
            return null;
        }
        IMAPStore s = (IMAPStore)this.store;
        IMAPConnection connection = s.getConnection();
        try {
            Rights rights = new Rights();
            rights.rights = connection.myrights(this.path);
            return rights;
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }
}

