/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.ivy.core.LogOptions;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.Configuration$Visibility;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.FilterHelper;

public final class ResolveOptions
extends LogOptions {
    private String[] confs = new String[]{"*"};
    private String revision = null;
    private Date date = null;
    private boolean validate = true;
    private boolean useCacheOnly = false;
    private boolean transitive = true;
    private boolean download = true;
    private boolean outputReport = true;
    private Filter artifactFilter = FilterHelper.NO_FILTER;
    private String resolveMode;
    private String resolveId;
    private boolean refresh;
    private boolean checkIfChanged = false;

    public ResolveOptions() {
    }

    public ResolveOptions(ResolveOptions resolveOptions) {
        super(resolveOptions);
        this.confs = resolveOptions.confs;
        this.revision = resolveOptions.revision;
        this.date = resolveOptions.date;
        this.validate = resolveOptions.validate;
        this.refresh = resolveOptions.refresh;
        this.useCacheOnly = resolveOptions.useCacheOnly;
        this.transitive = resolveOptions.transitive;
        this.download = resolveOptions.download;
        this.outputReport = resolveOptions.outputReport;
        this.resolveMode = resolveOptions.resolveMode;
        this.artifactFilter = resolveOptions.artifactFilter;
        this.resolveId = resolveOptions.resolveId;
        this.checkIfChanged = resolveOptions.checkIfChanged;
    }

    public final Filter getArtifactFilter() {
        return this.artifactFilter;
    }

    public final String getResolveMode() {
        return this.resolveMode;
    }

    public final String[] getConfs(ModuleDescriptor moduleDescriptor) {
        ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
        String[] stringArray = this.confs;
        if (this.confs == null) {
            return moduleDescriptor2.getConfigurationsNames();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            Configuration[] configurationArray;
            if ("*".equals(stringArray[i])) {
                linkedHashSet.addAll(Arrays.asList(moduleDescriptor2.getConfigurationsNames()));
                continue;
            }
            if ("*(public)".equals(stringArray[i])) {
                configurationArray = moduleDescriptor2.getConfigurations();
                for (n = 0; n < configurationArray.length; ++n) {
                    if (!configurationArray[n].getVisibility().equals(Configuration$Visibility.PUBLIC)) continue;
                    linkedHashSet.add(configurationArray[n].getName());
                }
                continue;
            }
            if ("*(private)".equals(stringArray[i])) {
                configurationArray = moduleDescriptor2.getConfigurations();
                for (n = 0; n < configurationArray.length; ++n) {
                    if (!configurationArray[n].getVisibility().equals(Configuration$Visibility.PRIVATE)) continue;
                    linkedHashSet.add(configurationArray[n].getName());
                }
                continue;
            }
            if (stringArray[i].startsWith("!")) {
                linkedHashSet2.add(stringArray[i].substring(1));
                continue;
            }
            linkedHashSet.add(stringArray[i]);
        }
        Iterator iterator2 = linkedHashSet2.iterator();
        while (iterator2.hasNext()) {
            linkedHashSet.remove(iterator2.next());
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    public final ResolveOptions setConfs(String[] stringArray) {
        this.confs = stringArray;
        return this;
    }

    public final Date getDate() {
        return this.date;
    }

    public final boolean isDownload() {
        return this.download;
    }

    public final ResolveOptions setDownload$5370cc5a() {
        this.download = false;
        return this;
    }

    public final boolean isOutputReport() {
        return this.outputReport;
    }

    public final boolean isTransitive() {
        return this.transitive;
    }

    public final boolean isUseCacheOnly() {
        return this.useCacheOnly;
    }

    public final boolean isValidate() {
        return this.validate;
    }

    public final ResolveOptions setValidate(boolean bl) {
        this.validate = bl;
        return this;
    }

    public final String getResolveId() {
        return this.resolveId;
    }

    public final ResolveOptions setResolveId(String string) {
        this.resolveId = string;
        return this;
    }

    public final boolean isRefresh() {
        return this.refresh;
    }

    public final ResolveOptions setCheckIfChanged$5370cc5a() {
        this.checkIfChanged = false;
        return this;
    }

    public final boolean getCheckIfChanged() {
        return this.checkIfChanged;
    }

    public static String getDefaultResolveId(ModuleDescriptor moduleDescriptor) {
        return ResolveOptions.getDefaultResolveId(moduleDescriptor.getModuleRevisionId().getModuleId());
    }

    public static String getDefaultResolveId(ModuleId moduleId) {
        return moduleId.getOrganisation() + "-" + moduleId.getName();
    }

    static {
        String[] stringArray = new String[]{"default", "dynamic"};
    }
}

