/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.model.Vulnerabilities;
import org.zaproxy.zap.model.Vulnerability;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.ZapNumberSpinner;
import org.zaproxy.zap.utils.ZapTextArea;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.LayoutHelper;

public class AlertViewPanel
extends AbstractPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(AlertViewPanel.class);
    private JScrollPane defaultPane = null;
    private JScrollPane alertPane = null;
    private ZapTextArea defaultOutput = null;
    private JPanel alertDisplay = null;
    private CardLayout cardLayout = null;
    private ZapTextField alertUrl = null;
    private JLabel alertName = null;
    private JLabel alertRisk = null;
    private JLabel alertConfidence = null;
    private JLabel alertParam = null;
    private JLabel alertAttack = null;
    private JLabel alertEvidence = null;
    private ZapTextArea alertDescription = null;
    private ZapTextArea alertOtherInfo = null;
    private ZapTextArea alertSolution = null;
    private ZapTextArea alertReference = null;
    private JLabel alertCweId = null;
    private JLabel alertWascId = null;
    private JComboBox<String> alertEditName = null;
    private JComboBox<String> alertEditRisk = null;
    private JComboBox<String> alertEditConfidence = null;
    private JComboBox<String> alertEditParam = null;
    private ZapTextField alertEditAttack = null;
    private ZapTextField alertEditEvidence = null;
    private DefaultComboBoxModel<String> nameListModel = null;
    private DefaultComboBoxModel<String> paramListModel = null;
    private ZapNumberSpinner alertEditCweId = null;
    private ZapNumberSpinner alertEditWascId = null;
    private boolean editable = false;
    private Alert originalAlert = null;
    private List<Vulnerability> vulnerabilities = null;
    private HistoryReference historyRef = null;
    private HttpMessage httpMessage;

    public AlertViewPanel() {
        this(false);
    }

    public AlertViewPanel(boolean bl) {
        this.editable = bl;
        this.initialize();
    }

    private void initialize() {
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        this.setName("AlertView");
        if (!this.editable) {
            this.add((Component)this.getDefaultPane(), this.getDefaultPane().getName());
        }
        this.add((Component)this.getAlertPane(), this.getAlertPane().getName());
    }

    private JScrollPane getAlertPane() {
        if (this.alertPane == null) {
            this.alertPane = new JScrollPane();
            this.alertPane.setViewportView(this.getAlertDisplay());
            this.alertPane.setName("alertPane");
        }
        return this.alertPane;
    }

    private ZapTextArea createZapTextArea() {
        ZapTextArea zapTextArea = new ZapTextArea(3, 30);
        zapTextArea.setLineWrap(true);
        zapTextArea.setWrapStyleWord(true);
        zapTextArea.setEditable(this.editable);
        return zapTextArea;
    }

    private JScrollPane createJScrollPane(String string) {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(null, string, 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
        return jScrollPane;
    }

    private JPanel getAlertDisplay() {
        if (this.alertDisplay == null) {
            this.alertDisplay = new JPanel();
            this.alertDisplay.setLayout(new GridBagLayout());
            this.alertDisplay.setName("alertDisplay");
            this.alertEditName = new JComboBox();
            this.alertEditName.setEditable(true);
            this.nameListModel = new DefaultComboBoxModel();
            List<String> list = this.getAllVulnerabilityNames();
            this.nameListModel.addElement("");
            for (String object2 : list) {
                this.nameListModel.addElement(object2);
            }
            this.alertEditName.setModel(this.nameListModel);
            this.alertEditName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Vulnerability vulnerability;
                    if ("comboBoxChanged".equals(actionEvent.getActionCommand()) && (vulnerability = AlertViewPanel.this.getVulnerability((String)AlertViewPanel.this.alertEditName.getSelectedItem())) != null) {
                        if (vulnerability.getDescription() != null && vulnerability.getDescription().length() > 0) {
                            AlertViewPanel.this.setAlertDescription(vulnerability.getDescription());
                        }
                        if (vulnerability.getSolution() != null && vulnerability.getSolution().length() > 0) {
                            AlertViewPanel.this.setAlertSolution(vulnerability.getSolution());
                        }
                        if (vulnerability.getReferences() != null) {
                            StringBuilder stringBuilder = new StringBuilder();
                            for (String string : vulnerability.getReferences()) {
                                stringBuilder.append(string);
                                stringBuilder.append('\n');
                            }
                            AlertViewPanel.this.setAlertReference(stringBuilder.toString());
                        }
                        AlertViewPanel.this.alertEditWascId.setValue(vulnerability.getWascId());
                    }
                }
            });
            this.alertEditRisk = new JComboBox<String>(Alert.MSG_RISK);
            this.alertEditConfidence = new JComboBox<String>(Alert.MSG_CONFIDENCE);
            this.alertEditConfidence.setSelectedItem(Alert.MSG_CONFIDENCE[2]);
            this.alertEditAttack = new ZapTextField();
            this.paramListModel = new DefaultComboBoxModel();
            this.paramListModel.addElement("");
            this.alertEditParam = new JComboBox();
            this.alertEditParam.setModel(this.paramListModel);
            this.alertEditParam.setEditable(true);
            this.alertEditEvidence = new ZapTextField();
            this.alertEditCweId = new ZapNumberSpinner();
            this.alertEditWascId = new ZapNumberSpinner();
            this.alertName = new JLabel();
            this.alertName.setFont(FontUtils.getFont(1));
            this.alertRisk = new JLabel();
            this.alertConfidence = new JLabel();
            this.alertParam = new JLabel();
            this.alertAttack = new JLabel();
            this.alertEvidence = new JLabel();
            this.alertCweId = new JLabel();
            this.alertWascId = new JLabel();
            this.alertUrl = new ZapTextField();
            this.alertDescription = this.createZapTextArea();
            JScrollPane jScrollPane = this.createJScrollPane(Constant.messages.getString("alert.label.desc"));
            jScrollPane.setViewportView(this.alertDescription);
            this.alertDescription.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 9) {
                        AlertViewPanel.this.alertDescription.transferFocus();
                    }
                }
            });
            this.alertOtherInfo = this.createZapTextArea();
            JScrollPane jScrollPane2 = this.createJScrollPane(Constant.messages.getString("alert.label.other"));
            jScrollPane2.setViewportView(this.alertOtherInfo);
            this.alertOtherInfo.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 9) {
                        AlertViewPanel.this.alertOtherInfo.transferFocus();
                    }
                }
            });
            this.alertSolution = this.createZapTextArea();
            JScrollPane jScrollPane3 = this.createJScrollPane(Constant.messages.getString("alert.label.solution"));
            jScrollPane3.setViewportView(this.alertSolution);
            this.alertSolution.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 9) {
                        AlertViewPanel.this.alertSolution.transferFocus();
                    }
                }
            });
            this.alertReference = this.createZapTextArea();
            JScrollPane jScrollPane4 = this.createJScrollPane(Constant.messages.getString("alert.label.ref"));
            jScrollPane4.setViewportView(this.alertReference);
            this.alertReference.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 9) {
                        AlertViewPanel.this.alertReference.transferFocus();
                    }
                }
            });
            if (this.editable) {
                this.alertDisplay.add(this.alertEditName, LayoutHelper.getGBC(0, 0, 2, 0.0, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)new JLabel(Constant.messages.getString("alert.label.url")), LayoutHelper.getGBC(0, 1, 1, 0.25, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)this.alertUrl, LayoutHelper.getGBC(1, 1, 1, 0.75, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)new JLabel(Constant.messages.getString("alert.label.risk")), LayoutHelper.getGBC(0, 2, 1, 0.25, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add(this.alertEditRisk, LayoutHelper.getGBC(1, 2, 1, 0.75, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)new JLabel(Constant.messages.getString("alert.label.confidence")), LayoutHelper.getGBC(0, 3, 1, 0.25, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add(this.alertEditConfidence, LayoutHelper.getGBC(1, 3, 1, 0.75, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)new JLabel(Constant.messages.getString("alert.label.parameter")), LayoutHelper.getGBC(0, 4, 1, 0.25, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add(this.alertEditParam, LayoutHelper.getGBC(1, 4, 1, 0.75, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)new JLabel(Constant.messages.getString("alert.label.attack")), LayoutHelper.getGBC(0, 5, 1, 0.25, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)this.alertEditAttack, LayoutHelper.getGBC(1, 5, 1, 0.75, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)new JLabel(Constant.messages.getString("alert.label.evidence")), LayoutHelper.getGBC(0, 6, 1, 0.25, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)this.alertEditEvidence, LayoutHelper.getGBC(1, 6, 1, 0.75, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)new JLabel(Constant.messages.getString("alert.label.cweid")), LayoutHelper.getGBC(0, 7, 1, 0.25, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)this.alertEditCweId, LayoutHelper.getGBC(1, 7, 1, 0.75, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)new JLabel(Constant.messages.getString("alert.label.wascid")), LayoutHelper.getGBC(0, 8, 1, 0.25, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)this.alertEditWascId, LayoutHelper.getGBC(1, 8, 1, 0.75, new Insets(1, 1, 1, 1)));
            } else {
                this.alertUrl.setEditable(false);
                this.alertDisplay.add((Component)this.alertName, LayoutHelper.getGBC(0, 0, 2, 0.0, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)new JLabel(Constant.messages.getString("alert.label.url")), LayoutHelper.getGBC(0, 1, 1, 0.25, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)this.alertUrl, LayoutHelper.getGBC(1, 1, 1, 0.75, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)new JLabel(Constant.messages.getString("alert.label.risk")), LayoutHelper.getGBC(0, 2, 1, 0.25, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)this.alertRisk, LayoutHelper.getGBC(1, 2, 1, 0.75, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)new JLabel(Constant.messages.getString("alert.label.confidence")), LayoutHelper.getGBC(0, 3, 1, 0.25, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)this.alertConfidence, LayoutHelper.getGBC(1, 3, 1, 0.75, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)new JLabel(Constant.messages.getString("alert.label.parameter")), LayoutHelper.getGBC(0, 4, 1, 0.25, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)this.alertParam, LayoutHelper.getGBC(1, 4, 1, 0.75, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)new JLabel(Constant.messages.getString("alert.label.attack")), LayoutHelper.getGBC(0, 5, 1, 0.25, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)this.alertAttack, LayoutHelper.getGBC(1, 5, 1, 0.75, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)new JLabel(Constant.messages.getString("alert.label.evidence")), LayoutHelper.getGBC(0, 6, 1, 0.25, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)this.alertEvidence, LayoutHelper.getGBC(1, 6, 1, 0.75, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)new JLabel(Constant.messages.getString("alert.label.cweid")), LayoutHelper.getGBC(0, 7, 1, 0.25, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)this.alertCweId, LayoutHelper.getGBC(1, 7, 1, 0.75, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)new JLabel(Constant.messages.getString("alert.label.wascid")), LayoutHelper.getGBC(0, 8, 1, 0.25, new Insets(1, 1, 1, 1)));
                this.alertDisplay.add((Component)this.alertWascId, LayoutHelper.getGBC(1, 8, 1, 0.75, new Insets(1, 1, 1, 1)));
            }
            this.alertDisplay.add((Component)jScrollPane, LayoutHelper.getGBC(0, 9, 2, 1.0, 1.0, 1, new Insets(1, 1, 1, 1)));
            this.alertDisplay.add((Component)jScrollPane2, LayoutHelper.getGBC(0, 10, 2, 1.0, 1.0, 1, new Insets(1, 1, 1, 1)));
            this.alertDisplay.add((Component)jScrollPane3, LayoutHelper.getGBC(0, 11, 2, 1.0, 1.0, 1, new Insets(1, 1, 1, 1)));
            this.alertDisplay.add((Component)jScrollPane4, LayoutHelper.getGBC(0, 12, 2, 1.0, 1.0, 1, new Insets(1, 1, 1, 1)));
        }
        return this.alertDisplay;
    }

    public void displayAlert(Alert alert) {
        this.originalAlert = alert;
        this.alertUrl.setText(alert.getUri());
        if (this.editable) {
            this.nameListModel.addElement(alert.getName());
            this.alertEditName.setSelectedItem(alert.getName());
            this.alertEditRisk.setSelectedItem(Alert.MSG_RISK[alert.getRisk()]);
            this.alertEditConfidence.setSelectedItem(Alert.MSG_CONFIDENCE[alert.getConfidence()]);
            this.alertEditParam.setSelectedItem(alert.getParam());
            this.alertEditAttack.setText(alert.getAttack());
            this.alertEditAttack.discardAllEdits();
            this.alertEditEvidence.setText(alert.getEvidence());
            this.alertEditEvidence.discardAllEdits();
            this.alertEditCweId.setValue(alert.getCweId());
            this.alertEditWascId.setValue(alert.getWascId());
        } else {
            this.alertName.setText(alert.getName());
            this.alertRisk.setText(Alert.MSG_RISK[alert.getRisk()]);
            if (alert.getConfidence() == 0) {
                this.alertRisk.setIcon(new ImageIcon(Constant.OK_FLAG_IMAGE_URL));
            } else {
                this.alertRisk.setIcon(new ImageIcon(alert.getIconUrl()));
            }
            this.alertConfidence.setText(Alert.MSG_CONFIDENCE[alert.getConfidence()]);
            this.alertParam.setText(alert.getParam());
            this.alertAttack.setText(alert.getAttack());
            this.alertEvidence.setText(alert.getEvidence());
            this.alertCweId.setText(Integer.toString(alert.getCweId()));
            this.alertWascId.setText(Integer.toString(alert.getWascId()));
        }
        this.setAlertDescription(alert.getDescription());
        this.setAlertOtherInfo(alert.getOtherInfo());
        this.setAlertSolution(alert.getSolution());
        this.setAlertReference(alert.getReference());
        this.cardLayout.show(this, this.getAlertPane().getName());
    }

    public void clearAlert() {
        this.cardLayout.show(this, this.getDefaultPane().getName());
        this.originalAlert = null;
        this.historyRef = null;
        this.httpMessage = null;
        this.alertName.setText("");
        this.alertRisk.setText("");
        this.alertConfidence.setText("");
        this.alertParam.setText("");
        this.alertAttack.setText("");
        this.alertDescription.setText("");
        this.alertOtherInfo.setText("");
        this.alertSolution.setText("");
        this.alertReference.setText("");
        if (this.editable) {
            this.alertEditAttack.setText("");
            this.alertEditAttack.discardAllEdits();
            this.alertEditEvidence.setText("");
            this.alertEditEvidence.discardAllEdits();
            this.alertDescription.discardAllEdits();
            this.alertOtherInfo.discardAllEdits();
            this.alertSolution.discardAllEdits();
            this.alertReference.discardAllEdits();
        }
    }

    private JScrollPane getDefaultPane() {
        if (this.defaultPane == null) {
            this.defaultPane = new JScrollPane();
            this.defaultPane.setViewportView(this.getDefaultOutput());
            this.defaultPane.setName("defaultPane");
            this.defaultPane.setHorizontalScrollBarPolicy(31);
        }
        return this.defaultPane;
    }

    private ZapTextArea getDefaultOutput() {
        if (this.defaultOutput == null) {
            this.defaultOutput = new ZapTextArea();
            this.defaultOutput.setEditable(false);
            this.defaultOutput.setLineWrap(true);
            this.defaultOutput.setName("");
            this.defaultOutput.append(Constant.messages.getString("alerts.label.defaultMessage"));
        }
        return this.defaultOutput;
    }

    public void append(final String string) {
        if (EventQueue.isDispatchThread()) {
            this.getDefaultOutput().append(string);
            return;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    AlertViewPanel.this.getDefaultOutput().append(string);
                }
            });
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public void clear() {
        this.getDefaultOutput().setText("");
    }

    public void setParamNames(String[] stringArray) {
        for (String string : stringArray) {
            this.paramListModel.addElement(string);
        }
    }

    public Alert getAlert() {
        if (!this.editable && this.originalAlert != null) {
            Alert alert = this.originalAlert.newInstance();
            alert.setAlertId(this.originalAlert.getAlertId());
            alert.setName((String)this.alertEditName.getSelectedItem());
            alert.setParam((String)this.alertEditParam.getSelectedItem());
            alert.setRiskConfidence(this.alertEditRisk.getSelectedIndex(), this.alertEditConfidence.getSelectedIndex());
            alert.setDescription(this.alertDescription.getText());
            alert.setOtherInfo(this.alertOtherInfo.getText());
            alert.setSolution(this.alertSolution.getText());
            alert.setReference(this.alertReference.getText());
            alert.setEvidence(this.alertEvidence.getText());
            alert.setCweId(this.alertEditCweId.getValue());
            alert.setWascId(this.alertEditWascId.getValue());
            alert.setHistoryRef(this.historyRef);
            return alert;
        }
        Alert alert = new Alert(-1, this.alertEditRisk.getSelectedIndex(), this.alertEditConfidence.getSelectedIndex(), (String)this.alertEditName.getSelectedItem());
        alert.setHistoryRef(this.historyRef);
        if (this.originalAlert != null) {
            alert.setAlertId(this.originalAlert.getAlertId());
        }
        String string = null;
        HttpMessage httpMessage = null;
        if (this.httpMessage != null) {
            string = this.httpMessage.getRequestHeader().getURI().toString();
            httpMessage = this.httpMessage;
        } else if (this.historyRef != null) {
            try {
                string = this.historyRef.getURI().toString();
                httpMessage = this.historyRef.getHttpMessage();
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        } else if (this.originalAlert != null) {
            string = this.originalAlert.getUri();
            httpMessage = this.originalAlert.getMessage();
        }
        alert.setDetail(this.alertDescription.getText(), string, (String)this.alertEditParam.getSelectedItem(), this.alertEditAttack.getText(), this.alertOtherInfo.getText(), this.alertSolution.getText(), this.alertReference.getText(), this.alertEditEvidence.getText(), this.alertEditCweId.getValue(), this.alertEditWascId.getValue(), httpMessage);
        return alert;
    }

    public Alert getOriginalAlert() {
        return this.originalAlert;
    }

    public void setHistoryRef(HistoryReference historyReference) {
        this.historyRef = historyReference;
        this.httpMessage = null;
        try {
            if (historyReference != null) {
                HttpMessage httpMessage = historyReference.getHttpMessage();
                this.setParamNames(httpMessage.getParamNames());
                this.alertUrl.setText(httpMessage.getRequestHeader().getURI().toString());
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public void setHttpMessage(HttpMessage httpMessage) {
        this.httpMessage = httpMessage;
        this.setParamNames(httpMessage.getParamNames());
        this.alertUrl.setText(httpMessage.getRequestHeader().getURI().toString());
        this.historyRef = null;
    }

    public boolean isEditable() {
        return this.editable;
    }

    private List<Vulnerability> getAllVulnerabilities() {
        if (this.vulnerabilities == null) {
            this.vulnerabilities = Vulnerabilities.getAllVulnerabilities();
        }
        return this.vulnerabilities;
    }

    private Vulnerability getVulnerability(String string) {
        if (string == null) {
            return null;
        }
        List<Vulnerability> list = this.getAllVulnerabilities();
        for (Vulnerability vulnerability : list) {
            if (!string.equals(vulnerability.getAlert())) continue;
            return vulnerability;
        }
        return null;
    }

    private List<String> getAllVulnerabilityNames() {
        List<Vulnerability> list = this.getAllVulnerabilities();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Vulnerability vulnerability : list) {
            arrayList.add(vulnerability.getAlert());
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private void setAlertDescription(String string) {
        AlertViewPanel.setTextDiscardEditsAndInitCaretPosition(this.alertDescription, string);
    }

    private void setAlertOtherInfo(String string) {
        AlertViewPanel.setTextDiscardEditsAndInitCaretPosition(this.alertOtherInfo, string);
    }

    private void setAlertSolution(String string) {
        AlertViewPanel.setTextDiscardEditsAndInitCaretPosition(this.alertSolution, string);
    }

    private void setAlertReference(String string) {
        AlertViewPanel.setTextDiscardEditsAndInitCaretPosition(this.alertReference, string);
    }

    private static void setTextDiscardEditsAndInitCaretPosition(ZapTextArea zapTextArea, String string) {
        zapTextArea.setText(string);
        zapTextArea.discardAllEdits();
        zapTextArea.setCaretPosition(0);
    }
}

