/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.sessions;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.extension.sessions.ExtensionSessionManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.session.AbstractSessionManagementMethodOptionsPanel;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.session.SessionManagementMethodType;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.LayoutHelper;

public class ContextSessionManagementPanel
extends AbstractContextPropertiesPanel {
    private static final String PANEL_NAME = Constant.messages.getString("sessionmanagement.panel.title");
    private static final String CONFIG_NOT_NEEDED = Constant.messages.getString("sessionmanagement.panel.label.noConfigPanel");
    private static final Logger log = Logger.getLogger(ContextSessionManagementPanel.class);
    private static final long serialVersionUID = 6125457981814742851L;
    private ExtensionSessionManagement extension;
    private JComboBox<SessionManagementMethodType> sessionManagementMethodsComboBox;
    private SessionManagementMethod selectedMethod;
    private SessionManagementMethodType shownMethodType;
    private AbstractSessionManagementMethodOptionsPanel shownConfigPanel;
    private JPanel configContainerPanel;

    public ContextSessionManagementPanel(ExtensionSessionManagement extensionSessionManagement, Context context) {
        super(context.getIndex());
        this.extension = extensionSessionManagement;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(this.getContextIndex() + ": " + PANEL_NAME);
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.add((Component)new JLabel(Constant.messages.getString("sessionmanagement.panel.label.description")), LayoutHelper.getGBC(0, 0, 1, 1.0));
        this.add((Component)new JLabel(Constant.messages.getString("sessionmanagement.panel.label.typeSelect")), LayoutHelper.getGBC(0, 1, 1, 1.0, new Insets(20, 0, 5, 5)));
        this.add(this.getSessionManagementMethodsComboBox(), LayoutHelper.getGBC(0, 2, 1, 1.0));
        this.add((Component)this.getConfigContainerPanel(), LayoutHelper.getGBC(0, 3, 1, 1.0, new Insets(10, 0, 10, 0)));
        this.add((Component)new JLabel(), LayoutHelper.getGBC(0, 99, 1, 1.0, 1.0));
    }

    private void changeMethodConfigPanel(SessionManagementMethodType sessionManagementMethodType) {
        if (sessionManagementMethodType == null) {
            this.getConfigContainerPanel().removeAll();
            this.getConfigContainerPanel().setVisible(false);
            this.shownMethodType = null;
            this.shownConfigPanel = null;
            return;
        }
        if (this.shownMethodType != null && sessionManagementMethodType.getClass().equals(this.shownMethodType.getClass())) {
            return;
        }
        log.debug((Object)("Creating new panel for configuring: " + sessionManagementMethodType.getName()));
        this.getConfigContainerPanel().removeAll();
        if (sessionManagementMethodType.hasOptionsPanel()) {
            this.shownConfigPanel = sessionManagementMethodType.buildOptionsPanel(this.getUISharedContext());
            this.getConfigContainerPanel().add((Component)this.shownConfigPanel, "Center");
        } else {
            this.shownConfigPanel = null;
            this.getConfigContainerPanel().add((Component)new JLabel("<html><p>" + CONFIG_NOT_NEEDED + "</p></html>"), "Center");
        }
        this.shownMethodType = sessionManagementMethodType;
        this.getConfigContainerPanel().setVisible(true);
        this.getConfigContainerPanel().revalidate();
    }

    protected JComboBox<SessionManagementMethodType> getSessionManagementMethodsComboBox() {
        if (this.sessionManagementMethodsComboBox == null) {
            Vector<SessionManagementMethodType> vector = new Vector<SessionManagementMethodType>(this.extension.getSessionManagementMethodTypes());
            this.sessionManagementMethodsComboBox = new JComboBox<SessionManagementMethodType>(vector);
            this.sessionManagementMethodsComboBox.setSelectedItem(null);
            this.sessionManagementMethodsComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        log.debug((Object)("Selected new Session Management type: " + itemEvent.getItem()));
                        SessionManagementMethodType sessionManagementMethodType = (SessionManagementMethodType)itemEvent.getItem();
                        if (ContextSessionManagementPanel.this.selectedMethod == null || !sessionManagementMethodType.isTypeForMethod(ContextSessionManagementPanel.this.selectedMethod)) {
                            ContextSessionManagementPanel.this.selectedMethod = sessionManagementMethodType.createSessionManagementMethod(ContextSessionManagementPanel.this.getContextIndex());
                        }
                        ContextSessionManagementPanel.this.changeMethodConfigPanel(sessionManagementMethodType);
                        if (sessionManagementMethodType.hasOptionsPanel()) {
                            ContextSessionManagementPanel.this.shownConfigPanel.bindMethod(ContextSessionManagementPanel.this.selectedMethod);
                        }
                    }
                }
            });
        }
        return this.sessionManagementMethodsComboBox;
    }

    private JPanel getConfigContainerPanel() {
        if (this.configContainerPanel == null) {
            this.configContainerPanel = new JPanel(new BorderLayout());
            this.configContainerPanel.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("sessionmanagement.panel.config.title"), 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
        }
        return this.configContainerPanel;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.contexts";
    }

    @Override
    public void initContextData(Session session, Context context) {
        this.selectedMethod = context.getSessionManagementMethod();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing configuration panel for session management method: " + this.selectedMethod + " for context " + context.getName()));
        }
        if (this.selectedMethod != null) {
            if (this.shownMethodType != null && this.shownMethodType.isTypeForMethod(this.selectedMethod)) {
                if (this.shownMethodType.hasOptionsPanel()) {
                    this.shownConfigPanel.bindMethod(this.selectedMethod);
                }
                return;
            }
            for (SessionManagementMethodType sessionManagementMethodType : this.extension.getSessionManagementMethodTypes()) {
                if (!sessionManagementMethodType.isTypeForMethod(this.selectedMethod)) continue;
                this.getSessionManagementMethodsComboBox().setSelectedItem(sessionManagementMethodType);
                break;
            }
        }
    }

    @Override
    public void validateContextData(Session session) throws IllegalStateException {
        if (this.selectedMethod == null) {
            throw new IllegalStateException("A valid session management method has to be selected for Context " + this.getUISharedContext().getName());
        }
        if (this.shownConfigPanel != null) {
            this.shownConfigPanel.validateFields();
        }
    }

    @Override
    public void saveContextData(Session session) throws Exception {
        if (this.shownConfigPanel != null) {
            this.shownConfigPanel.saveMethod();
        }
        session.getContext(this.getContextIndex()).setSessionManagementMethod(this.selectedMethod);
    }

    @Override
    public void saveTemporaryContextData(Context context) {
        if (this.shownConfigPanel != null) {
            this.shownConfigPanel.saveMethod();
        }
        context.setSessionManagementMethod(this.selectedMethod);
    }
}

