/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.Utility;

public final class AnalyzerCaster {
    /*
     * Enabled aggressive block sorting
     */
    public static Definition.Cast getLegalCast(Location location, Definition.Type actual, Definition.Type expected, boolean explicit, boolean internal) {
        if (actual == null || expected == null) {
            throw new IllegalStateException("Neither actual [" + actual + "] nor expected [" + expected + "] can be null");
        }
        if (actual.equals(expected)) {
            return null;
        }
        block0 : switch (actual.sort) {
            case BOOL: {
                switch (expected.sort) {
                    case DEF: {
                        return new Definition.Cast(actual, Definition.DEF_TYPE, explicit, false, false, true, false);
                    }
                    case OBJECT: {
                        if (Definition.OBJECT_TYPE.equals(expected) && internal) {
                            return new Definition.Cast(actual, actual, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case BOOL_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, actual, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                }
                break;
            }
            case BYTE: {
                switch (expected.sort) {
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return new Definition.Cast(actual, expected, explicit);
                    }
                    case CHAR: {
                        if (explicit) {
                            return new Definition.Cast(actual, expected, true);
                        }
                        break block0;
                    }
                    case DEF: {
                        return new Definition.Cast(actual, Definition.DEF_TYPE, explicit, false, false, true, false);
                    }
                    case OBJECT: {
                        if (Definition.OBJECT_TYPE.equals(expected) && internal) {
                            return new Definition.Cast(actual, actual, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case NUMBER: 
                    case BYTE_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, actual, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case SHORT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, Definition.SHORT_TYPE, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case INT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, Definition.INT_TYPE, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case LONG_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, Definition.LONG_TYPE, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case FLOAT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, Definition.FLOAT_TYPE, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case DOUBLE_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, Definition.DOUBLE_TYPE, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case CHAR_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.CHAR_TYPE, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                }
                break;
            }
            case SHORT: {
                switch (expected.sort) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return new Definition.Cast(actual, expected, explicit);
                    }
                    case CHAR: 
                    case BYTE: {
                        if (explicit) {
                            return new Definition.Cast(actual, expected, true);
                        }
                        break block0;
                    }
                    case DEF: {
                        return new Definition.Cast(actual, Definition.DEF_TYPE, explicit, false, false, true, false);
                    }
                    case OBJECT: {
                        if (Definition.OBJECT_TYPE.equals(expected) && internal) {
                            return new Definition.Cast(actual, actual, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case NUMBER: 
                    case SHORT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, actual, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case INT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, Definition.INT_TYPE, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case LONG_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, Definition.LONG_TYPE, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case FLOAT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, Definition.FLOAT_TYPE, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case DOUBLE_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, Definition.DOUBLE_TYPE, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case BYTE_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.BYTE_TYPE, true, false, false, false, true);
                        }
                        break block0;
                    }
                    case CHAR_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.CHAR_TYPE, true, false, false, false, true);
                        }
                        break block0;
                    }
                }
                break;
            }
            case CHAR: {
                switch (expected.sort) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return new Definition.Cast(actual, expected, explicit);
                    }
                    case SHORT: 
                    case BYTE: {
                        if (explicit) {
                            return new Definition.Cast(actual, expected, true);
                        }
                        break block0;
                    }
                    case DEF: {
                        return new Definition.Cast(actual, Definition.DEF_TYPE, explicit, false, false, true, false);
                    }
                    case OBJECT: {
                        if (Definition.OBJECT_TYPE.equals(expected) && internal) {
                            return new Definition.Cast(actual, actual, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case NUMBER: 
                    case CHAR_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, actual, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case STRING: {
                        return new Definition.Cast(actual, Definition.STRING_TYPE, explicit, false, false, false, false);
                    }
                    case INT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, Definition.INT_TYPE, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case LONG_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, Definition.LONG_TYPE, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case FLOAT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, Definition.FLOAT_TYPE, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case DOUBLE_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, Definition.DOUBLE_TYPE, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case BYTE_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.BYTE_TYPE, true, false, false, false, true);
                        }
                        break block0;
                    }
                    case SHORT_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.SHORT_TYPE, true, false, false, false, true);
                        }
                        break block0;
                    }
                }
                break;
            }
            case INT: {
                switch (expected.sort) {
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return new Definition.Cast(actual, expected, explicit);
                    }
                    case SHORT: 
                    case CHAR: 
                    case BYTE: {
                        if (explicit) {
                            return new Definition.Cast(actual, expected, true);
                        }
                        break block0;
                    }
                    case DEF: {
                        return new Definition.Cast(actual, Definition.DEF_TYPE, explicit, false, false, true, false);
                    }
                    case OBJECT: {
                        if (Definition.OBJECT_TYPE.equals(expected) && internal) {
                            return new Definition.Cast(actual, actual, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case NUMBER: 
                    case INT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, actual, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case LONG_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, Definition.LONG_TYPE, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case FLOAT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, Definition.FLOAT_TYPE, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case DOUBLE_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, Definition.DOUBLE_TYPE, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case BYTE_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.BYTE_TYPE, true, false, false, false, true);
                        }
                        break block0;
                    }
                    case SHORT_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.SHORT_TYPE, true, false, false, false, true);
                        }
                        break block0;
                    }
                    case CHAR_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.CHAR_TYPE, true, false, false, false, true);
                        }
                        break block0;
                    }
                }
                break;
            }
            case LONG: {
                switch (expected.sort) {
                    case FLOAT: 
                    case DOUBLE: {
                        return new Definition.Cast(actual, expected, explicit);
                    }
                    case SHORT: 
                    case INT: 
                    case CHAR: 
                    case BYTE: {
                        if (explicit) {
                            return new Definition.Cast(actual, expected, true);
                        }
                        break block0;
                    }
                    case DEF: {
                        return new Definition.Cast(actual, Definition.DEF_TYPE, explicit, false, false, true, false);
                    }
                    case OBJECT: {
                        if (Definition.OBJECT_TYPE.equals(expected) && internal) {
                            return new Definition.Cast(actual, actual, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case NUMBER: 
                    case LONG_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, actual, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case FLOAT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, Definition.FLOAT_TYPE, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case DOUBLE_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, Definition.DOUBLE_TYPE, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case BYTE_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.BYTE_TYPE, true, false, false, false, true);
                        }
                        break block0;
                    }
                    case SHORT_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.SHORT_TYPE, true, false, false, false, true);
                        }
                        break block0;
                    }
                    case CHAR_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.CHAR_TYPE, true, false, false, false, true);
                        }
                        break block0;
                    }
                    case INT_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.INT_TYPE, true, false, false, false, true);
                        }
                        break block0;
                    }
                }
                break;
            }
            case FLOAT: {
                switch (expected.sort) {
                    case DOUBLE: {
                        return new Definition.Cast(actual, expected, explicit);
                    }
                    case SHORT: 
                    case INT: 
                    case FLOAT: 
                    case CHAR: 
                    case BYTE: {
                        if (explicit) {
                            return new Definition.Cast(actual, expected, true);
                        }
                        break block0;
                    }
                    case DEF: {
                        return new Definition.Cast(actual, Definition.DEF_TYPE, explicit, false, false, true, false);
                    }
                    case OBJECT: {
                        if (Definition.OBJECT_TYPE.equals(expected) && internal) {
                            return new Definition.Cast(actual, actual, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case NUMBER: 
                    case FLOAT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, actual, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case DOUBLE_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, Definition.DOUBLE_TYPE, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case BYTE_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.BYTE_TYPE, true, false, false, false, true);
                        }
                        break block0;
                    }
                    case SHORT_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.SHORT_TYPE, true, false, false, false, true);
                        }
                        break block0;
                    }
                    case CHAR_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.CHAR_TYPE, true, false, false, false, true);
                        }
                        break block0;
                    }
                    case INT_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.INT_TYPE, true, false, false, false, true);
                        }
                        break block0;
                    }
                    case LONG_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.LONG_TYPE, true, false, false, false, true);
                        }
                        break block0;
                    }
                }
                break;
            }
            case DOUBLE: {
                switch (expected.sort) {
                    case SHORT: 
                    case INT: 
                    case FLOAT: 
                    case CHAR: 
                    case BYTE: {
                        if (explicit) {
                            return new Definition.Cast(actual, expected, true);
                        }
                        break block0;
                    }
                    case DEF: {
                        return new Definition.Cast(actual, Definition.DEF_TYPE, explicit, false, false, true, false);
                    }
                    case OBJECT: {
                        if (Definition.OBJECT_TYPE.equals(expected) && internal) {
                            return new Definition.Cast(actual, actual, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case NUMBER: 
                    case DOUBLE_OBJ: {
                        if (internal) {
                            return new Definition.Cast(actual, actual, explicit, false, false, false, true);
                        }
                        break block0;
                    }
                    case BYTE_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.BYTE_TYPE, true, false, false, false, true);
                        }
                        break block0;
                    }
                    case SHORT_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.SHORT_TYPE, true, false, false, false, true);
                        }
                        break block0;
                    }
                    case CHAR_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.CHAR_TYPE, true, false, false, false, true);
                        }
                        break block0;
                    }
                    case INT_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.INT_TYPE, true, false, false, false, true);
                        }
                        break block0;
                    }
                    case LONG_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.LONG_TYPE, true, false, false, false, true);
                        }
                        break block0;
                    }
                    case FLOAT_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(actual, Definition.FLOAT_TYPE, true, false, false, false, true);
                        }
                        break block0;
                    }
                }
                break;
            }
            case OBJECT: {
                if (!Definition.OBJECT_TYPE.equals(actual)) break;
                switch (expected.sort) {
                    case BYTE: {
                        if (internal && explicit) {
                            return new Definition.Cast(actual, Definition.BYTE_OBJ_TYPE, true, false, true, false, false);
                        }
                        break block0;
                    }
                    case SHORT: {
                        if (internal && explicit) {
                            return new Definition.Cast(actual, Definition.SHORT_OBJ_TYPE, true, false, true, false, false);
                        }
                        break block0;
                    }
                    case CHAR: {
                        if (internal && explicit) {
                            return new Definition.Cast(actual, Definition.CHAR_OBJ_TYPE, true, false, true, false, false);
                        }
                        break block0;
                    }
                    case INT: {
                        if (internal && explicit) {
                            return new Definition.Cast(actual, Definition.INT_OBJ_TYPE, true, false, true, false, false);
                        }
                        break block0;
                    }
                    case LONG: {
                        if (internal && explicit) {
                            return new Definition.Cast(actual, Definition.LONG_OBJ_TYPE, true, false, true, false, false);
                        }
                        break block0;
                    }
                    case FLOAT: {
                        if (internal && explicit) {
                            return new Definition.Cast(actual, Definition.FLOAT_OBJ_TYPE, true, false, true, false, false);
                        }
                        break block0;
                    }
                    case DOUBLE: {
                        if (internal && explicit) {
                            return new Definition.Cast(actual, Definition.DOUBLE_OBJ_TYPE, true, false, true, false, false);
                        }
                        break block0;
                    }
                }
                break;
            }
            case NUMBER: {
                switch (expected.sort) {
                    case BYTE: {
                        if (internal && explicit) {
                            return new Definition.Cast(actual, Definition.BYTE_OBJ_TYPE, true, false, true, false, false);
                        }
                        break block0;
                    }
                    case SHORT: {
                        if (internal && explicit) {
                            return new Definition.Cast(actual, Definition.SHORT_OBJ_TYPE, true, false, true, false, false);
                        }
                        break block0;
                    }
                    case CHAR: {
                        if (internal && explicit) {
                            return new Definition.Cast(actual, Definition.CHAR_OBJ_TYPE, true, false, true, false, false);
                        }
                        break block0;
                    }
                    case INT: {
                        if (internal && explicit) {
                            return new Definition.Cast(actual, Definition.INT_OBJ_TYPE, true, false, true, false, false);
                        }
                        break block0;
                    }
                    case LONG: {
                        if (internal && explicit) {
                            return new Definition.Cast(actual, Definition.LONG_OBJ_TYPE, true, false, true, false, false);
                        }
                        break block0;
                    }
                    case FLOAT: {
                        if (internal && explicit) {
                            return new Definition.Cast(actual, Definition.FLOAT_OBJ_TYPE, true, false, true, false, false);
                        }
                        break block0;
                    }
                    case DOUBLE: {
                        if (internal && explicit) {
                            return new Definition.Cast(actual, Definition.DOUBLE_OBJ_TYPE, true, false, true, false, false);
                        }
                        break block0;
                    }
                }
                break;
            }
            case BOOL_OBJ: {
                switch (expected.sort) {
                    case BOOL: {
                        if (internal) {
                            return new Definition.Cast(actual, expected, explicit, true, false, false, false);
                        }
                        break block0;
                    }
                }
                break;
            }
            case BYTE_OBJ: {
                switch (expected.sort) {
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case BYTE: {
                        if (internal) {
                            return new Definition.Cast(actual, expected, explicit, true, false, false, false);
                        }
                        break block0;
                    }
                    case CHAR: {
                        if (internal && explicit) {
                            return new Definition.Cast(actual, expected, true, true, false, false, false);
                        }
                        break block0;
                    }
                }
                break;
            }
            case SHORT_OBJ: {
                switch (expected.sort) {
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        if (internal) {
                            return new Definition.Cast(actual, expected, explicit, true, false, false, false);
                        }
                        break block0;
                    }
                    case CHAR: 
                    case BYTE: {
                        if (internal && explicit) {
                            return new Definition.Cast(actual, expected, true, true, false, false, false);
                        }
                        break block0;
                    }
                }
                break;
            }
            case CHAR_OBJ: {
                switch (expected.sort) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case CHAR: {
                        if (internal) {
                            return new Definition.Cast(actual, expected, explicit, true, false, false, false);
                        }
                        break block0;
                    }
                    case SHORT: 
                    case BYTE: {
                        if (internal && explicit) {
                            return new Definition.Cast(actual, expected, true, true, false, false, false);
                        }
                        break block0;
                    }
                }
                break;
            }
            case INT_OBJ: {
                switch (expected.sort) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        if (internal) {
                            return new Definition.Cast(actual, expected, explicit, true, false, false, false);
                        }
                        break block0;
                    }
                    case SHORT: 
                    case CHAR: 
                    case BYTE: {
                        if (internal && explicit) {
                            return new Definition.Cast(actual, expected, true, true, false, false, false);
                        }
                        break block0;
                    }
                }
                break;
            }
            case LONG_OBJ: {
                switch (expected.sort) {
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        if (internal) {
                            return new Definition.Cast(actual, expected, explicit, true, false, false, false);
                        }
                        break block0;
                    }
                    case SHORT: 
                    case INT: 
                    case CHAR: 
                    case BYTE: {
                        if (internal && explicit) {
                            return new Definition.Cast(actual, expected, true, true, false, false, false);
                        }
                        break block0;
                    }
                }
                break;
            }
            case FLOAT_OBJ: {
                switch (expected.sort) {
                    case FLOAT: 
                    case DOUBLE: {
                        if (internal) {
                            return new Definition.Cast(actual, expected, explicit, true, false, false, false);
                        }
                        break block0;
                    }
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case CHAR: 
                    case BYTE: {
                        if (internal && explicit) {
                            return new Definition.Cast(actual, expected, true, true, false, false, false);
                        }
                        break block0;
                    }
                }
                break;
            }
            case DOUBLE_OBJ: {
                switch (expected.sort) {
                    case FLOAT: 
                    case DOUBLE: {
                        if (internal) {
                            return new Definition.Cast(actual, expected, explicit, true, false, false, false);
                        }
                        break block0;
                    }
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case CHAR: 
                    case BYTE: {
                        if (internal && explicit) {
                            return new Definition.Cast(actual, expected, true, true, false, false, false);
                        }
                        break block0;
                    }
                }
                break;
            }
            case DEF: {
                switch (expected.sort) {
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case CHAR: 
                    case BYTE: 
                    case BOOL: {
                        return new Definition.Cast(actual, expected, explicit, true, false, false, false);
                    }
                }
                break;
            }
            case STRING: {
                switch (expected.sort) {
                    case CHAR: {
                        if (!explicit) break;
                        return new Definition.Cast(actual, expected, true, false, false, false, false);
                    }
                }
                break;
            }
        }
        if (actual.sort == Definition.Sort.DEF || expected.sort == Definition.Sort.DEF || expected.clazz.isAssignableFrom(actual.clazz) || explicit && actual.clazz.isAssignableFrom(expected.clazz)) {
            return new Definition.Cast(actual, expected, explicit);
        }
        throw location.createError(new ClassCastException("Cannot cast from [" + actual.name + "] to [" + expected.name + "]."));
    }

    public static Object constCast(Location location, Object constant, Definition.Cast cast) {
        Definition.Sort fsort = cast.from.sort;
        Definition.Sort tsort = cast.to.sort;
        if (fsort == tsort) {
            return constant;
        }
        if (fsort == Definition.Sort.STRING && tsort == Definition.Sort.CHAR) {
            return Character.valueOf(Utility.StringTochar((String)constant));
        }
        if (fsort == Definition.Sort.CHAR && tsort == Definition.Sort.STRING) {
            return Utility.charToString(((Character)constant).charValue());
        }
        if (fsort.numeric && tsort.numeric) {
            Number number = fsort == Definition.Sort.CHAR ? (Number)Integer.valueOf(((Character)constant).charValue()) : (Number)((Number)constant);
            switch (tsort) {
                case BYTE: {
                    return number.byteValue();
                }
                case SHORT: {
                    return number.shortValue();
                }
                case CHAR: {
                    return Character.valueOf((char)number.intValue());
                }
                case INT: {
                    return number.intValue();
                }
                case LONG: {
                    return number.longValue();
                }
                case FLOAT: {
                    return Float.valueOf(number.floatValue());
                }
                case DOUBLE: {
                    return number.doubleValue();
                }
            }
            throw location.createError(new IllegalStateException("Cannot cast from [" + cast.from.clazz.getCanonicalName() + "] to [" + cast.to.clazz.getCanonicalName() + "]."));
        }
        throw location.createError(new IllegalStateException("Cannot cast from [" + cast.from.clazz.getCanonicalName() + "] to [" + cast.to.clazz.getCanonicalName() + "]."));
    }

    public static Definition.Type promoteNumeric(Definition.Type from, boolean decimal) {
        Definition.Sort sort = from.sort;
        if (sort == Definition.Sort.DEF) {
            return Definition.DEF_TYPE;
        }
        if (sort == Definition.Sort.DOUBLE && decimal) {
            return Definition.DOUBLE_TYPE;
        }
        if (sort == Definition.Sort.FLOAT && decimal) {
            return Definition.FLOAT_TYPE;
        }
        if (sort == Definition.Sort.LONG) {
            return Definition.LONG_TYPE;
        }
        if (sort == Definition.Sort.INT || sort == Definition.Sort.CHAR || sort == Definition.Sort.SHORT || sort == Definition.Sort.BYTE) {
            return Definition.INT_TYPE;
        }
        return null;
    }

    public static Definition.Type promoteNumeric(Definition.Type from0, Definition.Type from1, boolean decimal) {
        Definition.Sort sort0 = from0.sort;
        Definition.Sort sort1 = from1.sort;
        if (sort0 == Definition.Sort.DEF || sort1 == Definition.Sort.DEF) {
            return Definition.DEF_TYPE;
        }
        if (decimal) {
            if (sort0 == Definition.Sort.DOUBLE || sort1 == Definition.Sort.DOUBLE) {
                return Definition.DOUBLE_TYPE;
            }
            if (sort0 == Definition.Sort.FLOAT || sort1 == Definition.Sort.FLOAT) {
                return Definition.FLOAT_TYPE;
            }
        }
        if (sort0 == Definition.Sort.LONG || sort1 == Definition.Sort.LONG) {
            return Definition.LONG_TYPE;
        }
        if (sort0 == Definition.Sort.INT || sort1 == Definition.Sort.INT || sort0 == Definition.Sort.CHAR || sort1 == Definition.Sort.CHAR || sort0 == Definition.Sort.SHORT || sort1 == Definition.Sort.SHORT || sort0 == Definition.Sort.BYTE || sort1 == Definition.Sort.BYTE) {
            return Definition.INT_TYPE;
        }
        return null;
    }

    public static Definition.Type promoteAdd(Definition.Type from0, Definition.Type from1) {
        Definition.Sort sort0 = from0.sort;
        Definition.Sort sort1 = from1.sort;
        if (sort0 == Definition.Sort.STRING || sort1 == Definition.Sort.STRING) {
            return Definition.STRING_TYPE;
        }
        return AnalyzerCaster.promoteNumeric(from0, from1, true);
    }

    public static Definition.Type promoteXor(Definition.Type from0, Definition.Type from1) {
        Definition.Sort sort0 = from0.sort;
        Definition.Sort sort1 = from1.sort;
        if (sort0 == Definition.Sort.DEF || sort1 == Definition.Sort.DEF) {
            return Definition.DEF_TYPE;
        }
        if (sort0.bool || sort1.bool) {
            return Definition.BOOLEAN_TYPE;
        }
        return AnalyzerCaster.promoteNumeric(from0, from1, false);
    }

    public static Definition.Type promoteEquality(Definition.Type from0, Definition.Type from1) {
        Definition.Sort sort0 = from0.sort;
        Definition.Sort sort1 = from1.sort;
        if (sort0 == Definition.Sort.DEF || sort1 == Definition.Sort.DEF) {
            return Definition.DEF_TYPE;
        }
        if (sort0.primitive && sort1.primitive) {
            if (sort0.bool && sort1.bool) {
                return Definition.BOOLEAN_TYPE;
            }
            if (sort0.numeric && sort1.numeric) {
                return AnalyzerCaster.promoteNumeric(from0, from1, true);
            }
        }
        return Definition.OBJECT_TYPE;
    }

    public static Definition.Type promoteConditional(Definition.Type from0, Definition.Type from1, Object const0, Object const1) {
        if (from0.equals(from1)) {
            return from0;
        }
        Definition.Sort sort0 = from0.sort;
        Definition.Sort sort1 = from1.sort;
        if (sort0 == Definition.Sort.DEF || sort1 == Definition.Sort.DEF) {
            return Definition.DEF_TYPE;
        }
        if (sort0.primitive && sort1.primitive) {
            if (sort0.bool && sort1.bool) {
                return Definition.BOOLEAN_TYPE;
            }
            if (sort0 == Definition.Sort.DOUBLE || sort1 == Definition.Sort.DOUBLE) {
                return Definition.DOUBLE_TYPE;
            }
            if (sort0 == Definition.Sort.FLOAT || sort1 == Definition.Sort.FLOAT) {
                return Definition.FLOAT_TYPE;
            }
            if (sort0 == Definition.Sort.LONG || sort1 == Definition.Sort.LONG) {
                return Definition.LONG_TYPE;
            }
            if (sort0 == Definition.Sort.BYTE) {
                if (sort1 == Definition.Sort.BYTE) {
                    return Definition.BYTE_TYPE;
                }
                if (sort1 == Definition.Sort.SHORT) {
                    short constant;
                    if (const1 != null && (constant = ((Short)const1).shortValue()) <= 127 && constant >= -128) {
                        return Definition.BYTE_TYPE;
                    }
                    return Definition.SHORT_TYPE;
                }
                if (sort1 == Definition.Sort.CHAR) {
                    return Definition.INT_TYPE;
                }
                if (sort1 == Definition.Sort.INT) {
                    int constant;
                    if (const1 != null && (constant = ((Integer)const1).intValue()) <= 127 && constant >= -128) {
                        return Definition.BYTE_TYPE;
                    }
                    return Definition.INT_TYPE;
                }
            } else if (sort0 == Definition.Sort.SHORT) {
                if (sort1 == Definition.Sort.BYTE) {
                    short constant;
                    if (const0 != null && (constant = ((Short)const0).shortValue()) <= 127 && constant >= -128) {
                        return Definition.BYTE_TYPE;
                    }
                    return Definition.SHORT_TYPE;
                }
                if (sort1 == Definition.Sort.SHORT) {
                    return Definition.SHORT_TYPE;
                }
                if (sort1 == Definition.Sort.CHAR) {
                    return Definition.INT_TYPE;
                }
                if (sort1 == Definition.Sort.INT) {
                    int constant;
                    if (const1 != null && (constant = ((Integer)const1).intValue()) <= Short.MAX_VALUE && constant >= Short.MIN_VALUE) {
                        return Definition.SHORT_TYPE;
                    }
                    return Definition.INT_TYPE;
                }
            } else if (sort0 == Definition.Sort.CHAR) {
                if (sort1 == Definition.Sort.BYTE) {
                    return Definition.INT_TYPE;
                }
                if (sort1 == Definition.Sort.SHORT) {
                    return Definition.INT_TYPE;
                }
                if (sort1 == Definition.Sort.CHAR) {
                    return Definition.CHAR_TYPE;
                }
                if (sort1 == Definition.Sort.INT) {
                    int constant;
                    if (const1 != null && (constant = ((Integer)const1).intValue()) <= 65535 && constant >= 0) {
                        return Definition.BYTE_TYPE;
                    }
                    return Definition.INT_TYPE;
                }
            } else if (sort0 == Definition.Sort.INT) {
                if (sort1 == Definition.Sort.BYTE) {
                    int constant;
                    if (const0 != null && (constant = ((Integer)const0).intValue()) <= 127 && constant >= -128) {
                        return Definition.BYTE_TYPE;
                    }
                    return Definition.INT_TYPE;
                }
                if (sort1 == Definition.Sort.SHORT) {
                    int constant;
                    if (const0 != null && (constant = ((Integer)const0).intValue()) <= Short.MAX_VALUE && constant >= Short.MIN_VALUE) {
                        return Definition.BYTE_TYPE;
                    }
                    return Definition.INT_TYPE;
                }
                if (sort1 == Definition.Sort.CHAR) {
                    int constant;
                    if (const0 != null && (constant = ((Integer)const0).intValue()) <= 65535 && constant >= 0) {
                        return Definition.BYTE_TYPE;
                    }
                    return Definition.INT_TYPE;
                }
                if (sort1 == Definition.Sort.INT) {
                    return Definition.INT_TYPE;
                }
            }
        }
        return Definition.OBJECT_TYPE;
    }

    private AnalyzerCaster() {
    }
}

