/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.FixedBitSet;

public abstract class AbstractAllGroupHeadsCollector<GH extends GroupHead>
extends SimpleCollector {
    protected final int[] reversed;
    protected final int compIDXEnd;
    protected final TemporalResult temporalResult;

    protected AbstractAllGroupHeadsCollector(int numberOfSorts) {
        this.reversed = new int[numberOfSorts];
        this.compIDXEnd = numberOfSorts - 1;
        this.temporalResult = new TemporalResult();
    }

    public FixedBitSet retrieveGroupHeads(int maxDoc) {
        FixedBitSet bitSet = new FixedBitSet(maxDoc);
        Collection<GH> groupHeads = this.getCollectedGroupHeads();
        for (GroupHead groupHead : groupHeads) {
            bitSet.set(groupHead.doc);
        }
        return bitSet;
    }

    public int[] retrieveGroupHeads() {
        Collection<GH> groupHeads = this.getCollectedGroupHeads();
        int[] docHeads = new int[groupHeads.size()];
        int i = 0;
        for (GroupHead groupHead : groupHeads) {
            docHeads[i++] = groupHead.doc;
        }
        return docHeads;
    }

    public int groupHeadsSize() {
        return this.getCollectedGroupHeads().size();
    }

    protected abstract void retrieveGroupHeadAndAddIfNotExist(int var1) throws IOException;

    protected abstract Collection<GH> getCollectedGroupHeads();

    public void collect(int doc) throws IOException {
        this.retrieveGroupHeadAndAddIfNotExist(doc);
        if (this.temporalResult.stop) {
            return;
        }
        Object groupHead = this.temporalResult.groupHead;
        int compIDX = 0;
        while (true) {
            int c;
            if ((c = this.reversed[compIDX] * ((GroupHead)groupHead).compare(compIDX, doc)) < 0) {
                return;
            }
            if (c > 0) break;
            if (compIDX == this.compIDXEnd) {
                return;
            }
            ++compIDX;
        }
        ((GroupHead)groupHead).updateDocHead(doc);
    }

    public static abstract class GroupHead<GROUP_VALUE_TYPE> {
        public final GROUP_VALUE_TYPE groupValue;
        public int doc;

        protected GroupHead(GROUP_VALUE_TYPE groupValue, int doc) {
            this.groupValue = groupValue;
            this.doc = doc;
        }

        protected abstract int compare(int var1, int var2) throws IOException;

        protected abstract void updateDocHead(int var1) throws IOException;
    }

    protected class TemporalResult {
        public GH groupHead;
        public boolean stop;

        protected TemporalResult() {
        }
    }
}

