/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.profile.ProfileResult;
import org.elasticsearch.search.profile.query.CollectorResult;

public final class QueryProfileShardResult
implements Writeable,
ToXContent {
    private final List<ProfileResult> queryProfileResults;
    private final CollectorResult profileCollector;
    private final long rewriteTime;

    public QueryProfileShardResult(List<ProfileResult> queryProfileResults, long rewriteTime, CollectorResult profileCollector) {
        assert (profileCollector != null);
        this.queryProfileResults = queryProfileResults;
        this.profileCollector = profileCollector;
        this.rewriteTime = rewriteTime;
    }

    public QueryProfileShardResult(StreamInput in) throws IOException {
        int profileSize = in.readVInt();
        this.queryProfileResults = new ArrayList<ProfileResult>(profileSize);
        for (int j = 0; j < profileSize; ++j) {
            this.queryProfileResults.add(new ProfileResult(in));
        }
        this.profileCollector = new CollectorResult(in);
        this.rewriteTime = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.queryProfileResults.size());
        for (ProfileResult p : this.queryProfileResults) {
            p.writeTo(out);
        }
        this.profileCollector.writeTo(out);
        out.writeLong(this.rewriteTime);
    }

    public List<ProfileResult> getQueryResults() {
        return Collections.unmodifiableList(this.queryProfileResults);
    }

    public long getRewriteTime() {
        return this.rewriteTime;
    }

    public CollectorResult getCollectorResult() {
        return this.profileCollector;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("query");
        for (ProfileResult p : this.queryProfileResults) {
            p.toXContent(builder, params);
        }
        builder.endArray();
        builder.field("rewrite_time", this.rewriteTime);
        builder.startArray("collector");
        this.profileCollector.toXContent(builder, params);
        builder.endArray();
        return builder;
    }
}

