# From 5.0 to 5.1
*Make sure you view this [upgrade guide from the `master` branch](../../../master/doc/update/5.0-to-5.1.md) for the most up to date instructions.*

## Warning

GitLab 5.1 is affected by critical security vulnerability CVE-2013-4490.

## Release notes

- `unicorn` replaced with `puma`
- merge request cached diff will be truncated

## 1. Stop server

    sudo service gitlab stop

## 2. Get latest code

```bash
cd /home/git/gitlab
sudo -u git -H git fetch
sudo -u git -H git checkout 5-1-stable
```

## 3. Update gitlab-shell

```bash
cd /home/git/gitlab-shell
sudo -u git -H git fetch
sudo -u git -H git checkout v1.3.0
# replace your old config with the new one
sudo -u git -H mv config.yml config.yml.old
sudo -u git -H cp config.yml.example config.yml
# edit options to match old config
sudo -u git -H vi config.yml
```

## 4. Install libs, migrations etc

```bash
cd /home/git/gitlab
sudo rm tmp/sockets/gitlab.socket
sudo -u git -H cp config/puma.rb.example config/puma.rb

# The Modernizr gem was yanked from RubyGems. It is required for GitLab >= 2.8.0
# Edit `Gemfile` and change `gem "modernizr", "2.5.3"` to
# `gem "modernizr-rails", "2.7.1"``
sudo -u git -H vim Gemfile

# Run a bundle install without deployment to generate the new Gemfile
sudo -u git -H bundle install --without development test postgres --no-deployment

# Install libs (with deployment this time)
sudo -u git -H bundle install --without development test postgres --deployment

sudo -u git -H bundle exec rake db:migrate RAILS_ENV=production
sudo -u git -H bundle exec rake migrate_merge_requests RAILS_ENV=production
sudo -u git -H bundle exec rake assets:precompile RAILS_ENV=production
```

## 5. Update init.d script with a new one

```bash
# init.d
sudo rm /etc/init.d/gitlab
sudo curl --location --output /etc/init.d/gitlab https://raw.github.com/gitlabhq/gitlab-recipes/5-1-stable/init.d/gitlab
sudo chmod +x /etc/init.d/gitlab
```

## 6. MySQL grant privileges

Only if you are using MySQL:

```bash
mysql -u root -p
mysql> GRANT LOCK TABLES ON `gitlabhq_production`.* TO 'gitlab'@'localhost';
mysql> \q
```

## 7. Start application

    sudo service gitlab start

## 8. Check installation


```bash
# In 5-10 seconds lets check gitlab-shell
sudo -u git -H /home/git/gitlab-shell/bin/check

# Example of success output
# Check GitLab API access: OK
# Check directories and files:
#         /home/git/repositories: OK
#         /home/git/.ssh/authorized_keys: OK


# Now check gitlab instance
sudo -u git -H bundle exec rake gitlab:check RAILS_ENV=production

```
