/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.ExecutorsQuery;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.Query;
import org.jetbrains.kotlin.com.intellij.util.QueryExecutor;
import org.jetbrains.kotlin.com.intellij.util.UniqueResultsQuery;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.gnu.trove.TObjectHashingStrategy;

public class QueryFactory<Result, Parameters> {
    private final List<QueryExecutor<Result, Parameters>> myExecutors = ContainerUtil.createLockFreeCopyOnWriteList();

    public void registerExecutor(@NotNull QueryExecutor<Result, Parameters> executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/kotlin/com/intellij/util/QueryFactory", "registerExecutor"));
        }
        this.myExecutors.add(executor);
    }

    public void unregisterExecutor(@NotNull QueryExecutor<Result, Parameters> executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/kotlin/com/intellij/util/QueryFactory", "unregisterExecutor"));
        }
        this.myExecutors.remove(executor);
    }

    @NotNull
    public final Query<Result> createQuery(@NotNull Parameters parameters2) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/com/intellij/util/QueryFactory", "createQuery"));
        }
        ExecutorsQuery executorsQuery = new ExecutorsQuery(parameters2, this.getExecutors());
        if (executorsQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/QueryFactory", "createQuery"));
        }
        return executorsQuery;
    }

    @NotNull
    protected List<QueryExecutor<Result, Parameters>> getExecutors() {
        List<QueryExecutor<Result, Parameters>> list2 = this.myExecutors;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/QueryFactory", "getExecutors"));
        }
        return list2;
    }

    public boolean hasAnyExecutors() {
        return !this.getExecutors().isEmpty();
    }

    @NotNull
    public final Query<Result> createUniqueResultsQuery(@NotNull Parameters parameters2) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        UniqueResultsQuery uniqueResultsQuery = new UniqueResultsQuery(this.createQuery(parameters2));
        if (uniqueResultsQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        return uniqueResultsQuery;
    }

    @NotNull
    public final Query<Result> createUniqueResultsQuery(@NotNull Parameters parameters2, @NotNull TObjectHashingStrategy<Result> hashingStrategy) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "org/jetbrains/kotlin/com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        UniqueResultsQuery<Result, Result> uniqueResultsQuery = new UniqueResultsQuery<Result, Result>(this.createQuery(parameters2), hashingStrategy);
        if (uniqueResultsQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        return uniqueResultsQuery;
    }

    @NotNull
    public final <T> Query<Result> createUniqueResultsQuery(@NotNull Parameters parameters2, @NotNull TObjectHashingStrategy<T> hashingStrategy, @NotNull Function<Result, T> mapper) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "org/jetbrains/kotlin/com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "org/jetbrains/kotlin/com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        UniqueResultsQuery<Result, T> uniqueResultsQuery = new UniqueResultsQuery<Result, T>(this.createQuery(parameters2), hashingStrategy, mapper);
        if (uniqueResultsQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        return uniqueResultsQuery;
    }
}

