/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenCondition;

public class KtWhenConditionInRange
extends KtWhenCondition {
    public KtWhenConditionInRange(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtWhenConditionInRange", "<init>"));
        }
        super(node);
    }

    public boolean isNegated() {
        return this.getNode().findChildByType(KtTokens.NOT_IN) != null;
    }

    @IfNotParsed
    @Nullable
    public KtExpression getRangeExpression() {
        for (ASTNode node = this.getOperationReference().getNode().getTreeNext(); node != null; node = node.getTreeNext()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof KtExpression)) continue;
            return (KtExpression)psi;
        }
        return null;
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtWhenConditionInRange", "accept"));
        }
        return visitor2.visitWhenConditionInRange(this, data);
    }

    @NotNull
    public KtSimpleNameExpression getOperationReference() {
        KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)this.findChildByType(KtNodeTypes.OPERATION_REFERENCE);
        if (ktSimpleNameExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtWhenConditionInRange", "getOperationReference"));
        }
        return ktSimpleNameExpression;
    }
}

