/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.base.Objects;
import java.io.File;
import org.gradle.api.internal.changedetection.rules.ChangeType;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.tasks.incremental.InputFileDetails;

public class FileChange
implements TaskStateChange,
InputFileDetails {
    private final String path;
    private final ChangeType change;
    private final String fileType;

    public FileChange(String path, ChangeType change, String fileType) {
        this.path = path;
        this.change = change;
        this.fileType = fileType;
    }

    public String getMessage() {
        return this.fileType + " file " + this.path + " " + this.change.describe() + ".";
    }

    public String toString() {
        return this.getMessage();
    }

    public String getPath() {
        return this.path;
    }

    public File getFile() {
        return new File(this.path);
    }

    public ChangeType getType() {
        return this.change;
    }

    public boolean isAdded() {
        return this.change == ChangeType.ADDED;
    }

    public boolean isModified() {
        return this.change == ChangeType.MODIFIED;
    }

    public boolean isRemoved() {
        return this.change == ChangeType.REMOVED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileChange that = (FileChange)o;
        return Objects.equal((Object)this.path, (Object)that.path) && this.change == that.change && Objects.equal((Object)this.fileType, (Object)that.fileType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.path, this.change, this.fileType});
    }
}

