/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.debug.BreakpointLocation;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.DebuggerNode;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.LoadSourceSectionEvent;
import com.oracle.truffle.api.instrumentation.LoadSourceSectionListener;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.SlowPathException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import java.net.URI;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public final class Breakpoint {
    static final Comparator<Breakpoint> COMPARATOR = new Comparator<Breakpoint>(){

        @Override
        public int compare(Breakpoint o1, Breakpoint o2) {
            return o1.locationKey.compareTo(o2.locationKey);
        }
    };
    private static final Breakpoint BUILDER_INSTANCE = new Breakpoint();
    private final SourceSectionFilter filter;
    private final BreakpointLocation locationKey;
    private final boolean oneShot;
    private volatile DebuggerSession session;
    private volatile boolean enabled;
    private volatile boolean resolved;
    private volatile int ignoreCount;
    private volatile boolean disposed;
    private volatile String condition;
    private final AtomicLong hitCount = new AtomicLong();
    private volatile SourceSection resolvedSourceSection;
    private volatile Assumption conditionUnchanged;
    private EventBinding<? extends ExecutionEventNodeFactory> breakpointBinding;
    private EventBinding<?> sourceBinding;

    Breakpoint(BreakpointLocation key, SourceSectionFilter filter, boolean oneShot) {
        this.locationKey = key;
        this.filter = filter;
        this.oneShot = oneShot;
        this.enabled = true;
    }

    private Breakpoint() {
        this.locationKey = null;
        this.filter = null;
        this.oneShot = false;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean enabled) {
        if (this.disposed) {
            return;
        }
        if (this.enabled != enabled) {
            if (this.session != null) {
                if (enabled) {
                    this.install();
                } else {
                    this.uninstall();
                }
            }
            this.enabled = enabled;
        }
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public synchronized void setCondition(String expression) throws IOException {
        this.condition = expression;
        Assumption assumption = this.conditionUnchanged;
        if (assumption != null) {
            this.conditionUnchanged = null;
            assumption.invalidate();
        }
    }

    @Deprecated
    public synchronized Source getCondition() {
        if (this.condition != null) {
            Source source = null;
            if (this.isResolved()) {
                source = this.resolvedSourceSection.getSource();
            } else if (this.locationKey.getKey() instanceof Source) {
                source = (Source)this.locationKey.getKey();
            }
            if (source != null) {
                return Source.newBuilder(this.condition).mimeType(source.getMimeType()).name("Condition for breakpoint " + this.toString()).build();
            }
        }
        return null;
    }

    public synchronized void dispose() {
        if (!this.disposed) {
            this.setEnabled(false);
            if (this.sourceBinding != null) {
                this.sourceBinding.dispose();
                this.sourceBinding = null;
            }
            if (this.session != null) {
                this.session.disposeBreakpoint(this);
            }
            this.disposed = true;
        }
    }

    @Deprecated
    public State getState() {
        if (this.isDisposed()) {
            return State.DISPOSED;
        }
        if (this.isEnabled()) {
            if (this.isResolved()) {
                return State.ENABLED;
            }
            return State.ENABLED_UNRESOLVED;
        }
        if (this.isResolved()) {
            return State.DISABLED;
        }
        return State.DISABLED_UNRESOLVED;
    }

    public boolean isOneShot() {
        return this.oneShot;
    }

    public int getIgnoreCount() {
        return this.ignoreCount;
    }

    public void setIgnoreCount(int ignoreCount) {
        this.ignoreCount = ignoreCount;
    }

    public int getHitCount() {
        return (int)this.hitCount.get();
    }

    String getShortDescription() {
        return "Breakpoint@" + this.locationKey.toString();
    }

    public String getLocationDescription() {
        return this.locationKey.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    }

    DebuggerNode lookupNode(EventContext context) {
        if (!this.isEnabled()) {
            return null;
        }
        EventBinding<? extends ExecutionEventNodeFactory> binding = this.breakpointBinding;
        if (binding != null) {
            return (DebuggerNode)context.lookupExecutionEventNode(binding);
        }
        return null;
    }

    synchronized Assumption getConditionUnchanged() {
        if (this.conditionUnchanged == null) {
            this.conditionUnchanged = Truffle.getRuntime().createAssumption("Breakpoint condition unchanged.");
        }
        return this.conditionUnchanged;
    }

    BreakpointLocation getLocationKey() {
        return this.locationKey;
    }

    DebuggerSession getSession() {
        return this.session;
    }

    synchronized void install(DebuggerSession d) {
        if (this.session != null) {
            throw new IllegalStateException("Breakpoint is already installed.");
        }
        this.session = d;
        if (this.enabled) {
            this.install();
        }
    }

    private void install() {
        Thread.holdsLock(this);
        this.sourceBinding = this.session.getDebugger().getInstrumenter().attachLoadSourceSectionListener(this.filter, new LoadSourceSectionListener(){

            @Override
            public void onLoad(LoadSourceSectionEvent event) {
                Breakpoint.this.resolveBreakpoint(event.getSourceSection());
            }
        }, true);
        this.breakpointBinding = this.session.getDebugger().getInstrumenter().attachFactory(this.filter, new BreakpointNodeFactory());
    }

    private synchronized void resolveBreakpoint(SourceSection sourceSection) {
        if (this.disposed) {
            return;
        }
        if (!this.isResolved()) {
            this.resolvedSourceSection = sourceSection;
            if (this.sourceBinding != null) {
                this.sourceBinding.dispose();
                this.sourceBinding = null;
            }
            this.resolved = true;
        }
    }

    private void uninstall() {
        Thread.holdsLock(this);
        if (this.breakpointBinding != null) {
            this.breakpointBinding.dispose();
            this.breakpointBinding = null;
        }
    }

    boolean notifyIndirectHit(DebuggerNode source, DebuggerNode node, Frame frame) throws BreakpointConditionFailure {
        if (!this.isEnabled()) {
            return false;
        }
        assert (node.getBreakpoint() == this);
        if (source != node && !((BreakpointNode)node).shouldBreak(frame)) {
            return false;
        }
        if (this.hitCount.incrementAndGet() <= (long)this.ignoreCount) {
            return false;
        }
        if (this.isOneShot()) {
            this.setEnabled(false);
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    private void doBreak(DebuggerNode source, MaterializedFrame frame, BreakpointConditionFailure failure) {
        if (!this.isEnabled()) {
            return;
        }
        this.session.notifyCallback(source, frame, null, failure);
    }

    public static Builder newBuilder(URI sourceUri) {
        Breakpoint breakpoint = BUILDER_INSTANCE;
        breakpoint.getClass();
        return breakpoint.new Builder(sourceUri);
    }

    public static Builder newBuilder(Source source) {
        Breakpoint breakpoint = BUILDER_INSTANCE;
        breakpoint.getClass();
        return breakpoint.new Builder(source);
    }

    public static Builder newBuilder(SourceSection sourceSection) {
        Breakpoint breakpoint = BUILDER_INSTANCE;
        breakpoint.getClass();
        return breakpoint.new Builder(sourceSection);
    }

    private static class ConditionalBreakNode
    extends Node {
        private final EventContext context;
        private final Breakpoint breakpoint;
        @Node.Child
        private DirectCallNode conditionCallNode;
        @CompilerDirectives.CompilationFinal
        private Assumption conditionUnchanged;

        ConditionalBreakNode(EventContext context, Breakpoint breakpoint) {
            this.context = context;
            this.breakpoint = breakpoint;
            this.conditionUnchanged = breakpoint.getConditionUnchanged();
        }

        boolean shouldBreak(Frame frame) {
            Object result;
            if (this.conditionCallNode == null || !this.conditionUnchanged.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.initializeConditional();
            }
            if (!((result = frame instanceof VirtualFrame ? this.conditionCallNode.call((VirtualFrame)frame, new Object[0]) : this.conditionCallNode.getCallTarget().call(new Object[0])) instanceof Boolean)) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalArgumentException("Unsupported return type " + result + " in condition.");
            }
            return (Boolean)result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initializeConditional() {
            Source conditionSource;
            Node instrumentedNode = this.context.getInstrumentedNode();
            RootNode rootNode = instrumentedNode.getRootNode();
            if (rootNode == null) {
                throw new IllegalStateException("Probe was disconnected from the AST.");
            }
            Breakpoint breakpoint = this.breakpoint;
            synchronized (breakpoint) {
                conditionSource = Source.newBuilder(this.breakpoint.condition).mimeType(this.context.getInstrumentedSourceSection().getSource().getMimeType()).name("breakpoint condition").build();
                if (conditionSource == null) {
                    throw new IllegalStateException("Condition is not resolved " + rootNode);
                }
                this.conditionUnchanged = this.breakpoint.getConditionUnchanged();
            }
            CallTarget callTarget = Debugger.ACCESSOR.parse(conditionSource, instrumentedNode, new String[0]);
            this.conditionCallNode = this.insert(Truffle.getRuntime().createDirectCallNode(callTarget));
        }
    }

    static final class BreakpointConditionFailure
    extends SlowPathException {
        private static final long serialVersionUID = 1L;
        private final Breakpoint breakpoint;

        BreakpointConditionFailure(Breakpoint breakpoint, Throwable cause) {
            super(cause);
            this.breakpoint = breakpoint;
        }

        public Breakpoint getBreakpoint() {
            return this.breakpoint;
        }

        public Throwable getConditionFailure() {
            return this.getCause();
        }
    }

    private static class BreakpointNode
    extends DebuggerNode {
        private final Breakpoint breakpoint;
        private final BranchProfile breakBranch = BranchProfile.create();
        @Node.Child
        private ConditionalBreakNode breakCondition;

        BreakpointNode(Breakpoint breakpoint, EventContext context) {
            super(context);
            this.breakpoint = breakpoint;
            if (breakpoint.condition != null) {
                this.breakCondition = new ConditionalBreakNode(context, breakpoint);
            }
        }

        @Override
        DebuggerSession.SteppingLocation getSteppingLocation() {
            return DebuggerSession.SteppingLocation.BEFORE_STATEMENT;
        }

        @Override
        Breakpoint getBreakpoint() {
            return this.breakpoint;
        }

        @Override
        EventBinding<?> getBinding() {
            return this.breakpoint.breakpointBinding;
        }

        @Override
        protected void onEnter(VirtualFrame frame) {
            BreakpointConditionFailure conditionError = null;
            try {
                if (!this.shouldBreak(frame)) {
                    return;
                }
            }
            catch (BreakpointConditionFailure e) {
                conditionError = e;
            }
            this.breakBranch.enter();
            this.breakpoint.doBreak(this, frame.materialize(), conditionError);
        }

        boolean shouldBreak(Frame frame) throws BreakpointConditionFailure {
            if (this.breakCondition != null) {
                try {
                    return this.breakCondition.shouldBreak(frame);
                }
                catch (Throwable e) {
                    CompilerDirectives.transferToInterpreter();
                    throw new BreakpointConditionFailure(this.breakpoint, e);
                }
            }
            return true;
        }
    }

    private class BreakpointNodeFactory
    implements ExecutionEventNodeFactory {
        private BreakpointNodeFactory() {
        }

        @Override
        public ExecutionEventNode create(EventContext context) {
            if (!Breakpoint.this.isResolved()) {
                Breakpoint.this.resolveBreakpoint(context.getInstrumentedSourceSection());
            }
            return new BreakpointNode(Breakpoint.this, context);
        }
    }

    public final class Builder {
        private final Object key;
        private int line = -1;
        private int ignoreCount;
        private boolean oneShot;
        private SourceSection sourceSection;

        private Builder(Object key) {
            Objects.requireNonNull(key);
            this.key = key;
        }

        private Builder(SourceSection key) {
            this(key.getSource());
            Objects.requireNonNull(key);
            this.sourceSection = key;
        }

        public Builder lineIs(int line) {
            if (line <= 0) {
                throw new IllegalArgumentException("Line argument must be > 0.");
            }
            if (this.line != -1) {
                throw new IllegalStateException("LineIs can only be called once per breakpoint builder.");
            }
            if (this.sourceSection != null) {
                throw new IllegalArgumentException("LineIs cannot be used with source section based breakpoint. ");
            }
            this.line = line;
            return this;
        }

        public Builder ignoreCount(int ignoreCount) {
            if (ignoreCount < 0) {
                throw new IllegalArgumentException("IgnoreCount argument must be >= 0.");
            }
            this.ignoreCount = ignoreCount;
            return this;
        }

        public Builder oneShot() {
            this.oneShot = true;
            return this;
        }

        public Breakpoint build() {
            SourceSectionFilter f = this.buildFilter();
            BreakpointLocation location = new BreakpointLocation(this.key, this.line);
            Breakpoint breakpoint = new Breakpoint(location, f, this.oneShot);
            breakpoint.setIgnoreCount(this.ignoreCount);
            return breakpoint;
        }

        private SourceSectionFilter buildFilter() {
            SourceSectionFilter.Builder f = SourceSectionFilter.newBuilder();
            if (this.key instanceof URI) {
                final URI sourceUri = (URI)this.key;
                f.sourceIs(new SourceSectionFilter.SourcePredicate(){

                    @Override
                    public boolean test(Source s) {
                        URI uri = s.getURI();
                        if (uri == null) {
                            return false;
                        }
                        return uri.equals(sourceUri);
                    }

                    public String toString() {
                        return "URI equals " + sourceUri;
                    }
                });
            } else {
                assert (this.key instanceof Source);
                f.sourceIs((Source)this.key);
            }
            if (this.line != -1) {
                f.lineStartsIn(SourceSectionFilter.IndexRange.byLength(this.line, 1));
            }
            if (this.sourceSection != null) {
                f.sourceSectionEquals(this.sourceSection);
            }
            f.tagIs(StandardTags.StatementTag.class);
            return f.build();
        }
    }

    @Deprecated
    public static enum State {
        ENABLED_UNRESOLVED("Enabled/Unresolved"),
        DISABLED_UNRESOLVED("Disabled/Unresolved"),
        ENABLED("Enabled"),
        DISABLED("Disabled"),
        DISPOSED("Disposed");

        private final String name;

        private State(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

