/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeClassImpl;
import com.oracle.truffle.api.nodes.NodeFieldAccessor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;

public abstract class NodeClass {
    private static final ClassValue<NodeClass> nodeClasses = new ClassValue<NodeClass>(){

        @Override
        protected NodeClass computeValue(final Class<?> clazz) {
            assert (Node.class.isAssignableFrom(clazz));
            return AccessController.doPrivileged(new PrivilegedAction<NodeClass>(){

                @Override
                public NodeClass run() {
                    return new NodeClassImpl(clazz);
                }
            });
        }
    };

    public static NodeClass get(Class<? extends Node> clazz) {
        return nodeClasses.get(clazz);
    }

    public static NodeClass get(Node node) {
        return node.getNodeClass();
    }

    public NodeClass(Class<? extends Node> clazz) {
    }

    @Deprecated
    public abstract NodeFieldAccessor getNodeClassField();

    @Deprecated
    public abstract NodeFieldAccessor[] getCloneableFields();

    @Deprecated
    public abstract NodeFieldAccessor[] getFields();

    @Deprecated
    public abstract NodeFieldAccessor getParentField();

    @Deprecated
    public abstract NodeFieldAccessor[] getChildFields();

    @Deprecated
    public abstract NodeFieldAccessor[] getChildrenFields();

    public abstract Iterator<Node> makeIterator(Node var1);

    public abstract Class<? extends Node> getType();

    protected abstract Iterable<? extends Object> getNodeFields();

    protected abstract void putFieldObject(Object var1, Node var2, Object var3);

    protected abstract Object getFieldObject(Object var1, Node var2);

    protected abstract Object getFieldValue(Object var1, Node var2);

    protected abstract Class<?> getFieldType(Object var1);

    protected abstract String getFieldName(Object var1);

    protected abstract boolean isChildField(Object var1);

    protected abstract boolean isChildrenField(Object var1);

    protected abstract boolean isCloneableField(Object var1);

    boolean nodeFieldsOrderedByKind() {
        return false;
    }
}

