/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.read.bytes;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.read.SourceNode;
import org.jruby.truffle.core.rope.AsciiOnlyLeafRope;
import org.jruby.util.Pack;

@NodeChildren(value={@NodeChild(value="value", type=SourceNode.class)})
public abstract class ReadHexStringNode
extends FormatNode {
    private final ByteOrder byteOrder;
    private final boolean star;
    private final int length;

    public ReadHexStringNode(RubyContext context, ByteOrder byteOrder, boolean star, int length) {
        super(context);
        this.byteOrder = byteOrder;
        this.star = star;
        this.length = length;
    }

    @Specialization
    public Object read(VirtualFrame frame, byte[] source) {
        int position = this.getSourcePosition(frame);
        ByteBuffer encode = ByteBuffer.wrap(source, position, this.getSourceLength(frame) - position);
        int occurrences = this.length;
        if (this.star || occurrences > encode.remaining() * 2) {
            occurrences = encode.remaining() * 2;
        }
        int bits = 0;
        byte[] lElem = new byte[occurrences];
        int shift = this.byteOrder == ByteOrder.BIG_ENDIAN ? 4 : 0;
        for (int lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
            bits = (lCurByte & 1) != 0 ? (this.byteOrder == ByteOrder.BIG_ENDIAN ? (bits <<= 4) : (bits >>>= 4)) : encode.get();
            lElem[lCurByte] = Pack.sHexDigits[bits >>> shift & 0xF];
        }
        this.setSourcePosition(frame, encode.position());
        return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), new AsciiOnlyLeafRope(lElem, (Encoding)USASCIIEncoding.INSTANCE));
    }
}

