/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.globals;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import org.jruby.util.cli.Options;

public class GlobalVariableStorage {
    private static final int GLOBAL_VARIABLE_MAX_INVALIDATIONS = (Integer)Options.TRUFFLE_GLOBAL_VARIABLE_MAX_INVALIDATIONS.load();
    private final CyclicAssumption unchangedAssumption = new CyclicAssumption("global variable unchanged");
    private int changes = 0;
    @CompilerDirectives.CompilationFinal
    private volatile boolean assumeConstant = true;
    private volatile Object value;

    GlobalVariableStorage(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public Assumption getUnchangedAssumption() {
        return this.unchangedAssumption.getAssumption();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object value) {
        if (this.assumeConstant) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.value = value;
            GlobalVariableStorage globalVariableStorage = this;
            synchronized (globalVariableStorage) {
                if (!this.assumeConstant) {
                    return;
                }
                if (this.changes <= GLOBAL_VARIABLE_MAX_INVALIDATIONS) {
                    ++this.changes;
                    this.unchangedAssumption.invalidate();
                } else {
                    this.unchangedAssumption.getAssumption().invalidate();
                    this.assumeConstant = false;
                }
            }
        } else {
            this.value = value;
        }
    }
}

