/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.loader;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.truffle.core.thread.ThreadManager;
import org.jruby.truffle.language.RubyNode;

public class ReentrantLockFreeingMap<K> {
    private final ConcurrentHashMap<K, ReentrantLock> locks = new ConcurrentHashMap();

    @CompilerDirectives.TruffleBoundary
    public ReentrantLock get(K key) {
        ReentrantLock newLock;
        ReentrantLock wasLock;
        ReentrantLock currentLock = this.locks.get(key);
        ReentrantLock lock = currentLock == null ? ((wasLock = this.locks.putIfAbsent(key, newLock = new ReentrantLock())) == null ? newLock : wasLock) : currentLock;
        return lock;
    }

    public boolean lock(RubyNode currentNode, K key, ReentrantLock lock) {
        return this.lock(currentNode, currentNode.getContext().getThreadManager(), key, lock);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean lock(Node currentNode, ThreadManager threadManager, K key, final ReentrantLock lock) {
        threadManager.runUntilResult(currentNode, new ThreadManager.BlockingAction<Boolean>(){

            @Override
            public Boolean block() throws InterruptedException {
                lock.lockInterruptibly();
                return true;
            }
        });
        if (lock == this.locks.get(key)) {
            return true;
        }
        lock.unlock();
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public void unlock(K key, ReentrantLock lock) {
        if (!lock.hasQueuedThreads()) {
            this.locks.remove(key);
        }
        lock.unlock();
    }
}

