/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib.bigdecimal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.cast.BooleanCastNode;
import org.jruby.truffle.core.cast.BooleanCastNodeGen;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalCastNode;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalCastNodeGen;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalCoreMethodNode;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalType;
import org.jruby.truffle.stdlib.bigdecimal.GetIntegerConstantNode;
import org.jruby.truffle.stdlib.bigdecimal.GetIntegerConstantNodeGen;

@ImportStatic(value={BigDecimalType.class})
@NodeChildren(value={@NodeChild(value="value", type=RubyNode.class), @NodeChild(value="self", type=RubyNode.class), @NodeChild(value="digits", type=RubyNode.class)})
public abstract class CreateBigDecimalNode
extends BigDecimalCoreMethodNode {
    private static final String exponent = "([eE][+-]?)?(\\d*)";
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^([+-]?\\d*\\.?\\d*([eE][+-]?)?(\\d*)).*");
    private static final Pattern ZERO_PATTERN = Pattern.compile("^[+-]?0*\\.?0*([eE][+-]?)?(\\d*)");
    @Node.Child
    private CallDispatchHeadNode allocateNode;

    public abstract DynamicObject executeInitialize(VirtualFrame var1, Object var2, DynamicObject var3, Object var4);

    public final DynamicObject executeCreate(VirtualFrame frame, Object value) {
        if (this.allocateNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.allocateNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
        }
        return this.executeInitialize(frame, value, (DynamicObject)this.allocateNode.call(frame, this.getBigDecimalClass(), "allocate", new Object[0]), NotProvided.INSTANCE);
    }

    @Specialization
    public DynamicObject create(VirtualFrame frame, long value, DynamicObject self, NotProvided digits) {
        return this.executeInitialize(frame, value, self, 0);
    }

    @Specialization
    public DynamicObject create(VirtualFrame frame, long value, DynamicObject self, int digits, @Cached(value="createBigDecimalCastNode()") BigDecimalCastNode bigDecimalCastNode) {
        Layouts.BIG_DECIMAL.setValue(self, bigDecimalCastNode.executeBigDecimal(frame, value, this.getRoundMode(frame)).round(new MathContext(digits, this.getRoundMode(frame))));
        return self;
    }

    @Specialization
    public DynamicObject create(double value, DynamicObject self, NotProvided digits) {
        throw new RaiseException(this.coreExceptions().argumentErrorCantOmitPrecision(this));
    }

    @Specialization
    public DynamicObject create(VirtualFrame frame, double value, DynamicObject self, int digits, @Cached(value="createBigDecimalCastNode()") BigDecimalCastNode bigDecimalCastNode) {
        Layouts.BIG_DECIMAL.setValue(self, bigDecimalCastNode.executeBigDecimal(frame, value, this.getRoundMode(frame)).round(new MathContext(digits, this.getRoundMode(frame))));
        return self;
    }

    @Specialization(guards={"value == NEGATIVE_INFINITY || value == POSITIVE_INFINITY"})
    public DynamicObject createInfinity(VirtualFrame frame, BigDecimalType value, DynamicObject self, Object digits, @Cached(value="createBooleanCastNode()") BooleanCastNode booleanCastNode, @Cached(value="createGetIntegerConstantNode()") GetIntegerConstantNode getIntegerConstantNode, @Cached(value="createMethodCallIgnoreVisibility()") CallDispatchHeadNode modeCallNode, @Cached(value="createBinaryProfile()") ConditionProfile raiseProfile) {
        int exceptionConstant = getIntegerConstantNode.executeGetIntegerConstant(frame, this.getBigDecimalClass(), "EXCEPTION_INFINITY");
        boolean raise = booleanCastNode.executeBoolean(frame, modeCallNode.call(frame, this.getBigDecimalClass(), "boolean_mode", exceptionConstant));
        if (raiseProfile.profile(raise)) {
            throw new RaiseException(this.coreExceptions().floatDomainErrorResultsToInfinity(this));
        }
        Layouts.BIG_DECIMAL.setType(self, value);
        return self;
    }

    @Specialization(guards={"value == NAN"})
    public DynamicObject createNaN(VirtualFrame frame, BigDecimalType value, DynamicObject self, Object digits, @Cached(value="createBooleanCastNode()") BooleanCastNode booleanCastNode, @Cached(value="createGetIntegerConstantNode()") GetIntegerConstantNode getIntegerConstantNode, @Cached(value="createMethodCallIgnoreVisibility()") CallDispatchHeadNode modeCallNode, @Cached(value="createBinaryProfile()") ConditionProfile raiseProfile) {
        int exceptionConstant = getIntegerConstantNode.executeGetIntegerConstant(frame, this.getBigDecimalClass(), "EXCEPTION_NaN");
        boolean raise = booleanCastNode.executeBoolean(frame, modeCallNode.call(frame, this.getBigDecimalClass(), "boolean_mode", exceptionConstant));
        if (raiseProfile.profile(raise)) {
            throw new RaiseException(this.coreExceptions().floatDomainErrorResultsToNaN(this));
        }
        Layouts.BIG_DECIMAL.setType(self, value);
        return self;
    }

    @Specialization(guards={"value == NEGATIVE_ZERO"})
    public DynamicObject createNegativeZero(VirtualFrame frame, BigDecimalType value, DynamicObject self, Object digits) {
        Layouts.BIG_DECIMAL.setType(self, value);
        return self;
    }

    @Specialization
    public DynamicObject create(VirtualFrame frame, BigDecimal value, DynamicObject self, NotProvided digits) {
        return this.create(frame, value, self, 0);
    }

    @Specialization
    public DynamicObject create(VirtualFrame frame, BigDecimal value, DynamicObject self, int digits) {
        Layouts.BIG_DECIMAL.setValue(self, value.round(new MathContext(digits, this.getRoundMode(frame))));
        return self;
    }

    @Specialization(guards={"isRubyBignum(value)"})
    public DynamicObject createBignum(VirtualFrame frame, DynamicObject value, DynamicObject self, NotProvided digits) {
        return this.createBignum(frame, value, self, 0);
    }

    @Specialization(guards={"isRubyBignum(value)"})
    public DynamicObject createBignum(VirtualFrame frame, DynamicObject value, DynamicObject self, int digits) {
        Layouts.BIG_DECIMAL.setValue(self, new BigDecimal(Layouts.BIGNUM.getValue(value)).round(new MathContext(digits, this.getRoundMode(frame))));
        return self;
    }

    @Specialization(guards={"isRubyBigDecimal(value)"})
    public DynamicObject createBigDecimal(VirtualFrame frame, DynamicObject value, DynamicObject self, NotProvided digits) {
        return this.createBigDecimal(frame, value, self, 0);
    }

    @Specialization(guards={"isRubyBigDecimal(value)"})
    public DynamicObject createBigDecimal(VirtualFrame frame, DynamicObject value, DynamicObject self, int digits) {
        Layouts.BIG_DECIMAL.setValue(self, Layouts.BIG_DECIMAL.getValue(value).round(new MathContext(digits, this.getRoundMode(frame))));
        return self;
    }

    @Specialization(guards={"isRubyString(value)"})
    public DynamicObject createString(VirtualFrame frame, DynamicObject value, DynamicObject self, NotProvided digits) {
        return this.createString(frame, value, self, 0);
    }

    @Specialization(guards={"isRubyString(value)"})
    public DynamicObject createString(VirtualFrame frame, DynamicObject value, DynamicObject self, int digits) {
        return this.executeInitialize(frame, this.getValueFromString(value.toString(), digits), self, digits);
    }

    @Specialization(guards={"!isRubyBignum(value)", "!isRubyBigDecimal(value)", "!isRubyString(value)"})
    public DynamicObject create(VirtualFrame frame, DynamicObject value, DynamicObject self, int digits, @Cached(value="createBigDecimalCastNode()") BigDecimalCastNode bigDecimalCastNode, @Cached(value="createBinaryProfile()") ConditionProfile nilProfile) {
        Object castedValue = bigDecimalCastNode.executeObject(frame, value, this.getRoundMode(frame));
        if (nilProfile.profile(castedValue == this.nil())) {
            throw new RaiseException(this.coreExceptions().typeErrorCantBeCastedToBigDecimal(this));
        }
        Layouts.BIG_DECIMAL.setValue(self, ((BigDecimal)castedValue).round(new MathContext(digits, this.getRoundMode(frame))));
        return self;
    }

    @CompilerDirectives.TruffleBoundary
    private Object getValueFromString(String string, int digits) {
        String strValue;
        switch (strValue = string.trim()) {
            case "NaN": {
                return BigDecimalType.NAN;
            }
            case "Infinity": 
            case "+Infinity": {
                return BigDecimalType.POSITIVE_INFINITY;
            }
            case "-Infinity": {
                return BigDecimalType.NEGATIVE_INFINITY;
            }
            case "-0": {
                return BigDecimalType.NEGATIVE_ZERO;
            }
        }
        strValue = strValue.replaceFirst("[dD]", "E");
        strValue = strValue.replaceAll("_", "");
        Matcher matcher = NUMBER_PATTERN.matcher(strValue);
        strValue = matcher.replaceFirst("$1");
        MatchResult result = matcher.toMatchResult();
        try {
            BigDecimal value = new BigDecimal(strValue, new MathContext(digits));
            if (value.compareTo(BigDecimal.ZERO) == 0 && strValue.startsWith("-")) {
                return BigDecimalType.NEGATIVE_ZERO;
            }
            return value;
        }
        catch (NumberFormatException e) {
            if (ZERO_PATTERN.matcher(strValue).matches()) {
                return BigDecimal.ZERO;
            }
            BigInteger exponent = new BigInteger(result.group(3));
            if (exponent.signum() == 1) {
                return BigDecimalType.POSITIVE_INFINITY;
            }
            if (exponent.signum() == -1) {
                return BigDecimal.ZERO;
            }
            throw e;
        }
    }

    protected BigDecimalCastNode createBigDecimalCastNode() {
        return BigDecimalCastNodeGen.create(null, null);
    }

    protected BooleanCastNode createBooleanCastNode() {
        return BooleanCastNodeGen.create(null);
    }

    protected GetIntegerConstantNode createGetIntegerConstantNode() {
        return GetIntegerConstantNodeGen.create(null, null);
    }
}

