/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.SimpleSmartExtensionPoint;
import com.intellij.openapi.extensions.SmartExtensionPoint;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExtensibleQueryFactory<Result, Parameters>
extends QueryFactory<Result, Parameters> {
    private final SmartExtensionPoint<QueryExecutor<Result, Parameters>, QueryExecutor<Result, Parameters>> myPoint;

    protected ExtensibleQueryFactory() {
        this("com.intellij");
    }

    protected ExtensibleQueryFactory(final @NonNls String epNamespace) {
        this.myPoint = new SimpleSmartExtensionPoint<QueryExecutor<Result, Parameters>>(new SmartList()){

            @Override
            @NotNull
            protected ExtensionPoint<QueryExecutor<Result, Parameters>> getExtensionPoint() {
                String epName = ExtensibleQueryFactory.this.getClass().getName();
                int pos = epName.lastIndexOf(46);
                if (pos >= 0) {
                    epName = epName.substring(pos + 1);
                }
                epName = epNamespace + "." + StringUtil.decapitalize(epName);
                ExtensionPoint extensionPoint = Extensions.getRootArea().getExtensionPoint(epName);
                if (extensionPoint == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ExtensibleQueryFactory$1", "getExtensionPoint"));
                }
                return extensionPoint;
            }
        };
    }

    public void registerExecutor(final QueryExecutor<Result, Parameters> queryExecutor, Disposable parentDisposable) {
        this.registerExecutor(queryExecutor);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                ExtensibleQueryFactory.this.unregisterExecutor(queryExecutor);
            }
        });
    }

    @Override
    public void registerExecutor(@NotNull QueryExecutor<Result, Parameters> queryExecutor) {
        if (queryExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryExecutor", "com/intellij/psi/search/searches/ExtensibleQueryFactory", "registerExecutor"));
        }
        this.myPoint.addExplicitExtension(queryExecutor);
    }

    @Override
    public void unregisterExecutor(@NotNull QueryExecutor<Result, Parameters> queryExecutor) {
        if (queryExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryExecutor", "com/intellij/psi/search/searches/ExtensibleQueryFactory", "unregisterExecutor"));
        }
        this.myPoint.removeExplicitExtension(queryExecutor);
    }

    @Override
    @NotNull
    protected List<QueryExecutor<Result, Parameters>> getExecutors() {
        List<QueryExecutor<Result, Parameters>> list2 = this.myPoint.getExtensions();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ExtensibleQueryFactory", "getExecutors"));
        }
        return list2;
    }
}

