/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;

public interface ClusterStateTaskExecutor<T> {
    public BatchResult<T> execute(ClusterState var1, List<T> var2) throws Exception;

    default public boolean runOnlyOnMaster() {
        return true;
    }

    default public void clusterStatePublished(ClusterChangedEvent clusterChangedEvent) {
    }

    default public String describeTasks(List<T> tasks) {
        return tasks.stream().map(Object::toString).reduce((s1, s2) -> {
            if (s1.isEmpty()) {
                return s2;
            }
            if (s2.isEmpty()) {
                return s1;
            }
            return s1 + ", " + s2;
        }).orElse("");
    }

    public static final class TaskResult {
        private final Exception failure;
        private static final TaskResult SUCCESS = new TaskResult(null);

        public static TaskResult success() {
            return SUCCESS;
        }

        public static TaskResult failure(Exception failure) {
            return new TaskResult(failure);
        }

        private TaskResult(Exception failure) {
            this.failure = failure;
        }

        public boolean isSuccess() {
            return this == SUCCESS;
        }

        public Exception getFailure() {
            assert (!this.isSuccess());
            return this.failure;
        }

        public void handle(Runnable onSuccess, Consumer<Exception> onFailure) {
            if (this.failure == null) {
                onSuccess.run();
            } else {
                onFailure.accept(this.failure);
            }
        }
    }

    public static class BatchResult<T> {
        public final ClusterState resultingState;
        public final Map<T, TaskResult> executionResults;

        BatchResult(ClusterState resultingState, Map<T, TaskResult> executionResults) {
            this.resultingState = resultingState;
            this.executionResults = executionResults;
        }

        public static <T> Builder<T> builder() {
            return new Builder();
        }

        public static class Builder<T> {
            private final Map<T, TaskResult> executionResults = new IdentityHashMap<T, TaskResult>();

            public Builder<T> success(T task) {
                return this.result(task, TaskResult.success());
            }

            public Builder<T> successes(Iterable<T> tasks) {
                for (T task : tasks) {
                    this.success(task);
                }
                return this;
            }

            public Builder<T> failure(T task, Exception e) {
                return this.result(task, TaskResult.failure(e));
            }

            public Builder<T> failures(Iterable<T> tasks, Exception e) {
                for (T task : tasks) {
                    this.failure(task, e);
                }
                return this;
            }

            private Builder<T> result(T task, TaskResult executionResult) {
                TaskResult existing = this.executionResults.put(task, executionResult);
                assert (existing == null) : task + " already has result " + existing;
                return this;
            }

            public BatchResult<T> build(ClusterState resultingState) {
                return new BatchResult<T>(resultingState, this.executionResults);
            }
        }
    }
}

