/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.collect.Tuple;

public interface AliasOrIndex {
    public boolean isAlias();

    public List<IndexMetaData> getIndices();

    public static class Alias
    implements AliasOrIndex {
        private final String aliasName;
        private final List<IndexMetaData> referenceIndexMetaDatas;

        public Alias(AliasMetaData aliasMetaData, IndexMetaData indexMetaData) {
            this.aliasName = aliasMetaData.getAlias();
            this.referenceIndexMetaDatas = new ArrayList<IndexMetaData>();
            this.referenceIndexMetaDatas.add(indexMetaData);
        }

        @Override
        public boolean isAlias() {
            return true;
        }

        @Override
        public List<IndexMetaData> getIndices() {
            return this.referenceIndexMetaDatas;
        }

        public Iterable<Tuple<String, AliasMetaData>> getConcreteIndexAndAliasMetaDatas() {
            return new Iterable<Tuple<String, AliasMetaData>>(){

                @Override
                public Iterator<Tuple<String, AliasMetaData>> iterator() {
                    return new Iterator<Tuple<String, AliasMetaData>>(){
                        int index = 0;

                        @Override
                        public boolean hasNext() {
                            return this.index < referenceIndexMetaDatas.size();
                        }

                        @Override
                        public Tuple<String, AliasMetaData> next() {
                            IndexMetaData indexMetaData = (IndexMetaData)referenceIndexMetaDatas.get(this.index++);
                            return new Tuple<String, AliasMetaData>(indexMetaData.getIndex().getName(), indexMetaData.getAliases().get(aliasName));
                        }

                        @Override
                        public final void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }

        public AliasMetaData getFirstAliasMetaData() {
            return this.referenceIndexMetaDatas.get(0).getAliases().get(this.aliasName);
        }

        void addIndex(IndexMetaData indexMetaData) {
            this.referenceIndexMetaDatas.add(indexMetaData);
        }
    }

    public static class Index
    implements AliasOrIndex {
        private final IndexMetaData concreteIndex;

        public Index(IndexMetaData indexMetaData) {
            this.concreteIndex = indexMetaData;
        }

        @Override
        public boolean isAlias() {
            return false;
        }

        @Override
        public List<IndexMetaData> getIndices() {
            return Collections.singletonList(this.concreteIndex);
        }

        public IndexMetaData getIndex() {
            return this.concreteIndex;
        }
    }
}

