/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentMapperForType;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldTypeLookup;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperUtils;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.indices.InvalidTypeNameException;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.indices.mapper.MapperRegistry;

public class MapperService
extends AbstractIndexComponent
implements Closeable {
    public static final String DEFAULT_MAPPING = "_default_";
    public static final Setting<Long> INDEX_MAPPING_NESTED_FIELDS_LIMIT_SETTING = Setting.longSetting("index.mapping.nested_fields.limit", 50L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING = Setting.longSetting("index.mapping.total_fields.limit", 1000L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_DEPTH_LIMIT_SETTING = Setting.longSetting("index.mapping.depth.limit", 20L, 1L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final boolean INDEX_MAPPER_DYNAMIC_DEFAULT = true;
    public static final Setting<Boolean> INDEX_MAPPER_DYNAMIC_SETTING = Setting.boolSetting("index.mapper.dynamic", true, Setting.Property.Dynamic, Setting.Property.IndexScope);
    private static ObjectHashSet<String> META_FIELDS = ObjectHashSet.from((Object[])new String[]{"_uid", "_id", "_type", "_all", "_parent", "_routing", "_index", "_size", "_timestamp", "_ttl"});
    @Deprecated
    public static final String PERCOLATOR_LEGACY_TYPE_NAME = ".percolator";
    private final IndexAnalyzers indexAnalyzers;
    private final boolean dynamic;
    private volatile String defaultMappingSource;
    private volatile Map<String, DocumentMapper> mappers = Collections.emptyMap();
    private volatile FieldTypeLookup fieldTypes;
    private volatile Map<String, ObjectMapper> fullPathObjectMappers = new HashMap<String, ObjectMapper>();
    private boolean hasNested = false;
    private boolean allEnabled = false;
    private final DocumentMapperParser documentParser;
    private final MapperAnalyzerWrapper indexAnalyzer;
    private final MapperAnalyzerWrapper searchAnalyzer;
    private final MapperAnalyzerWrapper searchQuoteAnalyzer;
    private volatile Map<String, MappedFieldType> unmappedFieldTypes = Collections.emptyMap();
    private volatile Set<String> parentTypes = Collections.emptySet();
    final MapperRegistry mapperRegistry;

    public MapperService(IndexSettings indexSettings, IndexAnalyzers indexAnalyzers, SimilarityService similarityService, MapperRegistry mapperRegistry, Supplier<QueryShardContext> queryShardContextSupplier) {
        super(indexSettings);
        this.indexAnalyzers = indexAnalyzers;
        this.fieldTypes = new FieldTypeLookup();
        this.documentParser = new DocumentMapperParser(indexSettings, this, indexAnalyzers, similarityService, mapperRegistry, queryShardContextSupplier);
        this.indexAnalyzer = new MapperAnalyzerWrapper((Analyzer)indexAnalyzers.getDefaultIndexAnalyzer(), p -> p.indexAnalyzer());
        this.searchAnalyzer = new MapperAnalyzerWrapper((Analyzer)indexAnalyzers.getDefaultSearchAnalyzer(), p -> p.searchAnalyzer());
        this.searchQuoteAnalyzer = new MapperAnalyzerWrapper((Analyzer)indexAnalyzers.getDefaultSearchQuoteAnalyzer(), p -> p.searchQuoteAnalyzer());
        this.mapperRegistry = mapperRegistry;
        this.dynamic = this.indexSettings.getValue(INDEX_MAPPER_DYNAMIC_SETTING);
        this.defaultMappingSource = "{\"_default_\":{}}";
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("using dynamic[{}], default mapping source[{}]", (Object)this.dynamic, (Object)this.defaultMappingSource);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("using dynamic[{}]", (Object)this.dynamic);
        }
    }

    public boolean hasNested() {
        return this.hasNested;
    }

    public boolean allEnabled() {
        return this.allEnabled;
    }

    public Iterable<DocumentMapper> docMappers(boolean includingDefaultMapping) {
        return () -> {
            Collection documentMappers = includingDefaultMapping ? this.mappers.values() : (Collection)this.mappers.values().stream().filter(mapper -> !DEFAULT_MAPPING.equals(mapper.type())).collect(Collectors.toList());
            return Collections.unmodifiableCollection(documentMappers).iterator();
        };
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.indexAnalyzers;
    }

    public DocumentMapperParser documentMapperParser() {
        return this.documentParser;
    }

    public static Map<String, Object> parseMapping(String mappingSource) throws Exception {
        try (XContentParser parser = XContentFactory.xContent(mappingSource).createParser(mappingSource);){
            Map<String, Object> map = parser.map();
            return map;
        }
    }

    public boolean updateMapping(IndexMetaData indexMetaData) throws IOException {
        assert (indexMetaData.getIndex().equals(this.index())) : "index mismatch: expected " + this.index() + " but was " + indexMetaData.getIndex();
        boolean requireRefresh = false;
        for (ObjectCursor cursor : indexMetaData.getMappings().values()) {
            MappingMetaData mappingMd = (MappingMetaData)cursor.value;
            String mappingType = mappingMd.type();
            CompressedXContent mappingSource = mappingMd.source();
            try {
                String op;
                DocumentMapper existingMapper = this.documentMapper(mappingType);
                if (existingMapper != null && mappingSource.equals(existingMapper.mappingSource())) continue;
                String string = op = existingMapper == null ? "adding" : "updating";
                if (this.logger.isDebugEnabled() && mappingSource.compressed().length < 512) {
                    this.logger.debug("[{}] {} mapping [{}], source [{}]", (Object)this.index(), (Object)op, (Object)mappingType, (Object)mappingSource.string());
                } else if (this.logger.isTraceEnabled()) {
                    this.logger.trace("[{}] {} mapping [{}], source [{}]", (Object)this.index(), (Object)op, (Object)mappingType, (Object)mappingSource.string());
                } else {
                    this.logger.debug("[{}] {} mapping [{}] (source suppressed due to length, use TRACE level if needed)", (Object)this.index(), (Object)op, (Object)mappingType);
                }
                this.merge(mappingType, mappingSource, MergeReason.MAPPING_RECOVERY, true);
                if (this.documentMapper(mappingType).mappingSource().equals(mappingSource)) continue;
                this.logger.debug("[{}] parsed mapping [{}], and got different sources\noriginal:\n{}\nparsed:\n{}", (Object)this.index(), (Object)mappingType, (Object)mappingSource, (Object)this.documentMapper(mappingType).mappingSource());
                requireRefresh = true;
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to add mapping [{}], source [{}]", new Object[]{this.index(), mappingType, mappingSource}), (Throwable)e);
                throw e;
            }
        }
        return requireRefresh;
    }

    public void merge(Map<String, Map<String, Object>> mappings, boolean updateAllTypes) throws MapperParsingException {
        if (mappings.containsKey(DEFAULT_MAPPING)) {
            try {
                this.merge(DEFAULT_MAPPING, new CompressedXContent(XContentFactory.jsonBuilder().map(mappings.get(DEFAULT_MAPPING)).string()), MergeReason.MAPPING_UPDATE, updateAllTypes);
            }
            catch (Exception e) {
                throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, DEFAULT_MAPPING, e.getMessage());
            }
        }
        for (Map.Entry<String, Map<String, Object>> entry : mappings.entrySet()) {
            if (entry.getKey().equals(DEFAULT_MAPPING)) continue;
            try {
                this.merge(entry.getKey(), new CompressedXContent(XContentFactory.jsonBuilder().map(entry.getValue()).string()), MergeReason.MAPPING_UPDATE, updateAllTypes);
            }
            catch (Exception e) {
                throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, entry.getKey(), e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentMapper merge(String type, CompressedXContent mappingSource, MergeReason reason, boolean updateAllTypes) {
        if (DEFAULT_MAPPING.equals(type)) {
            DocumentMapper mapper = this.documentParser.parse(type, mappingSource);
            MapperService mapperService = this;
            synchronized (mapperService) {
                this.mappers = MapBuilder.newMapBuilder(this.mappers).put(type, mapper).map();
            }
            try {
                this.defaultMappingSource = mappingSource.string();
            }
            catch (IOException e) {
                throw new ElasticsearchGenerationException("failed to un-compress", e);
            }
            return mapper;
        }
        MapperService mapperService = this;
        synchronized (mapperService) {
            boolean applyDefault = reason != MergeReason.MAPPING_RECOVERY && !this.mappers.containsKey(type);
            DocumentMapper mergeWith = this.parse(type, mappingSource, applyDefault);
            return this.merge(mergeWith, reason, updateAllTypes);
        }
    }

    private synchronized DocumentMapper merge(DocumentMapper mapper, MergeReason reason, boolean updateAllTypes) {
        if (mapper.type().length() == 0) {
            throw new InvalidTypeNameException("mapping type name is empty");
        }
        if (mapper.type().length() > 255) {
            throw new InvalidTypeNameException("mapping type name [" + mapper.type() + "] is too long; limit is length 255 but was [" + mapper.type().length() + "]");
        }
        if (mapper.type().charAt(0) == '_') {
            throw new InvalidTypeNameException("mapping type name [" + mapper.type() + "] can't start with '_'");
        }
        if (mapper.type().contains("#")) {
            throw new InvalidTypeNameException("mapping type name [" + mapper.type() + "] should not include '#' in it");
        }
        if (mapper.type().contains(",")) {
            throw new InvalidTypeNameException("mapping type name [" + mapper.type() + "] should not include ',' in it");
        }
        if (mapper.type().equals(mapper.parentFieldMapper().type())) {
            throw new IllegalArgumentException("The [_parent.type] option can't point to the same type");
        }
        if (this.typeNameStartsWithIllegalDot(mapper)) {
            throw new IllegalArgumentException("mapping type name [" + mapper.type() + "] must not start with a '.'");
        }
        DocumentMapper oldMapper = this.mappers.get(mapper.type());
        DocumentMapper newMapper = oldMapper != null ? oldMapper.merge(mapper.mapping(), updateAllTypes) : mapper;
        ArrayList<ObjectMapper> objectMappers = new ArrayList<ObjectMapper>();
        ArrayList<FieldMapper> fieldMappers = new ArrayList<FieldMapper>();
        Collections.addAll(fieldMappers, newMapper.mapping().metadataMappers);
        MapperUtils.collect(newMapper.mapping().root(), objectMappers, fieldMappers);
        this.checkFieldUniqueness(newMapper.type(), objectMappers, fieldMappers);
        this.checkObjectsCompatibility(objectMappers, updateAllTypes);
        FieldTypeLookup fieldTypes = this.fieldTypes.copyAndAddAll(newMapper.type(), fieldMappers, updateAllTypes);
        boolean hasNested = this.hasNested;
        Map<String, ObjectMapper> fullPathObjectMappers = new HashMap<String, ObjectMapper>(this.fullPathObjectMappers);
        for (ObjectMapper objectMapper : objectMappers) {
            fullPathObjectMappers.put(objectMapper.fullPath(), objectMapper);
            if (!objectMapper.nested().isNested()) continue;
            hasNested = true;
        }
        fullPathObjectMappers = Collections.unmodifiableMap(fullPathObjectMappers);
        if (reason == MergeReason.MAPPING_UPDATE) {
            this.checkNestedFieldsLimit(fullPathObjectMappers);
            this.checkTotalFieldsLimit(objectMappers.size() + fieldMappers.size());
            this.checkDepthLimit(fullPathObjectMappers.keySet());
        }
        Set<String> parentTypes = this.parentTypes;
        if (oldMapper == null && newMapper.parentFieldMapper().active()) {
            parentTypes = new HashSet<String>(parentTypes.size() + 1);
            parentTypes.addAll(this.parentTypes);
            parentTypes.add(mapper.parentFieldMapper().type());
            parentTypes = Collections.unmodifiableSet(parentTypes);
        }
        Map<String, DocumentMapper> mappers = new HashMap<String, DocumentMapper>(this.mappers);
        mappers.put(newMapper.type(), newMapper);
        for (Map.Entry entry : mappers.entrySet()) {
            if (((String)entry.getKey()).equals(DEFAULT_MAPPING)) continue;
            DocumentMapper m = (DocumentMapper)entry.getValue();
            m = m.updateFieldType(fieldTypes.fullNameToFieldType);
            entry.setValue(m);
        }
        mappers = Collections.unmodifiableMap(mappers);
        this.mappers = mappers;
        this.fieldTypes = fieldTypes;
        this.hasNested = hasNested;
        this.fullPathObjectMappers = fullPathObjectMappers;
        this.parentTypes = parentTypes;
        this.allEnabled = mapper.allFieldMapper().enabled();
        assert (this.assertSerialization(newMapper));
        assert (this.assertMappersShareSameFieldType());
        return newMapper;
    }

    private boolean assertMappersShareSameFieldType() {
        for (DocumentMapper mapper : this.docMappers(false)) {
            ArrayList<FieldMapper> fieldMappers = new ArrayList<FieldMapper>();
            Collections.addAll(fieldMappers, mapper.mapping().metadataMappers);
            MapperUtils.collect(mapper.root(), new ArrayList<ObjectMapper>(), fieldMappers);
            for (FieldMapper fieldMapper : fieldMappers) {
                assert (fieldMapper.fieldType() == this.fieldTypes.get(fieldMapper.name())) : fieldMapper.name();
            }
        }
        return true;
    }

    private boolean typeNameStartsWithIllegalDot(DocumentMapper mapper) {
        boolean legacyIndex = this.getIndexSettings().getIndexVersionCreated().before(Version.V_5_0_0_alpha1);
        if (legacyIndex) {
            return mapper.type().startsWith(".") && !PERCOLATOR_LEGACY_TYPE_NAME.equals(mapper.type());
        }
        return mapper.type().startsWith(".");
    }

    private boolean assertSerialization(DocumentMapper mapper) {
        CompressedXContent mappingSource = mapper.mappingSource();
        DocumentMapper newMapper = this.parse(mapper.type(), mappingSource, false);
        if (!newMapper.mappingSource().equals(mappingSource)) {
            throw new IllegalStateException("DocumentMapper serialization result is different from source. \n--> Source [" + mappingSource + "]\n--> Result [" + newMapper.mappingSource() + "]");
        }
        return true;
    }

    private void checkFieldUniqueness(String type, Collection<ObjectMapper> objectMappers, Collection<FieldMapper> fieldMappers) {
        assert (Thread.holdsLock(this));
        HashSet<String> objectFullNames = new HashSet<String>();
        for (ObjectMapper objectMapper : objectMappers) {
            String fullPath = objectMapper.fullPath();
            if (objectFullNames.add(fullPath)) continue;
            throw new IllegalArgumentException("Object mapper [" + fullPath + "] is defined twice in mapping for type [" + type + "]");
        }
        HashSet<String> fieldNames = new HashSet<String>();
        for (FieldMapper fieldMapper : fieldMappers) {
            String name = fieldMapper.name();
            if (objectFullNames.contains(name)) {
                throw new IllegalArgumentException("Field [" + name + "] is defined both as an object and a field in [" + type + "]");
            }
            if (fieldNames.add(name)) continue;
            throw new IllegalArgumentException("Field [" + name + "] is defined twice in [" + type + "]");
        }
        for (String fieldName : fieldNames) {
            if (!this.fullPathObjectMappers.containsKey(fieldName)) continue;
            throw new IllegalArgumentException("[" + fieldName + "] is defined as a field in mapping [" + type + "] but this name is already used for an object in other types");
        }
        for (String objectPath : objectFullNames) {
            if (this.fieldTypes.get(objectPath) == null) continue;
            throw new IllegalArgumentException("[" + objectPath + "] is defined as an object in mapping [" + type + "] but this name is already used for a field in other types");
        }
    }

    private void checkObjectsCompatibility(Collection<ObjectMapper> objectMappers, boolean updateAllTypes) {
        assert (Thread.holdsLock(this));
        for (ObjectMapper newObjectMapper : objectMappers) {
            ObjectMapper existingObjectMapper = this.fullPathObjectMappers.get(newObjectMapper.fullPath());
            if (existingObjectMapper == null) continue;
            existingObjectMapper.merge(newObjectMapper, updateAllTypes);
        }
    }

    private void checkNestedFieldsLimit(Map<String, ObjectMapper> fullPathObjectMappers) {
        long allowedNestedFields = this.indexSettings.getValue(INDEX_MAPPING_NESTED_FIELDS_LIMIT_SETTING);
        long actualNestedFields = 0L;
        for (ObjectMapper objectMapper : fullPathObjectMappers.values()) {
            if (!objectMapper.nested().isNested()) continue;
            ++actualNestedFields;
        }
        if (actualNestedFields > allowedNestedFields) {
            throw new IllegalArgumentException("Limit of nested fields [" + allowedNestedFields + "] in index [" + this.index().getName() + "] has been exceeded");
        }
    }

    private void checkTotalFieldsLimit(long totalMappers) {
        long allowedTotalFields = this.indexSettings.getValue(INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING);
        if (allowedTotalFields < totalMappers) {
            throw new IllegalArgumentException("Limit of total fields [" + allowedTotalFields + "] in index [" + this.index().getName() + "] has been exceeded");
        }
    }

    private void checkDepthLimit(Collection<String> objectPaths) {
        long maxDepth = this.indexSettings.getValue(INDEX_MAPPING_DEPTH_LIMIT_SETTING);
        for (String objectPath : objectPaths) {
            this.checkDepthLimit(objectPath, maxDepth);
        }
    }

    private void checkDepthLimit(String objectPath, long maxDepth) {
        int numDots = 0;
        for (int i = 0; i < objectPath.length(); ++i) {
            if (objectPath.charAt(i) != '.') continue;
            ++numDots;
        }
        int depth = numDots + 2;
        if ((long)depth > maxDepth) {
            throw new IllegalArgumentException("Limit of mapping depth [" + maxDepth + "] in index [" + this.index().getName() + "] has been exceeded due to object field [" + objectPath + "]");
        }
    }

    public DocumentMapper parse(String mappingType, CompressedXContent mappingSource, boolean applyDefault) throws MapperParsingException {
        return this.documentParser.parse(mappingType, mappingSource, applyDefault ? this.defaultMappingSource : null);
    }

    public boolean hasMapping(String mappingType) {
        return this.mappers.containsKey(mappingType);
    }

    public Collection<String> types() {
        HashSet<String> types = new HashSet<String>(this.mappers.keySet());
        types.remove(DEFAULT_MAPPING);
        return Collections.unmodifiableSet(types);
    }

    public DocumentMapper documentMapper(String type) {
        return this.mappers.get(type);
    }

    public DocumentMapperForType documentMapperWithAutoCreate(String type) {
        DocumentMapper mapper = this.mappers.get(type);
        if (mapper != null) {
            return new DocumentMapperForType(mapper, null);
        }
        if (!this.dynamic) {
            throw new TypeMissingException(this.index(), (Throwable)new IllegalStateException("trying to auto create mapping, but dynamic mapping is disabled"), type);
        }
        mapper = this.parse(type, null, true);
        return new DocumentMapperForType(mapper, mapper.mapping());
    }

    public MappedFieldType fullName(String fullName) {
        return this.fieldTypes.get(fullName);
    }

    public Collection<String> simpleMatchToIndexNames(String pattern) {
        if (!Regex.isSimpleMatchPattern(pattern)) {
            return Collections.singletonList(pattern);
        }
        return this.fieldTypes.simpleMatchToFullName(pattern);
    }

    public ObjectMapper getObjectMapper(String name) {
        return this.fullPathObjectMappers.get(name);
    }

    public MappedFieldType unmappedFieldType(String type) {
        MappedFieldType fieldType;
        if (type.equals("string")) {
            this.deprecationLogger.deprecated("[unmapped_type:string] should be replaced with [unmapped_type:keyword]", new Object[0]);
            type = "keyword";
        }
        if ((fieldType = this.unmappedFieldTypes.get(type)) == null) {
            Mapper.TypeParser.ParserContext parserContext = this.documentMapperParser().parserContext(type);
            Mapper.TypeParser typeParser = parserContext.typeParser(type);
            if (typeParser == null) {
                throw new IllegalArgumentException("No mapper found for type [" + type + "]");
            }
            Mapper.Builder<?, ?> builder = typeParser.parse("__anonymous_" + type, Collections.emptyMap(), parserContext);
            Mapper.BuilderContext builderContext = new Mapper.BuilderContext(this.indexSettings.getSettings(), new ContentPath(1));
            fieldType = ((FieldMapper)builder.build(builderContext)).fieldType();
            HashMap<String, MappedFieldType> newUnmappedFieldTypes = new HashMap<String, MappedFieldType>();
            newUnmappedFieldTypes.putAll(this.unmappedFieldTypes);
            newUnmappedFieldTypes.put(type, fieldType);
            this.unmappedFieldTypes = Collections.unmodifiableMap(newUnmappedFieldTypes);
        }
        return fieldType;
    }

    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public Analyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public Analyzer searchQuoteAnalyzer() {
        return this.searchQuoteAnalyzer;
    }

    public Set<String> getParentTypes() {
        return this.parentTypes;
    }

    @Override
    public void close() throws IOException {
        this.indexAnalyzers.close();
    }

    public static boolean isMetadataField(String fieldName) {
        return META_FIELDS.contains((Object)fieldName);
    }

    public static String[] getAllMetaFields() {
        return (String[])META_FIELDS.toArray(String.class);
    }

    final class MapperAnalyzerWrapper
    extends DelegatingAnalyzerWrapper {
        private final Analyzer defaultAnalyzer;
        private final Function<MappedFieldType, Analyzer> extractAnalyzer;

        MapperAnalyzerWrapper(Analyzer defaultAnalyzer, Function<MappedFieldType, Analyzer> extractAnalyzer) {
            super(Analyzer.PER_FIELD_REUSE_STRATEGY);
            this.defaultAnalyzer = defaultAnalyzer;
            this.extractAnalyzer = extractAnalyzer;
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            Analyzer analyzer;
            MappedFieldType fieldType = MapperService.this.fullName(fieldName);
            if (fieldType != null && (analyzer = this.extractAnalyzer.apply(fieldType)) != null) {
                return analyzer;
            }
            return this.defaultAnalyzer;
        }
    }

    public static enum MergeReason {
        MAPPING_UPDATE,
        MAPPING_RECOVERY;

    }
}

