/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.elasticsearch.common.Strings;
import org.elasticsearch.ingest.TemplateService;
import org.elasticsearch.ingest.ValueSource;

public final class IngestDocument {
    public static final String INGEST_KEY = "_ingest";
    private static final String INGEST_KEY_PREFIX = "_ingest.";
    private static final String SOURCE_PREFIX = "_source.";
    static final String TIMESTAMP = "timestamp";
    private final Map<String, Object> sourceAndMetadata;
    private final Map<String, Object> ingestMetadata;

    public IngestDocument(String index, String type, String id, String routing, String parent, String timestamp, String ttl, Map<String, Object> source) {
        this.sourceAndMetadata = new HashMap<String, Object>();
        this.sourceAndMetadata.putAll(source);
        this.sourceAndMetadata.put(MetaData.INDEX.getFieldName(), index);
        this.sourceAndMetadata.put(MetaData.TYPE.getFieldName(), type);
        this.sourceAndMetadata.put(MetaData.ID.getFieldName(), id);
        if (routing != null) {
            this.sourceAndMetadata.put(MetaData.ROUTING.getFieldName(), routing);
        }
        if (parent != null) {
            this.sourceAndMetadata.put(MetaData.PARENT.getFieldName(), parent);
        }
        if (timestamp != null) {
            this.sourceAndMetadata.put(MetaData.TIMESTAMP.getFieldName(), timestamp);
        }
        if (ttl != null) {
            this.sourceAndMetadata.put(MetaData.TTL.getFieldName(), ttl);
        }
        this.ingestMetadata = new HashMap<String, Object>();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZ", Locale.ROOT);
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.ingestMetadata.put(TIMESTAMP, df.format(new Date()));
    }

    public IngestDocument(IngestDocument other) {
        this(IngestDocument.deepCopyMap(other.sourceAndMetadata), IngestDocument.deepCopyMap(other.ingestMetadata));
    }

    public IngestDocument(Map<String, Object> sourceAndMetadata, Map<String, Object> ingestMetadata) {
        this.sourceAndMetadata = sourceAndMetadata;
        this.ingestMetadata = ingestMetadata;
    }

    public <T> T getFieldValue(String path, Class<T> clazz) {
        FieldPath fieldPath = new FieldPath(path);
        Object context = fieldPath.initialContext;
        for (String pathElement : fieldPath.pathElements) {
            context = IngestDocument.resolve(pathElement, path, context);
        }
        return IngestDocument.cast(path, context, clazz);
    }

    public <T> T getFieldValue(String path, Class<T> clazz, boolean ignoreMissing) {
        try {
            return this.getFieldValue(path, clazz);
        }
        catch (IllegalArgumentException e) {
            if (ignoreMissing && !this.hasField(path)) {
                return null;
            }
            throw e;
        }
    }

    public <T> T getFieldValue(TemplateService.Template pathTemplate, Class<T> clazz) {
        return this.getFieldValue(this.renderTemplate(pathTemplate), clazz);
    }

    public byte[] getFieldValueAsBytes(String path) {
        Object object = this.getFieldValue(path, Object.class);
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return Base64.getDecoder().decode(object.toString());
        }
        throw new IllegalArgumentException("Content field [" + path + "] of unknown type [" + object.getClass().getName() + "], must be string or byte array");
    }

    public boolean hasField(TemplateService.Template fieldPathTemplate) {
        return this.hasField(this.renderTemplate(fieldPathTemplate));
    }

    public boolean hasField(String path) {
        return this.hasField(path, false);
    }

    public boolean hasField(String path, boolean failOutOfRange) {
        FieldPath fieldPath = new FieldPath(path);
        Object context = fieldPath.initialContext;
        for (int i = 0; i < fieldPath.pathElements.length - 1; ++i) {
            String pathElement = fieldPath.pathElements[i];
            if (context == null) {
                return false;
            }
            if (context instanceof Map) {
                Map map = (Map)context;
                context = map.get(pathElement);
                continue;
            }
            if (context instanceof List) {
                List list = (List)context;
                try {
                    int index = Integer.parseInt(pathElement);
                    if (index < 0 || index >= list.size()) {
                        if (failOutOfRange) {
                            throw new IllegalArgumentException("[" + index + "] is out of bounds for array with length [" + list.size() + "] as part of path [" + path + "]");
                        }
                        return false;
                    }
                    context = list.get(index);
                    continue;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return false;
        }
        String leafKey = fieldPath.pathElements[fieldPath.pathElements.length - 1];
        if (context instanceof Map) {
            Map map = (Map)context;
            return map.containsKey(leafKey);
        }
        if (context instanceof List) {
            List list = (List)context;
            try {
                int index = Integer.parseInt(leafKey);
                if (index >= 0 && index < list.size()) {
                    return true;
                }
                if (failOutOfRange) {
                    throw new IllegalArgumentException("[" + index + "] is out of bounds for array with length [" + list.size() + "] as part of path [" + path + "]");
                }
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public void removeField(TemplateService.Template fieldPathTemplate) {
        this.removeField(this.renderTemplate(fieldPathTemplate));
    }

    public void removeField(String path) {
        FieldPath fieldPath = new FieldPath(path);
        Object context = fieldPath.initialContext;
        for (int i = 0; i < fieldPath.pathElements.length - 1; ++i) {
            context = IngestDocument.resolve(fieldPath.pathElements[i], path, context);
        }
        String leafKey = fieldPath.pathElements[fieldPath.pathElements.length - 1];
        if (context instanceof Map) {
            Map map = (Map)context;
            if (map.containsKey(leafKey)) {
                map.remove(leafKey);
                return;
            }
            throw new IllegalArgumentException("field [" + leafKey + "] not present as part of path [" + path + "]");
        }
        if (context instanceof List) {
            int index;
            List list = (List)context;
            try {
                index = Integer.parseInt(leafKey);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("[" + leafKey + "] is not an integer, cannot be used as an index as part of path [" + path + "]", e);
            }
            if (index < 0 || index >= list.size()) {
                throw new IllegalArgumentException("[" + index + "] is out of bounds for array with length [" + list.size() + "] as part of path [" + path + "]");
            }
            list.remove(index);
            return;
        }
        if (context == null) {
            throw new IllegalArgumentException("cannot remove [" + leafKey + "] from null as part of path [" + path + "]");
        }
        throw new IllegalArgumentException("cannot remove [" + leafKey + "] from object of type [" + context.getClass().getName() + "] as part of path [" + path + "]");
    }

    private static Object resolve(String pathElement, String fullPath, Object context) {
        if (context == null) {
            throw new IllegalArgumentException("cannot resolve [" + pathElement + "] from null as part of path [" + fullPath + "]");
        }
        if (context instanceof Map) {
            Map map = (Map)context;
            if (map.containsKey(pathElement)) {
                return map.get(pathElement);
            }
            throw new IllegalArgumentException("field [" + pathElement + "] not present as part of path [" + fullPath + "]");
        }
        if (context instanceof List) {
            int index;
            List list = (List)context;
            try {
                index = Integer.parseInt(pathElement);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("[" + pathElement + "] is not an integer, cannot be used as an index as part of path [" + fullPath + "]", e);
            }
            if (index < 0 || index >= list.size()) {
                throw new IllegalArgumentException("[" + index + "] is out of bounds for array with length [" + list.size() + "] as part of path [" + fullPath + "]");
            }
            return list.get(index);
        }
        throw new IllegalArgumentException("cannot resolve [" + pathElement + "] from object of type [" + context.getClass().getName() + "] as part of path [" + fullPath + "]");
    }

    public void appendFieldValue(String path, Object value) {
        this.setFieldValue(path, value, true);
    }

    public void appendFieldValue(TemplateService.Template fieldPathTemplate, ValueSource valueSource) {
        Map<String, Object> model = this.createTemplateModel();
        this.appendFieldValue(fieldPathTemplate.execute(model), valueSource.copyAndResolve(model));
    }

    public void setFieldValue(String path, Object value) {
        this.setFieldValue(path, value, false);
    }

    public void setFieldValue(TemplateService.Template fieldPathTemplate, ValueSource valueSource) {
        Map<String, Object> model = this.createTemplateModel();
        this.setFieldValue(fieldPathTemplate.execute(model), valueSource.copyAndResolve(model), false);
    }

    private void setFieldValue(String path, Object value, boolean append) {
        ArrayList<Object> list;
        FieldPath fieldPath = new FieldPath(path);
        HashMap context = fieldPath.initialContext;
        for (int i = 0; i < fieldPath.pathElements.length - 1; ++i) {
            String pathElement = fieldPath.pathElements[i];
            if (context == null) {
                throw new IllegalArgumentException("cannot resolve [" + pathElement + "] from null as part of path [" + path + "]");
            }
            if (context instanceof Map) {
                Map map = context;
                if (map.containsKey(pathElement)) {
                    context = map.get(pathElement);
                    continue;
                }
                HashMap newMap = new HashMap();
                map.put(pathElement, newMap);
                context = newMap;
                continue;
            }
            if (context instanceof List) {
                int index;
                list = (ArrayList<Object>)((Object)context);
                try {
                    index = Integer.parseInt(pathElement);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("[" + pathElement + "] is not an integer, cannot be used as an index as part of path [" + path + "]", e);
                }
                if (index < 0 || index >= list.size()) {
                    throw new IllegalArgumentException("[" + index + "] is out of bounds for array with length [" + list.size() + "] as part of path [" + path + "]");
                }
                context = list.get(index);
                continue;
            }
            throw new IllegalArgumentException("cannot resolve [" + pathElement + "] from object of type [" + context.getClass().getName() + "] as part of path [" + path + "]");
        }
        String leafKey = fieldPath.pathElements[fieldPath.pathElements.length - 1];
        if (context == null) {
            throw new IllegalArgumentException("cannot set [" + leafKey + "] with null parent as part of path [" + path + "]");
        }
        if (context instanceof Map) {
            Map map = context;
            if (append) {
                if (map.containsKey(leafKey)) {
                    Object object = map.get(leafKey);
                    List<Object> list2 = IngestDocument.appendValues(object, value);
                    if (list2 != object) {
                        map.put(leafKey, list2);
                    }
                } else {
                    list = new ArrayList<Object>();
                    IngestDocument.appendValues(list, value);
                    map.put(leafKey, list);
                }
                return;
            }
            map.put(leafKey, value);
        } else if (context instanceof List) {
            int index;
            List list3 = (List)((Object)context);
            try {
                index = Integer.parseInt(leafKey);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("[" + leafKey + "] is not an integer, cannot be used as an index as part of path [" + path + "]", e);
            }
            if (index < 0 || index >= list3.size()) {
                throw new IllegalArgumentException("[" + index + "] is out of bounds for array with length [" + list3.size() + "] as part of path [" + path + "]");
            }
            if (append) {
                Object object = list3.get(index);
                List<Object> newList = IngestDocument.appendValues(object, value);
                if (newList != object) {
                    list3.set(index, newList);
                }
                return;
            }
            list3.set(index, value);
        } else {
            throw new IllegalArgumentException("cannot set [" + leafKey + "] with parent object of type [" + context.getClass().getName() + "] as part of path [" + path + "]");
        }
    }

    private static List<Object> appendValues(Object maybeList, Object value) {
        ArrayList<Object> list;
        if (maybeList instanceof List) {
            list = (ArrayList<Object>)maybeList;
        } else {
            list = new ArrayList<Object>();
            list.add(maybeList);
        }
        IngestDocument.appendValues(list, value);
        return list;
    }

    private static void appendValues(List<Object> list, Object value) {
        if (value instanceof List) {
            List valueList = (List)value;
            valueList.stream().forEach(list::add);
        } else {
            list.add(value);
        }
    }

    private static <T> T cast(String path, Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        throw new IllegalArgumentException("field [" + path + "] of type [" + object.getClass().getName() + "] cannot be cast to [" + clazz.getName() + "]");
    }

    public String renderTemplate(TemplateService.Template template) {
        return template.execute(this.createTemplateModel());
    }

    private Map<String, Object> createTemplateModel() {
        HashMap<String, Object> model = new HashMap<String, Object>(this.sourceAndMetadata);
        model.put("_source", this.sourceAndMetadata);
        model.put(INGEST_KEY, this.ingestMetadata);
        return model;
    }

    public Map<MetaData, String> extractMetadata() {
        HashMap<MetaData, String> metadataMap = new HashMap<MetaData, String>();
        for (MetaData metaData : MetaData.values()) {
            metadataMap.put(metaData, IngestDocument.cast(metaData.getFieldName(), this.sourceAndMetadata.remove(metaData.getFieldName()), String.class));
        }
        return metadataMap;
    }

    public Map<String, Object> getIngestMetadata() {
        return this.ingestMetadata;
    }

    public Map<String, Object> getSourceAndMetadata() {
        return this.sourceAndMetadata;
    }

    private static <K, V> Map<K, V> deepCopyMap(Map<K, V> source) {
        return (Map)IngestDocument.deepCopy(source);
    }

    private static Object deepCopy(Object value) {
        if (value instanceof Map) {
            Map mapValue = (Map)value;
            HashMap copy = new HashMap(mapValue.size());
            for (Map.Entry entry : mapValue.entrySet()) {
                copy.put(entry.getKey(), IngestDocument.deepCopy(entry.getValue()));
            }
            return copy;
        }
        if (value instanceof List) {
            List listValue = (List)value;
            ArrayList<Object> copy = new ArrayList<Object>(listValue.size());
            for (Object itemValue : listValue) {
                copy.add(IngestDocument.deepCopy(itemValue));
            }
            return copy;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return Arrays.copyOf(bytes, bytes.length);
        }
        if (value == null || value instanceof String || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Boolean) {
            return value;
        }
        throw new IllegalArgumentException("unexpected value type [" + value.getClass() + "]");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IngestDocument other = (IngestDocument)obj;
        return Objects.equals(this.sourceAndMetadata, other.sourceAndMetadata) && Objects.equals(this.ingestMetadata, other.ingestMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.sourceAndMetadata, this.ingestMetadata);
    }

    public String toString() {
        return "IngestDocument{ sourceAndMetadata=" + this.sourceAndMetadata + ", ingestMetadata=" + this.ingestMetadata + '}';
    }

    private class FieldPath {
        private final String[] pathElements;
        private final Object initialContext;

        private FieldPath(String path) {
            String newPath;
            if (Strings.isEmpty(path)) {
                throw new IllegalArgumentException("path cannot be null nor empty");
            }
            if (path.startsWith(IngestDocument.INGEST_KEY_PREFIX)) {
                this.initialContext = IngestDocument.this.ingestMetadata;
                newPath = path.substring(IngestDocument.INGEST_KEY_PREFIX.length(), path.length());
            } else {
                this.initialContext = IngestDocument.this.sourceAndMetadata;
                newPath = path.startsWith(IngestDocument.SOURCE_PREFIX) ? path.substring(IngestDocument.SOURCE_PREFIX.length(), path.length()) : path;
            }
            this.pathElements = newPath.split("\\.");
            if (this.pathElements.length == 1 && this.pathElements[0].isEmpty()) {
                throw new IllegalArgumentException("path [" + path + "] is not valid");
            }
        }
    }

    public static enum MetaData {
        INDEX("_index"),
        TYPE("_type"),
        ID("_id"),
        ROUTING("_routing"),
        PARENT("_parent"),
        TIMESTAMP("_timestamp"),
        TTL("_ttl");

        private final String fieldName;

        private MetaData(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }
}

