/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.storedscripts.GetStoredScriptRequest;
import org.elasticsearch.action.admin.cluster.storedscripts.GetStoredScriptResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;

public class RestGetStoredScriptAction
extends BaseRestHandler {
    @Inject
    public RestGetStoredScriptAction(Settings settings, RestController controller) {
        this(settings, controller, true);
    }

    protected RestGetStoredScriptAction(Settings settings, RestController controller, boolean registerDefaultHandlers) {
        super(settings);
        if (registerDefaultHandlers) {
            controller.registerHandler(RestRequest.Method.GET, "/_scripts/{lang}/{id}", this);
        }
    }

    protected String getScriptFieldName() {
        return "script";
    }

    protected String getScriptLang(RestRequest request) {
        return request.param("lang");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        final GetStoredScriptRequest getRequest = new GetStoredScriptRequest(this.getScriptLang(request), request.param("id"));
        return channel -> client.admin().cluster().getStoredScript(getRequest, (ActionListener<GetStoredScriptResponse>)new RestBuilderListener<GetStoredScriptResponse>(channel){

            @Override
            public RestResponse buildResponse(GetStoredScriptResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                builder.field("lang", getRequest.lang());
                builder.field("_id", getRequest.id());
                boolean found = response.getStoredScript() != null;
                builder.field("found", found);
                RestStatus status = RestStatus.NOT_FOUND;
                if (found) {
                    builder.field(RestGetStoredScriptAction.this.getScriptFieldName(), response.getStoredScript());
                    status = RestStatus.OK;
                }
                builder.endObject();
                return new BytesRestResponse(status, builder);
            }
        });
    }

    private static final class Fields {
        private static final String SCRIPT = "script";
        private static final String LANG = "lang";
        private static final String _ID = "_id";
        private static final String FOUND = "found";

        private Fields() {
        }
    }
}

