/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public abstract class AbstractAggregationBuilder<AB extends AbstractAggregationBuilder<AB>>
extends AggregationBuilder {
    protected Map<String, Object> metaData;

    public AbstractAggregationBuilder(String name, InternalAggregation.Type type) {
        super(name, type);
    }

    protected AbstractAggregationBuilder(StreamInput in, InternalAggregation.Type type) throws IOException {
        super(in.readString(), type);
        this.factoriesBuilder = new AggregatorFactories.Builder(in);
        this.metaData = in.readMap();
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        this.factoriesBuilder.writeTo(out);
        out.writeMap(this.metaData);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    public AB subAggregation(AggregationBuilder aggregation) {
        if (aggregation == null) {
            throw new IllegalArgumentException("[aggregation] must not be null: [" + this.name + "]");
        }
        this.factoriesBuilder.addAggregator(aggregation);
        return (AB)this;
    }

    public AB subAggregation(PipelineAggregationBuilder aggregation) {
        if (aggregation == null) {
            throw new IllegalArgumentException("[aggregation] must not be null: [" + this.name + "]");
        }
        this.factoriesBuilder.addPipelineAggregator(aggregation);
        return (AB)this;
    }

    public AB subAggregations(AggregatorFactories.Builder subFactories) {
        if (subFactories == null) {
            throw new IllegalArgumentException("[subFactories] must not be null: [" + this.name + "]");
        }
        this.factoriesBuilder = subFactories;
        return (AB)this;
    }

    public AB setMetaData(Map<String, Object> metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException("[metaData] must not be null: [" + this.name + "]");
        }
        this.metaData = metaData;
        return (AB)this;
    }

    public String getType() {
        return this.type.name();
    }

    @Override
    public final AggregatorFactory<?> build(AggregationContext context, AggregatorFactory<?> parent) throws IOException {
        AggregatorFactory<?> factory = this.doBuild(context, parent, this.factoriesBuilder);
        return factory;
    }

    protected abstract AggregatorFactory<?> doBuild(AggregationContext var1, AggregatorFactory<?> var2, AggregatorFactories.Builder var3) throws IOException;

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        if (this.metaData != null) {
            builder.field("meta", this.metaData);
        }
        builder.field(this.type.name());
        this.internalXContent(builder, params);
        if (this.factoriesBuilder != null && this.factoriesBuilder.count() > 0) {
            builder.field("aggregations");
            this.factoriesBuilder.toXContent(builder, params);
        }
        return builder.endObject();
    }

    protected abstract XContentBuilder internalXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public int hashCode() {
        return Objects.hash(this.factoriesBuilder, this.metaData, this.name, this.type, this.doHashCode());
    }

    protected abstract int doHashCode();

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractAggregationBuilder other = (AbstractAggregationBuilder)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.metaData, other.metaData)) {
            return false;
        }
        if (!Objects.equals(this.factoriesBuilder, other.factoriesBuilder)) {
            return false;
        }
        return this.doEquals(obj);
    }

    protected abstract boolean doEquals(Object var1);
}

