/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.range.Range;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class InternalRange<B extends Bucket, R extends InternalRange<B, R>>
extends InternalMultiBucketAggregation<R, B>
implements Range {
    static final Factory FACTORY = new Factory();
    private List<B> ranges;
    protected DocValueFormat format;
    protected boolean keyed;

    public InternalRange(String name, List<B> ranges, DocValueFormat format, boolean keyed, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.ranges = ranges;
        this.format = format;
        this.keyed = keyed;
    }

    public InternalRange(StreamInput in) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.keyed = in.readBoolean();
        int size = in.readVInt();
        ArrayList<B> ranges = new ArrayList<B>(size);
        for (int i = 0; i < size; ++i) {
            String key = in.readOptionalString();
            ranges.add(this.getFactory().createBucket(key, in.readDouble(), in.readDouble(), in.readVLong(), InternalAggregations.readAggregations(in), this.keyed, this.format));
        }
        this.ranges = ranges;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeBoolean(this.keyed);
        out.writeVInt(this.ranges.size());
        for (Bucket bucket : this.ranges) {
            out.writeOptionalString(bucket.key);
            out.writeDouble(bucket.from);
            out.writeDouble(bucket.to);
            out.writeVLong(bucket.docCount);
            bucket.aggregations.writeTo(out);
        }
    }

    @Override
    public String getWriteableName() {
        return "range";
    }

    public List<B> getBuckets() {
        return this.ranges;
    }

    public Factory<B, R> getFactory() {
        return FACTORY;
    }

    @Override
    public R create(List<B> buckets) {
        return (R)this.getFactory().create(buckets, this);
    }

    @Override
    public B createBucket(InternalAggregations aggregations, B prototype) {
        return this.getFactory().createBucket(aggregations, prototype);
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        List[] rangeList = new List[this.ranges.size()];
        for (int i = 0; i < rangeList.length; ++i) {
            rangeList[i] = new ArrayList();
        }
        for (InternalAggregation aggregation : aggregations) {
            InternalRange ranges = (InternalRange)aggregation;
            int i = 0;
            for (Bucket range : ranges.ranges) {
                rangeList[i++].add(range);
            }
        }
        ArrayList<Bucket> ranges = new ArrayList<Bucket>();
        for (int i = 0; i < this.ranges.size(); ++i) {
            ranges.add(((Bucket)rangeList[i].get(0)).reduce(rangeList[i], reduceContext));
        }
        return this.getFactory().create(this.name, ranges, this.format, this.keyed, this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject("buckets");
        } else {
            builder.startArray("buckets");
        }
        for (Bucket range : this.ranges) {
            range.toXContent(builder, params);
        }
        if (this.keyed) {
            builder.endObject();
        } else {
            builder.endArray();
        }
        return builder;
    }

    public static class Factory<B extends Bucket, R extends InternalRange<B, R>> {
        public InternalAggregation.Type type() {
            return RangeAggregationBuilder.TYPE;
        }

        public ValuesSourceType getValueSourceType() {
            return ValuesSourceType.NUMERIC;
        }

        public ValueType getValueType() {
            return ValueType.NUMERIC;
        }

        public R create(String name, List<B> ranges, DocValueFormat formatter, boolean keyed, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
            return (R)new InternalRange(name, ranges, formatter, keyed, pipelineAggregators, metaData);
        }

        public B createBucket(String key, double from, double to, long docCount, InternalAggregations aggregations, boolean keyed, DocValueFormat formatter) {
            return (B)new Bucket(key, from, to, docCount, aggregations, keyed, formatter);
        }

        public R create(List<B> ranges, R prototype) {
            return (R)new InternalRange(((InternalRange)prototype).name, ranges, ((InternalRange)prototype).format, ((InternalRange)prototype).keyed, ((InternalAggregation)prototype).pipelineAggregators(), ((InternalRange)prototype).metaData);
        }

        public B createBucket(InternalAggregations aggregations, B prototype) {
            return (B)new Bucket(((Bucket)prototype).getKey(), ((Bucket)prototype).from, ((Bucket)prototype).to, ((Bucket)prototype).getDocCount(), aggregations, ((Bucket)prototype).keyed, ((Bucket)prototype).format);
        }
    }

    public static class Bucket
    extends InternalMultiBucketAggregation.InternalBucket
    implements Range.Bucket {
        protected final transient boolean keyed;
        protected final transient DocValueFormat format;
        protected double from;
        protected double to;
        private long docCount;
        InternalAggregations aggregations;
        private String key;

        public Bucket(boolean keyed, DocValueFormat formatter) {
            this.keyed = keyed;
            this.format = formatter;
        }

        public Bucket(String key, double from, double to, long docCount, InternalAggregations aggregations, boolean keyed, DocValueFormat formatter) {
            this(keyed, formatter);
            this.key = key != null ? key : this.generateKey(from, to, formatter);
            this.from = from;
            this.to = to;
            this.docCount = docCount;
            this.aggregations = aggregations;
        }

        @Override
        public String getKey() {
            return this.getKeyAsString();
        }

        @Override
        public String getKeyAsString() {
            return this.key;
        }

        @Override
        public Object getFrom() {
            return this.from;
        }

        @Override
        public Object getTo() {
            return this.to;
        }

        public boolean getKeyed() {
            return this.keyed;
        }

        public DocValueFormat getFormat() {
            return this.format;
        }

        @Override
        public String getFromAsString() {
            if (Double.isInfinite(this.from)) {
                return null;
            }
            return this.format.format(this.from);
        }

        @Override
        public String getToAsString() {
            if (Double.isInfinite(this.to)) {
                return null;
            }
            return this.format.format(this.to);
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        protected Factory<? extends Bucket, ?> getFactory() {
            return FACTORY;
        }

        Bucket reduce(List<Bucket> ranges, InternalAggregation.ReduceContext context) {
            long docCount = 0L;
            ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(ranges.size());
            for (Bucket range : ranges) {
                docCount += range.docCount;
                aggregationsList.add(range.aggregations);
            }
            InternalAggregations aggs = InternalAggregations.reduce(aggregationsList, context);
            return this.getFactory().createBucket(this.key, this.from, this.to, docCount, aggs, this.keyed, this.format);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.keyed) {
                builder.startObject(this.key);
            } else {
                builder.startObject();
                builder.field("key", this.key);
            }
            if (!Double.isInfinite(this.from)) {
                builder.field("from", this.from);
                if (this.format != DocValueFormat.RAW) {
                    builder.field("from_as_string", this.format.format(this.from));
                }
            }
            if (!Double.isInfinite(this.to)) {
                builder.field("to", this.to);
                if (this.format != DocValueFormat.RAW) {
                    builder.field("to_as_string", this.format.format(this.to));
                }
            }
            builder.field("doc_count", this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        protected String generateKey(double from, double to, DocValueFormat formatter) {
            StringBuilder sb = new StringBuilder();
            sb.append(Double.isInfinite(from) ? "*" : formatter.format(from));
            sb.append("-");
            sb.append(Double.isInfinite(to) ? "*" : formatter.format(to));
            return sb.toString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }
    }
}

