/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fieldvisitor.CustomFieldsVisitor;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.StoredFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.InnerHitsFetchSubPhase;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.InternalSearchHitField;
import org.elasticsearch.search.internal.InternalSearchHits;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SourceLookup;
import org.elasticsearch.tasks.TaskCancelledException;

public class FetchPhase
implements SearchPhase {
    private final FetchSubPhase[] fetchSubPhases;

    public FetchPhase(List<FetchSubPhase> fetchSubPhases) {
        this.fetchSubPhases = fetchSubPhases.toArray(new FetchSubPhase[fetchSubPhases.size() + 1]);
        this.fetchSubPhases[fetchSubPhases.size()] = new InnerHitsFetchSubPhase(this);
    }

    @Override
    public void preProcess(SearchContext context) {
    }

    @Override
    public void execute(SearchContext context) {
        FieldsVisitor fieldsVisitor;
        HashSet<String> fieldNames = null;
        ArrayList<String> fieldNamePatterns = null;
        StoredFieldsContext storedFieldsContext = context.storedFieldsContext();
        if (storedFieldsContext == null) {
            if (!context.hasScriptFields() && !context.hasFetchSourceContext()) {
                context.fetchSourceContext(new FetchSourceContext(true));
            }
            fieldsVisitor = new FieldsVisitor(context.sourceRequested());
        } else if (!storedFieldsContext.fetchFields()) {
            fieldsVisitor = null;
        } else {
            for (String fieldName : context.storedFieldsContext().fieldNames()) {
                if (fieldName.equals("_source")) {
                    FetchSourceContext fetchSourceContext = context.hasFetchSourceContext() ? context.fetchSourceContext() : FetchSourceContext.FETCH_SOURCE;
                    context.fetchSourceContext(new FetchSourceContext(true, fetchSourceContext.includes(), fetchSourceContext.excludes()));
                    continue;
                }
                if (Regex.isSimpleMatchPattern(fieldName)) {
                    if (fieldNamePatterns == null) {
                        fieldNamePatterns = new ArrayList<String>();
                    }
                    fieldNamePatterns.add(fieldName);
                    continue;
                }
                MappedFieldType fieldType = context.smartNameFieldType(fieldName);
                if (fieldType == null && context.getObjectMapper(fieldName) != null) {
                    throw new IllegalArgumentException("field [" + fieldName + "] isn't a leaf field");
                }
                if (fieldNames == null) {
                    fieldNames = new HashSet<String>();
                }
                fieldNames.add(fieldName);
            }
            boolean loadSource = context.sourceRequested();
            fieldsVisitor = fieldNames == null && fieldNamePatterns == null ? new FieldsVisitor(loadSource) : new CustomFieldsVisitor(fieldNames == null ? Collections.emptySet() : fieldNames, fieldNamePatterns == null ? Collections.emptyList() : fieldNamePatterns, loadSource);
        }
        InternalSearchHit[] hits = new InternalSearchHit[context.docIdsToLoadSize()];
        FetchSubPhase.HitContext hitContext = new FetchSubPhase.HitContext();
        for (int index = 0; index < context.docIdsToLoadSize(); ++index) {
            InternalSearchHit searchHit;
            if (context.isCancelled()) {
                throw new TaskCancelledException("cancelled");
            }
            int docId = context.docIdsToLoad()[context.docIdsToLoadFrom() + index];
            int readerIndex = ReaderUtil.subIndex((int)docId, (List)context.searcher().getIndexReader().leaves());
            LeafReaderContext subReaderContext = (LeafReaderContext)context.searcher().getIndexReader().leaves().get(readerIndex);
            int subDocId = docId - subReaderContext.docBase;
            try {
                int rootDocId = this.findRootDocumentIfNested(context, subReaderContext, subDocId);
                searchHit = rootDocId != -1 ? this.createNestedSearchHit(context, docId, subDocId, rootDocId, fieldNames, fieldNamePatterns, subReaderContext) : this.createSearchHit(context, fieldsVisitor, docId, subDocId, subReaderContext);
            }
            catch (IOException e) {
                throw ExceptionsHelper.convertToElastic(e);
            }
            hits[index] = searchHit;
            hitContext.reset(searchHit, subReaderContext, subDocId, context.searcher());
            for (FetchSubPhase fetchSubPhase : this.fetchSubPhases) {
                fetchSubPhase.hitExecute(context, hitContext);
            }
        }
        for (FetchSubPhase fetchSubPhase : this.fetchSubPhases) {
            fetchSubPhase.hitsExecute(context, hits);
        }
        context.fetchResult().hits(new InternalSearchHits(hits, context.queryResult().topDocs().totalHits, context.queryResult().topDocs().getMaxScore()));
    }

    private int findRootDocumentIfNested(SearchContext context, LeafReaderContext subReaderContext, int subDocId) throws IOException {
        BitSet bits;
        if (context.mapperService().hasNested() && !(bits = context.bitsetFilterCache().getBitSetProducer(Queries.newNonNestedFilter()).getBitSet(subReaderContext)).get(subDocId)) {
            return bits.nextSetBit(subDocId);
        }
        return -1;
    }

    private InternalSearchHit createSearchHit(SearchContext context, FieldsVisitor fieldsVisitor, int docId, int subDocId, LeafReaderContext subReaderContext) {
        DocumentMapper documentMapper;
        if (fieldsVisitor == null) {
            return new InternalSearchHit(docId);
        }
        this.loadStoredFields(context, subReaderContext, fieldsVisitor, subDocId);
        fieldsVisitor.postProcess(context.mapperService());
        HashMap<String, SearchHitField> searchFields = null;
        if (!fieldsVisitor.fields().isEmpty()) {
            searchFields = new HashMap<String, SearchHitField>(fieldsVisitor.fields().size());
            for (Map.Entry<String, List<Object>> entry : fieldsVisitor.fields().entrySet()) {
                searchFields.put(entry.getKey(), new InternalSearchHitField(entry.getKey(), entry.getValue()));
            }
        }
        Text typeText = (documentMapper = context.mapperService().documentMapper(fieldsVisitor.uid().type())) == null ? new Text(fieldsVisitor.uid().type()) : documentMapper.typeText();
        InternalSearchHit searchHit = new InternalSearchHit(docId, fieldsVisitor.uid().id(), typeText, searchFields);
        SourceLookup sourceLookup = context.lookup().source();
        sourceLookup.setSegmentAndDocument(subReaderContext, subDocId);
        if (fieldsVisitor.source() != null) {
            sourceLookup.setSource(fieldsVisitor.source());
        }
        return searchHit;
    }

    private InternalSearchHit createNestedSearchHit(SearchContext context, int nestedTopDocId, int nestedSubDocId, int rootSubDocId, Set<String> fieldNames, List<String> fieldNamePatterns, LeafReaderContext subReaderContext) throws IOException {
        FieldsVisitor rootFieldsVisitor = new FieldsVisitor(context.sourceRequested() || context.highlight() != null);
        this.loadStoredFields(context, subReaderContext, rootFieldsVisitor, rootSubDocId);
        rootFieldsVisitor.postProcess(context.mapperService());
        Map<String, SearchHitField> searchFields = this.getSearchFields(context, nestedSubDocId, fieldNames, fieldNamePatterns, subReaderContext);
        DocumentMapper documentMapper = context.mapperService().documentMapper(rootFieldsVisitor.uid().type());
        SourceLookup sourceLookup = context.lookup().source();
        sourceLookup.setSegmentAndDocument(subReaderContext, nestedSubDocId);
        ObjectMapper nestedObjectMapper = documentMapper.findNestedObjectMapper(nestedSubDocId, context, subReaderContext);
        assert (nestedObjectMapper != null);
        InternalSearchHit.InternalNestedIdentity nestedIdentity = this.getInternalNestedIdentity(context, nestedSubDocId, subReaderContext, documentMapper, nestedObjectMapper);
        BytesReference source = rootFieldsVisitor.source();
        if (source != null) {
            HashMap<String, Object> nestedSourceAsMap;
            Tuple<XContentType, Map<String, Object>> tuple = XContentHelper.convertToMap(source, true);
            Map sourceAsMap = tuple.v2();
            HashMap<String, Object> current = nestedSourceAsMap = new HashMap<String, Object>();
            for (SearchHit.NestedIdentity nested = nestedIdentity; nested != null; nested = nested.getChild()) {
                List<Map> nestedParsedSource;
                String nestedPath = nested.getField().string();
                current.put(nestedPath, new HashMap());
                Object extractedValue = XContentMapValues.extractValue(nestedPath, sourceAsMap);
                if (extractedValue instanceof List) {
                    nestedParsedSource = (List<Map>)extractedValue;
                } else if (extractedValue instanceof Map) {
                    nestedParsedSource = Collections.singletonList((Map)extractedValue);
                } else {
                    throw new IllegalStateException("extracted source isn't an object or an array");
                }
                sourceAsMap = nestedParsedSource.get(nested.getOffset());
                if (nested.getChild() == null) {
                    current.put(nestedPath, sourceAsMap);
                    continue;
                }
                HashMap next = new HashMap();
                current.put(nestedPath, next);
                current = next;
            }
            context.lookup().source().setSource(nestedSourceAsMap);
            XContentType contentType = tuple.v1();
            BytesReference nestedSource = XContentFactory.contentBuilder(contentType).map(sourceAsMap).bytes();
            context.lookup().source().setSource(nestedSource);
            context.lookup().source().setSourceContentType(contentType);
        }
        return new InternalSearchHit(nestedTopDocId, rootFieldsVisitor.uid().id(), documentMapper.typeText(), nestedIdentity, searchFields);
    }

    private Map<String, SearchHitField> getSearchFields(SearchContext context, int nestedSubDocId, Set<String> fieldNames, List<String> fieldNamePatterns, LeafReaderContext subReaderContext) {
        CustomFieldsVisitor nestedFieldsVisitor;
        HashMap<String, InternalSearchHitField> searchFields = null;
        if (context.hasStoredFields() && !context.storedFieldsContext().fieldNames().isEmpty() && (nestedFieldsVisitor = new CustomFieldsVisitor(fieldNames == null ? Collections.emptySet() : fieldNames, fieldNamePatterns == null ? Collections.emptyList() : fieldNamePatterns, false)) != null) {
            this.loadStoredFields(context, subReaderContext, nestedFieldsVisitor, nestedSubDocId);
            nestedFieldsVisitor.postProcess(context.mapperService());
            if (!nestedFieldsVisitor.fields().isEmpty()) {
                searchFields = new HashMap<String, InternalSearchHitField>(nestedFieldsVisitor.fields().size());
                for (Map.Entry<String, List<Object>> entry : nestedFieldsVisitor.fields().entrySet()) {
                    searchFields.put(entry.getKey(), new InternalSearchHitField(entry.getKey(), entry.getValue()));
                }
            }
        }
        return searchFields;
    }

    private InternalSearchHit.InternalNestedIdentity getInternalNestedIdentity(SearchContext context, int nestedSubDocId, LeafReaderContext subReaderContext, DocumentMapper documentMapper, ObjectMapper nestedObjectMapper) throws IOException {
        int currentParent = nestedSubDocId;
        ObjectMapper current = nestedObjectMapper;
        String originalName = nestedObjectMapper.name();
        InternalSearchHit.InternalNestedIdentity nestedIdentity = null;
        do {
            Query parentFilter;
            ObjectMapper nestedParentObjectMapper;
            if ((nestedParentObjectMapper = documentMapper.findParentObjectMapper(current)) != null) {
                if (!nestedParentObjectMapper.nested().isNested()) {
                    current = nestedParentObjectMapper;
                    continue;
                }
                parentFilter = nestedParentObjectMapper.nestedTypeFilter();
            } else {
                parentFilter = Queries.newNonNestedFilter();
            }
            Query childFilter = nestedObjectMapper.nestedTypeFilter();
            if (childFilter == null) {
                current = nestedParentObjectMapper;
                continue;
            }
            Weight childWeight = context.searcher().createNormalizedWeight(childFilter, false);
            Scorer childScorer = childWeight.scorer(subReaderContext);
            if (childScorer == null) {
                current = nestedParentObjectMapper;
                continue;
            }
            DocIdSetIterator childIter = childScorer.iterator();
            BitSet parentBits = context.bitsetFilterCache().getBitSetProducer(parentFilter).getBitSet(subReaderContext);
            int offset = 0;
            int nextParent = parentBits.nextSetBit(currentParent);
            int docId = childIter.advance(currentParent + 1);
            while (docId < nextParent && docId != Integer.MAX_VALUE) {
                ++offset;
                docId = childIter.nextDoc();
            }
            currentParent = nextParent;
            nestedObjectMapper = nestedParentObjectMapper;
            current = nestedObjectMapper;
            int currentPrefix = current == null ? 0 : current.name().length() + 1;
            nestedIdentity = new InternalSearchHit.InternalNestedIdentity(originalName.substring(currentPrefix), offset, nestedIdentity);
            if (current == null) continue;
            originalName = current.name();
        } while (current != null);
        return nestedIdentity;
    }

    private void loadStoredFields(SearchContext searchContext, LeafReaderContext readerContext, FieldsVisitor fieldVisitor, int docId) {
        fieldVisitor.reset();
        try {
            readerContext.reader().document(docId, (StoredFieldVisitor)fieldVisitor);
        }
        catch (IOException e) {
            throw new FetchPhaseExecutionException(searchContext, "Failed to fetch doc id [" + docId + "]", (Throwable)e);
        }
    }
}

