/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LatLonPointSortField;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.search.SortField;

public class LatLonDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public LatLonDocValuesField(String name, double latitude, double longitude) {
        super(name, TYPE);
        this.setLocationValue(latitude, longitude);
    }

    public void setLocationValue(double latitude, double longitude) {
        int latitudeEncoded = GeoEncodingUtils.encodeLatitude((double)latitude);
        int longitudeEncoded = GeoEncodingUtils.encodeLongitude((double)longitude);
        this.fieldsData = (long)latitudeEncoded << 32 | (long)longitudeEncoded & 0xFFFFFFFFL;
    }

    static void checkCompatible(FieldInfo fieldInfo) {
        if (fieldInfo.getDocValuesType() != DocValuesType.NONE && fieldInfo.getDocValuesType() != TYPE.docValuesType()) {
            throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with docValuesType=" + fieldInfo.getDocValuesType() + " but this type has docValuesType=" + TYPE.docValuesType() + ", is the field really a LatLonDocValuesField?");
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(((Object)((Object)this)).getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        long currentValue = (Long)this.fieldsData;
        result.append(GeoEncodingUtils.decodeLatitude((int)((int)(currentValue >> 32))));
        result.append(',');
        result.append(GeoEncodingUtils.decodeLongitude((int)((int)(currentValue & 0xFFFFFFFFFFFFFFFFL))));
        result.append('>');
        return result.toString();
    }

    public static SortField newDistanceSort(String field, double latitude, double longitude) {
        return new LatLonPointSortField(field, latitude, longitude);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        TYPE.freeze();
    }
}

