/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.fst;

import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.search.suggest.fst.BytesRefSorter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.OfflineSorter;

public class ExternalRefSorter
implements BytesRefSorter,
Closeable {
    private final OfflineSorter sorter;
    private OfflineSorter.ByteSequencesWriter writer;
    private IndexOutput input;
    private String sortedFileName;

    public ExternalRefSorter(OfflineSorter sorter) throws IOException {
        this.sorter = sorter;
        this.input = sorter.getDirectory().createTempOutput(sorter.getTempFileNamePrefix(), "RefSorterRaw", IOContext.DEFAULT);
        this.writer = new OfflineSorter.ByteSequencesWriter(this.input);
    }

    @Override
    public void add(BytesRef utf8) throws IOException {
        if (this.writer == null) {
            throw new IllegalStateException();
        }
        this.writer.write(utf8);
    }

    @Override
    public BytesRefIterator iterator() throws IOException {
        block5: {
            block6: {
                block4: {
                    if (this.sortedFileName != null) break block5;
                    this.closeWriter();
                    boolean success = false;
                    try {
                        this.sortedFileName = this.sorter.sort(this.input.getName());
                        success = true;
                        if (!success) break block4;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            this.sorter.getDirectory().deleteFile(this.input.getName());
                        } else {
                            IOUtils.deleteFilesIgnoringExceptions((Directory)this.sorter.getDirectory(), (String[])new String[]{this.input.getName()});
                        }
                        throw throwable;
                    }
                    this.sorter.getDirectory().deleteFile(this.input.getName());
                    break block6;
                }
                IOUtils.deleteFilesIgnoringExceptions((Directory)this.sorter.getDirectory(), (String[])new String[]{this.input.getName()});
            }
            this.input = null;
        }
        return new ByteSequenceIterator(new OfflineSorter.ByteSequencesReader(this.sorter.getDirectory().openChecksumInput(this.sortedFileName, IOContext.READONCE), this.sortedFileName));
    }

    private void closeWriter() throws IOException {
        if (this.writer != null) {
            CodecUtil.writeFooter((IndexOutput)this.input);
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.closeWriter();
        }
        catch (Throwable throwable) {
            IOUtils.deleteFilesIgnoringExceptions((Directory)this.sorter.getDirectory(), (String[])new String[]{this.input == null ? null : this.input.getName(), this.sortedFileName});
            throw throwable;
        }
        IOUtils.deleteFilesIgnoringExceptions((Directory)this.sorter.getDirectory(), (String[])new String[]{this.input == null ? null : this.input.getName(), this.sortedFileName});
    }

    @Override
    public Comparator<BytesRef> getComparator() {
        return this.sorter.getComparator();
    }

    class ByteSequenceIterator
    implements BytesRefIterator {
        private final OfflineSorter.ByteSequencesReader reader;
        private BytesRef scratch;

        public ByteSequenceIterator(OfflineSorter.ByteSequencesReader reader) {
            this.reader = reader;
        }

        public BytesRef next() throws IOException {
            BytesRef bytesRef;
            block4: {
                boolean success = false;
                try {
                    this.scratch = this.reader.next();
                    if (this.scratch == null) {
                        this.reader.close();
                    }
                    success = true;
                    bytesRef = this.scratch;
                    if (success) break block4;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.reader});
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.reader});
            }
            return bytesRef;
        }
    }
}

