/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.FilteringTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.uhighlight.FieldOffsetStrategy;
import org.apache.lucene.search.uhighlight.MultiTermHighlighting;
import org.apache.lucene.search.uhighlight.MultiValueTokenStream;
import org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.apache.lucene.search.uhighlight.PhraseHelper;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;

public class AnalysisOffsetStrategy
extends FieldOffsetStrategy {
    private static final BytesRef[] ZERO_LEN_BYTES_REF_ARRAY = new BytesRef[0];
    private final Analyzer analyzer;
    private final MemoryIndex memoryIndex;
    private final LeafReader leafReader;
    private final CharacterRunAutomaton preMemIndexFilterAutomaton;

    public AnalysisOffsetStrategy(String field, BytesRef[] extractedTerms, PhraseHelper phraseHelper, CharacterRunAutomaton[] automata, Analyzer analyzer) {
        super(field, extractedTerms, phraseHelper, automata);
        this.analyzer = analyzer;
        this.automata = automata;
        if (this.terms.length > 0 && !this.strictPhrases.hasPositionSensitivity()) {
            this.automata = AnalysisOffsetStrategy.convertTermsToAutomata(this.terms, automata);
            this.terms = ZERO_LEN_BYTES_REF_ARRAY;
        }
        if (this.terms.length > 0 || this.strictPhrases.willRewrite()) {
            boolean storePayloads = this.strictPhrases.hasPositionSensitivity();
            this.memoryIndex = new MemoryIndex(true, storePayloads);
            this.leafReader = (LeafReader)this.memoryIndex.createSearcher().getIndexReader();
            this.preMemIndexFilterAutomaton = AnalysisOffsetStrategy.buildCombinedAutomaton(field, this.terms, this.automata, this.strictPhrases);
        } else {
            this.memoryIndex = null;
            this.leafReader = null;
            this.preMemIndexFilterAutomaton = null;
        }
    }

    @Override
    public UnifiedHighlighter.OffsetSource getOffsetSource() {
        return UnifiedHighlighter.OffsetSource.ANALYSIS;
    }

    @Override
    public List<OffsetsEnum> getOffsetsEnums(IndexReader reader, int docId, String content) throws IOException {
        TokenStream tokenStream = this.tokenStream(content);
        if (this.memoryIndex != null) {
            this.memoryIndex.reset();
            if (this.preMemIndexFilterAutomaton != null) {
                tokenStream = AnalysisOffsetStrategy.newKeepWordFilter(tokenStream, this.preMemIndexFilterAutomaton);
            }
            this.memoryIndex.addField(this.field, tokenStream);
            tokenStream = null;
            docId = 0;
            if (this.automata.length > 0) {
                Terms foundTerms = this.leafReader.terms(this.field);
                if (foundTerms == null) {
                    return Collections.emptyList();
                }
                tokenStream = MultiTermHighlighting.uninvertAndFilterTerms(foundTerms, 0, this.automata, content.length());
            }
        }
        return this.createOffsetsEnums(this.leafReader, docId, tokenStream);
    }

    protected TokenStream tokenStream(String content) throws IOException {
        return MultiValueTokenStream.wrap(this.field, this.analyzer, content, '\u0000');
    }

    private static CharacterRunAutomaton[] convertTermsToAutomata(BytesRef[] terms, CharacterRunAutomaton[] automata) {
        CharacterRunAutomaton[] newAutomata = new CharacterRunAutomaton[terms.length + automata.length];
        for (int i = 0; i < terms.length; ++i) {
            newAutomata[i] = MultiTermHighlighting.makeStringMatchAutomata(terms[i]);
        }
        System.arraycopy(automata, 0, newAutomata, terms.length, automata.length);
        return newAutomata;
    }

    private static FilteringTokenFilter newKeepWordFilter(TokenStream tokenStream, final CharacterRunAutomaton charRunAutomaton) {
        return new FilteringTokenFilter(tokenStream){
            final CharTermAttribute charAtt;
            {
                super(x0);
                this.charAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
            }

            protected boolean accept() throws IOException {
                return charRunAutomaton.run(this.charAtt.buffer(), 0, this.charAtt.length());
            }
        };
    }

    private static CharacterRunAutomaton buildCombinedAutomaton(String field, BytesRef[] terms, CharacterRunAutomaton[] automata, PhraseHelper strictPhrases) {
        final ArrayList<CharacterRunAutomaton> allAutomata = new ArrayList<CharacterRunAutomaton>();
        if (terms.length > 0) {
            allAutomata.add(new CharacterRunAutomaton(Automata.makeStringUnion(Arrays.asList(terms))));
        }
        Collections.addAll(allAutomata, automata);
        for (SpanQuery spanQuery : strictPhrases.getSpanQueries()) {
            Collections.addAll(allAutomata, MultiTermHighlighting.extractAutomata((Query)spanQuery, field, true));
        }
        if (allAutomata.size() == 1) {
            return (CharacterRunAutomaton)allAutomata.get(0);
        }
        return new CharacterRunAutomaton(Automata.makeEmpty()){

            public boolean run(char[] chars, int offset, int length) {
                for (int i = 0; i < allAutomata.size(); ++i) {
                    if (!((CharacterRunAutomaton)allAutomata.get(i)).run(chars, offset, length)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

