/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.painless.Debug;
import org.elasticsearch.painless.Executable;
import org.elasticsearch.painless.PainlessError;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.LeafSearchScript;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.search.lookup.LeafDocLookup;
import org.elasticsearch.search.lookup.LeafSearchLookup;

final class ScriptImpl
implements ExecutableScript,
LeafSearchScript {
    private final Executable executable;
    private final Map<String, Object> variables;
    private final LeafSearchLookup lookup;
    private final LeafDocLookup doc;
    private Scorer scorer;
    private Object aggregationValue;

    ScriptImpl(Executable executable, Map<String, Object> vars, LeafSearchLookup lookup) {
        this.executable = executable;
        this.lookup = lookup;
        this.variables = new HashMap<String, Object>();
        if (vars != null) {
            this.variables.putAll(vars);
        }
        if (lookup != null) {
            this.variables.putAll(lookup.asMap());
            this.doc = lookup.doc();
        } else {
            this.doc = null;
        }
    }

    public void setNextVar(String name, Object value) {
        this.variables.put(name, value);
    }

    public void setNextAggregationValue(Object value) {
        this.aggregationValue = value;
    }

    public Object run() {
        try {
            return this.executable.execute(this.variables, this.scorer, this.doc, this.aggregationValue);
        }
        catch (Debug.PainlessExplainError e) {
            throw this.convertToScriptException(e, e.getHeaders());
        }
        catch (BootstrapMethodError | Exception | OutOfMemoryError | StackOverflowError | PainlessError e) {
            throw this.convertToScriptException(e, Collections.emptyMap());
        }
    }

    private ScriptException convertToScriptException(Throwable t, Map<String, List<String>> headers) {
        ArrayList<String> scriptStack = new ArrayList<String>();
        for (StackTraceElement element : t.getStackTrace()) {
            if (WriterConstants.CLASS_NAME.equals(element.getClassName())) {
                int endOffset;
                int startOffset;
                int offset = element.getLineNumber();
                if (offset == -1) {
                    scriptStack.add("<<< unknown portion of script >>>");
                    break;
                }
                if ((startOffset = this.executable.getPreviousStatement(--offset)) == -1) {
                    assert (false);
                    startOffset = 0;
                }
                if ((endOffset = this.executable.getNextStatement(startOffset)) == -1) {
                    endOffset = this.executable.getSource().length();
                }
                String snippet = this.executable.getSource().substring(startOffset, endOffset);
                scriptStack.add(snippet);
                StringBuilder pointer = new StringBuilder();
                for (int i = startOffset; i < offset; ++i) {
                    pointer.append(' ');
                }
                pointer.append("^---- HERE");
                scriptStack.add(pointer.toString());
                break;
            }
            if (ScriptImpl.shouldFilter(element)) continue;
            scriptStack.add(element.toString());
        }
        String name = "<inline>".equals(this.executable.getName()) ? this.executable.getSource() : this.executable.getName();
        ScriptException scriptException = new ScriptException("runtime error", t, scriptStack, name, "painless");
        for (Map.Entry<String, List<String>> header : headers.entrySet()) {
            scriptException.addHeader(header.getKey(), header.getValue());
        }
        return scriptException;
    }

    private static boolean shouldFilter(StackTraceElement element) {
        return element.getClassName().startsWith("org.elasticsearch.painless.") || element.getClassName().startsWith("java.lang.invoke.") || element.getClassName().startsWith("sun.invoke.");
    }

    public double runAsDouble() {
        return ((Number)this.run()).doubleValue();
    }

    public long runAsLong() {
        return ((Number)this.run()).longValue();
    }

    public void setScorer(Scorer scorer) {
        this.scorer = scorer;
    }

    public void setDocument(int doc) {
        if (this.lookup != null) {
            this.lookup.setDocument(doc);
        }
    }

    public void setSource(Map<String, Object> source) {
        if (this.lookup != null) {
            this.lookup.source().setSource(source);
        }
    }
}

