/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.logging.ErrorTracker;
import ch.interlis.ili2c.CompilerLogEvent;
import ch.interlis.ili2c.Ili2cException;
import ch.interlis.ili2c.ModelScan;
import ch.interlis.ili2c.config.BoidEntry;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.config.FileEntry;
import ch.interlis.ili2c.generator.Gml32Generator;
import ch.interlis.ili2c.generator.Interlis1Generator;
import ch.interlis.ili2c.generator.Interlis2Generator;
import ch.interlis.ili2c.generator.XSD22Generator;
import ch.interlis.ili2c.generator.XSDGenerator;
import ch.interlis.ili2c.generator.iom.IomGenerator;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.parser.Ili1Parser;
import ch.interlis.ili2c.parser.Ili22Parser;
import ch.interlis.ili2c.parser.Ili2Parser;
import ch.interlis.ili2c.parser.MetaObjectParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;

public class Main {
    private static String version = null;

    protected static boolean hasArg(String v1, String v2, String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals(v1) || args[i].equals(v2)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static void printVersion() {
        System.err.println("INTERLIS Compiler, Version " + Main.getVersion());
        System.err.println("  Distributed by the Coordination of Geographic Information");
        System.err.println("  and Geographic Information Systems Group (COSIG), CH-3084 Wabern");
        System.err.println("  Developed by Adasys AG, CH-8005 Zurich");
        System.err.println("  Maintained by Eisenhut Informatik AG, CH-3400 Burgdorf");
        System.err.println("  See http://www.interlis.ch for information about INTERLIS");
        System.err.println("  Parts of this program have been generated by ANTLR; see http://www.antlr.org");
        System.err.println("  This product includes software developed by the");
        System.err.println("  Apache Software Foundation (http://www.apache.org/).");
    }

    protected static void printDescription() {
        System.err.println("DESCRIPTION");
        System.err.println("  Parses and compiles INTERLIS Version 2.3 data model definitions.");
        System.err.println("  Other options include conversion from INTERLIS Version 1 and back");
        System.err.println("  (option -o1) and generation of an XML-Schema, released 2001 (option -oXSD).");
    }

    protected static void printUsage(String progName) {
        System.err.println("USAGE");
        System.err.println("  " + progName + " [Options] file1.ili file2.ili ...");
    }

    protected static void printExamples(String progName) {
        System.err.println("EXAMPLES");
        System.err.println();
        System.err.println("Check whether an INTERLIS definition in \"file1.ili\" is valid:");
        System.err.println("    java -jar " + progName + " file1.ili");
        System.err.println();
        System.err.println("Check whether a definition distributed over several files is valid:");
        System.err.println("    java -jar " + progName + " file1.ili file2.ili");
        System.err.println();
        System.err.println("Generate an INTERLIS-1 definition:");
        System.err.println("    java -jar " + progName + " -o1 file1.ili file2.ili");
        System.err.println();
        System.err.println("Generate an INTERLIS-2 definition:");
        System.err.println("    java -jar " + progName + " -o2 file1.ili file2.ili");
        System.err.println();
        System.err.println("Generate a definition of the predefined MODEL INTERLIS:");
        System.err.println("    java -jar " + progName + " -o2 --with-predefined");
        System.err.println();
        System.err.println("Generate an XML-Schema:");
        System.err.println("    java -jar " + progName + " -oXSD file1.ili file2.ili");
        System.err.println();
    }

    /*
     * Exception decompiling
     */
    public static void main(String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 1306->1312)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ArrayList getIliLookupPaths(ArrayList ilifilev) {
        ArrayList<String> ilipathv = new ArrayList<String>();
        HashSet<String> seenDirs = new HashSet<String>();
        Iterator ilifilei = ilifilev.iterator();
        while (ilifilei.hasNext()) {
            String ilifile = (String)ilifilei.next();
            String parentdir = new File(ilifile).getAbsoluteFile().getParent();
            if (seenDirs.contains(parentdir)) continue;
            seenDirs.add(parentdir);
            ilipathv.add(parentdir);
        }
        String ili2cHome = Main.getIli2cHome();
        if (ili2cHome != null) {
            ilipathv.add(String.valueOf(ili2cHome) + File.separator + "standard");
        }
        return ilipathv;
    }

    public static String getIli2cHome() {
        int start;
        String classpath = System.getProperty("java.class.path");
        int index = classpath.toLowerCase().indexOf("ili2c.jar");
        if (index > (start = classpath.lastIndexOf(File.pathSeparator, index) + 1)) {
            return classpath.substring(start, index - 1);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TransferDescription runCompiler(Configuration config) {
        block62: {
            block61: {
                filev = new ArrayList<Object>();
                if (!config.isAutoCompleteModelList()) break block61;
                ilifilev = new ArrayList<String>();
                filei = config.iteratorFileEntry();
                if (true) ** GOTO lbl14
            }
            filei = config.iteratorFileEntry();
            if (true) ** GOTO lbl37
            do {
                if ((e = (FileEntry)filei.next()).getKind() != 1) continue;
                fileName = e.getFilename();
                ilifilev.add(fileName);
lbl14:
                // 3 sources

            } while (filei.hasNext());
            modeldirv = Main.getIliLookupPaths(ilifilev);
            try {
                files = ModelScan.getConfigWithFiles(modeldirv, ilifilev);
            }
            catch (Ili2cException ex) {
                EhiLogger.logError("ili-file scan failed", ex);
                return null;
            }
            if (files == null) {
                EhiLogger.logError("ili-file scan failed");
                return null;
            }
            Main.logIliFiles(files);
            filei = files.iteratorFileEntry();
            while (filei.hasNext()) {
                e = (FileEntry)filei.next();
                filev.add(e);
            }
            break block62;
            do {
                e = (FileEntry)filei.next();
                filev.add(e);
lbl37:
                // 2 sources

            } while (filei.hasNext());
        }
        desc = new TransferDescription();
        emitPredefined = config.isIncPredefModel();
        checkMetaObjs = config.isCheckMetaObjs();
        CompilerLogEvent.enableWarnings(config.isGenerateWarnings());
        boidi = config.iteratorBoidEntry();
        while (boidi.hasNext()) {
            e = (BoidEntry)boidi.next();
            desc.addMetadataMapping(e.getMetaDataUseDef(), e.getBoid());
        }
        version = 0.0;
        filei = filev.iterator();
        while (filei.hasNext()) {
            e = (FileEntry)filei.next();
            if (e.getKind() == 2) {
                if (!checkMetaObjs || MetaObjectParser.parse(desc, e.getFilename())) continue;
                return null;
            }
            streamName = e.getFilename();
            if (version == 0.0) {
                version = ModelScan.getIliFileVersion(new File(streamName));
            }
            stream = null;
            try {
                stream = new FileInputStream(streamName);
            }
            catch (Exception ex) {
                EhiLogger.logError(ex);
                return null;
            }
            tracker = null;
            try {
                block60: {
                    block59: {
                        try {
                            tracker = new ErrorTracker();
                            EhiLogger.getInstance().addListener(tracker);
                            if (version == 2.2) {
                                if (!Ili22Parser.parseIliFile(desc, streamName, stream, checkMetaObjs, 0)) {
                                    break block59;
                                }
                            } else if (version != 1.0 ? Ili2Parser.parseIliFile(desc, streamName, stream, checkMetaObjs, 0) == false : Ili1Parser.parseIliFile(desc, streamName, stream, 0) == false) break block59;
                            if (!tracker.hasSeenErrors()) break block60;
                        }
                        catch (Exception ex) {
                            EhiLogger.logError(ex);
                        }
                    }
                    var14_23 = null;
                    if (tracker != null) {
                        EhiLogger.getInstance().removeListener(tracker);
                        tracker = null;
                    }
                    try {
                        stream.close();
                        return null;
                    }
                    catch (IOException ex) {
                        EhiLogger.logError(ex);
                    }
                    return null;
                }
                var14_23 = null;
                if (tracker != null) {
                    EhiLogger.getInstance().removeListener(tracker);
                    tracker = null;
                }
            }
            catch (Throwable var15_26) {
                var14_23 = null;
                if (tracker != null) {
                    EhiLogger.getInstance().removeListener(tracker);
                    tracker = null;
                }
                ** try [egrp 4[TRYBLOCK] [7 : 516->524)] { 
lbl104:
                // 1 sources

                stream.close();
                throw var15_26;
lbl106:
                // 1 sources

                catch (IOException ex) {
                    EhiLogger.logError(ex);
                }
                throw var15_26;
            }
            ** try [egrp 4[TRYBLOCK] [7 : 516->524)] { 
lbl110:
            // 1 sources

            stream.close();
            continue;
lbl112:
            // 1 sources

            catch (IOException ex) {
                EhiLogger.logError(ex);
            }
        }
        out = null;
        switch (config.getOutputKind()) {
            case 1: {
                break;
            }
            case 2: {
                if ("-".equals(config.getOutputFile())) {
                    out = new BufferedWriter(new OutputStreamWriter(System.out));
                } else {
                    try {
                        out = new BufferedWriter(new FileWriter(config.getOutputFile()));
                    }
                    catch (IOException ex) {
                        EhiLogger.logError(ex);
                        return desc;
                    }
                }
                Interlis1Generator.generate(out, desc);
                break;
            }
            case 3: {
                if ("-".equals(config.getOutputFile())) {
                    out = new BufferedWriter(new OutputStreamWriter(System.out));
                } else {
                    try {
                        out = new BufferedWriter(new FileWriter(config.getOutputFile()));
                    }
                    catch (IOException ex) {
                        EhiLogger.logError(ex);
                        return desc;
                    }
                }
                gen = new Interlis2Generator();
                gen.generate(out, desc, emitPredefined);
                break;
            }
            case 4: {
                if ("-".equals(config.getOutputFile())) {
                    out = new BufferedWriter(new OutputStreamWriter(System.out));
                } else {
                    try {
                        out = new BufferedWriter(new FileWriter(config.getOutputFile()));
                    }
                    catch (IOException ex) {
                        EhiLogger.logError(ex);
                        return desc;
                    }
                }
                if (desc.getLastModel().getIliVersion().equals("2.2")) {
                    XSD22Generator.generate(out, desc);
                    break;
                }
                XSDGenerator.generate(out, desc);
                break;
            }
            case 5: {
                if ("-".equals(config.getOutputFile())) {
                    out = new BufferedWriter(new OutputStreamWriter(System.out));
                } else {
                    try {
                        out = new BufferedWriter(new FileWriter(config.getOutputFile()));
                    }
                    catch (IOException ex) {
                        EhiLogger.logError(ex);
                        return desc;
                    }
                }
                Interlis1Generator.generateFmt(out, desc);
                break;
            }
            case 6: {
                Gml32Generator.generate(desc, config.getOutputFile());
                break;
            }
            case 7: {
                if ("-".equals(config.getOutputFile())) {
                    out = new BufferedWriter(new OutputStreamWriter(System.out));
                } else {
                    try {
                        out = new BufferedWriter(new FileWriter(config.getOutputFile()));
                    }
                    catch (IOException ex) {
                        EhiLogger.logError(ex);
                        return desc;
                    }
                }
                IomGenerator.generate(out, desc);
                break;
            }
        }
        if (out == null) return desc;
        try {
            out.close();
            return desc;
        }
        catch (IOException ex) {
            EhiLogger.logError(ex);
        }
        return desc;
    }

    public static boolean editConfig(Configuration config) {
        ch.interlis.ili2c.gui.Main dialog = new ch.interlis.ili2c.gui.Main();
        return dialog.showDialog();
    }

    public static String getVersion() {
        if (version == null) {
            ResourceBundle resVersion = ResourceBundle.getBundle("ch.interlis.ili2c.Version");
            StringBuffer ret = new StringBuffer(20);
            ret.append(resVersion.getString("versionMajor"));
            ret.append('.');
            ret.append(resVersion.getString("versionMinor"));
            ret.append('.');
            ret.append(resVersion.getString("versionMicro"));
            ret.append('-');
            ret.append(resVersion.getString("versionDate"));
            version = ret.toString();
        }
        return version;
    }

    public static TransferDescription compileIliModels(ArrayList modelv, ArrayList modeldirv, String ilxFile) {
        Configuration config = null;
        try {
            config = ModelScan.getConfig(modeldirv, modelv);
        }
        catch (Ili2cException ex) {
            EhiLogger.logError("ili-file scan failed", ex);
            return null;
        }
        if (config == null) {
            return null;
        }
        config.setGenerateWarnings(false);
        Main.logIliFiles(config);
        if (ilxFile != null) {
            config.setOutputKind(7);
            config.setOutputFile(ilxFile);
        } else {
            config.setOutputKind(1);
        }
        TransferDescription ret = Main.runCompiler(config);
        return ret;
    }

    public static TransferDescription compileIliFiles(ArrayList filev, ArrayList modeldirv, String ilxFile) {
        Configuration config = null;
        try {
            config = ModelScan.getConfigWithFiles(modeldirv, filev);
        }
        catch (Ili2cException ex) {
            EhiLogger.logError("ili-file scan failed", ex);
            return null;
        }
        if (config == null) {
            return null;
        }
        Main.logIliFiles(config);
        config.setGenerateWarnings(false);
        if (ilxFile != null) {
            config.setOutputKind(7);
            config.setOutputFile(ilxFile);
        } else {
            config.setOutputKind(1);
        }
        TransferDescription ret = Main.runCompiler(config);
        return ret;
    }

    public static void logIliFiles(Configuration config) {
        Iterator filei = config.iteratorFileEntry();
        while (filei.hasNext()) {
            FileEntry file = (FileEntry)filei.next();
            EhiLogger.logState("ilifile <" + file.getFilename() + ">");
        }
    }
}

