/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug.impl;

import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.vm.PolyglotEngine;

public final class DebuggerInstrument
extends TruffleInstrument {
    static final String ID = "debugger";
    private TruffleInstrument.Env environment;
    private Debugger debugger;

    @Override
    protected void onCreate(TruffleInstrument.Env env) {
        this.environment = env;
        env.registerService(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Debugger getDebugger(PolyglotEngine engine, DebuggerFactory factory) {
        DebuggerInstrument instrumentImpl;
        PolyglotEngine.Instrument instrument = engine.getInstruments().get(ID);
        if (instrument == null) {
            throw new IllegalStateException("Debugger is not installed.");
        }
        instrument.setEnabled(true);
        DebuggerInstrument debuggerInstrument = instrumentImpl = instrument.lookup(DebuggerInstrument.class);
        synchronized (debuggerInstrument) {
            if (instrumentImpl.debugger == null) {
                instrumentImpl.debugger = factory.create(engine, instrumentImpl.environment);
            }
        }
        return instrumentImpl.debugger;
    }

    public static interface DebuggerFactory {
        public Debugger create(PolyglotEngine var1, TruffleInstrument.Env var2);
    }
}

