/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.builtins;

import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CallPrimitiveNode;
import org.jruby.truffle.builtins.CoreMethodNodeManager;
import org.jruby.truffle.builtins.InvokePrimitiveNode;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.UnsafeNode;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.core.numeric.FixnumLowerNodeGen;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.MissingArgumentBehavior;
import org.jruby.truffle.language.arguments.ProfileArgumentNode;
import org.jruby.truffle.language.arguments.ReadPreArgumentNode;
import org.jruby.truffle.language.arguments.ReadSelfNode;
import org.jruby.truffle.language.control.ReturnID;

public class PrimitiveNodeConstructor {
    private final Primitive annotation;
    private final NodeFactory<? extends RubyNode> factory;

    public PrimitiveNodeConstructor(Primitive annotation, NodeFactory<? extends RubyNode> factory) {
        this.annotation = annotation;
        this.factory = factory;
    }

    public int getPrimitiveArity() {
        return this.factory.getExecutionSignature().size();
    }

    public RubyNode createCallPrimitiveNode(RubyContext context, SourceSection sourceSection, ReturnID returnID) {
        int argumentsCount = this.getPrimitiveArity();
        ArrayList<RubyNode> arguments = new ArrayList<RubyNode>(argumentsCount);
        List<List<Class<?>>> signatures = this.factory.getNodeSignatures();
        assert (signatures.size() == 1);
        List<Class<?>> signature = signatures.get(0);
        if (this.annotation.needsSelf()) {
            arguments.add(this.transformArgument(new ProfileArgumentNode(new ReadSelfNode()), 0));
            --argumentsCount;
        }
        for (int n = 0; n < argumentsCount; ++n) {
            ProfileArgumentNode readArgumentNode = new ProfileArgumentNode(new ReadPreArgumentNode(n, MissingArgumentBehavior.UNDEFINED));
            arguments.add(this.transformArgument(readArgumentNode, n + 1));
        }
        if (!CoreMethodNodeManager.isSafe(context, this.annotation.unsafe())) {
            return new UnsafeNode(context, sourceSection);
        }
        if (signature.size() >= 3 && signature.get(2) == RubyNode[].class) {
            return new CallPrimitiveNode(context, sourceSection, this.factory.createNode(context, sourceSection, arguments.toArray(new RubyNode[arguments.size()])), returnID);
        }
        if (signature.size() == 1 && signature.get(0) == RubyNode[].class) {
            return new CallPrimitiveNode(context, sourceSection, this.factory.createNode(new Object[]{arguments.toArray(new RubyNode[arguments.size()])}), returnID);
        }
        if (signature.size() == 0) {
            return new CallPrimitiveNode(context, sourceSection, this.factory.createNode(new Object[0]), returnID);
        }
        if (signature.get(0) != RubyContext.class) {
            Object[] varargs = new Object[arguments.size()];
            System.arraycopy(arguments.toArray(new RubyNode[arguments.size()]), 0, varargs, 0, arguments.size());
            return new CallPrimitiveNode(context, sourceSection, this.factory.createNode(varargs), returnID);
        }
        Object[] varargs = new Object[2 + arguments.size()];
        varargs[0] = context;
        varargs[1] = sourceSection;
        System.arraycopy(arguments.toArray(new RubyNode[arguments.size()]), 0, varargs, 2, arguments.size());
        return new CallPrimitiveNode(context, sourceSection, this.factory.createNode(varargs), returnID);
    }

    public RubyNode createInvokePrimitiveNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
        assert (arguments.length == this.getPrimitiveArity());
        if (!CoreMethodNodeManager.isSafe(context, this.annotation.unsafe())) {
            return new UnsafeNode(context, sourceSection);
        }
        for (int n = 0; n < arguments.length; ++n) {
            int nthArg = this.annotation.needsSelf() ? n : n + 1;
            arguments[n] = this.transformArgument(arguments[n], nthArg);
        }
        List<List<Class<?>>> signatures = this.factory.getNodeSignatures();
        assert (signatures.size() == 1);
        List<Class<?>> signature = signatures.get(0);
        RubyNode primitiveNode = signature.get(0) == RubyContext.class ? this.factory.createNode(context, sourceSection, arguments) : this.factory.createNode(new Object[]{arguments});
        return new InvokePrimitiveNode(context, sourceSection, primitiveNode);
    }

    private RubyNode transformArgument(RubyNode argument, int n) {
        if (ArrayUtils.contains(this.annotation.lowerFixnum(), n)) {
            return FixnumLowerNodeGen.create(null, null, argument);
        }
        return argument;
    }
}

