/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.mutex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.mutex.MutexNodes;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=MutexNodes.class)
public final class MutexNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(AllocateNodeFactory.getInstance(), LockNodeFactory.getInstance(), IsLockedNodeFactory.getInstance(), IsOwnedNodeFactory.getInstance(), TryLockNodeFactory.getInstance(), UnlockNodeFactory.getInstance(), SleepNodeFactory.getInstance());
    }

    @GeneratedBy(value=MutexNodes.SleepNode.class)
    public static final class SleepNodeFactory
    implements NodeFactory<MutexNodes.SleepNode> {
        private static SleepNodeFactory sleepNodeFactoryInstance;

        private SleepNodeFactory() {
        }

        @Override
        public Class<MutexNodes.SleepNode> getNodeClass() {
            return MutexNodes.SleepNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class, RubyNode.class));
        }

        @Override
        public MutexNodes.SleepNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return SleepNodeFactory.create((RubyNode)arguments[0], (RubyNode)arguments[1]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MutexNodes.SleepNode> getInstance() {
            if (sleepNodeFactoryInstance == null) {
                sleepNodeFactoryInstance = new SleepNodeFactory();
            }
            return sleepNodeFactoryInstance;
        }

        public static MutexNodes.SleepNode create(RubyNode mutex, RubyNode duration) {
            return new SleepNodeGen(mutex, duration);
        }

        @GeneratedBy(value=MutexNodes.SleepNode.class)
        public static final class SleepNodeGen
        extends MutexNodes.SleepNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode mutex_;
            @Node.Child
            private RubyNode duration_;
            @CompilerDirectives.CompilationFinal
            private Class<?> durationType_;
            @Node.Child
            private BaseNode_ specialization_;

            private SleepNodeGen(RubyNode mutex, RubyNode duration) {
                this.mutex_ = mutex;
                this.duration_ = this.coerceDuration(duration);
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="sleep(DynamicObject, long)", value=MutexNodes.SleepNode.class)
            private static final class SleepNode_
            extends BaseNode_ {
                private final Class<?> durationImplicitType;

                SleepNode_(SleepNodeGen root, Object durationValue) {
                    super(root, 1);
                    this.durationImplicitType = RubyTypesGen.getImplicitLongClass(durationValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.durationImplicitType == ((SleepNode_)other).durationImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeLong(frameValue);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    long durationValue_;
                    DynamicObject mutexValue_;
                    try {
                        mutexValue_ = this.root.mutex_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object durationValue = this.executeDuration_(frameValue);
                        return this.getNext().executeLong_(frameValue, ex.getResult(), durationValue);
                    }
                    try {
                        if (this.durationImplicitType == Long.TYPE) {
                            durationValue_ = this.root.duration_.executeLong(frameValue);
                        } else if (this.durationImplicitType == Integer.TYPE) {
                            durationValue_ = RubyTypes.promoteToLong(this.root.duration_.executeInteger(frameValue));
                        } else {
                            Object durationValue__ = this.executeDuration_(frameValue);
                            durationValue_ = RubyTypesGen.expectImplicitLong(durationValue__, this.durationImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeLong_(frameValue, mutexValue_, ex.getResult());
                    }
                    return this.root.sleep(mutexValue_, durationValue_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object mutexValue, Object durationValue) {
                    if (mutexValue instanceof DynamicObject && RubyTypesGen.isImplicitLong(durationValue, this.durationImplicitType)) {
                        DynamicObject mutexValue_ = (DynamicObject)mutexValue;
                        long durationValue_ = RubyTypesGen.asImplicitLong(durationValue, this.durationImplicitType);
                        return this.root.sleep(mutexValue_, durationValue_);
                    }
                    return this.getNext().executeLong_(frameValue, mutexValue, durationValue);
                }

                static BaseNode_ create(SleepNodeGen root, Object durationValue) {
                    return new SleepNode_(root, durationValue);
                }
            }

            @GeneratedBy(value=MutexNodes.SleepNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SleepNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object mutexValue, Object durationValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, mutexValue, durationValue));
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    Object mutexValue_ = this.root.mutex_.execute(frameValue);
                    Object durationValue_ = this.executeDuration_(frameValue);
                    return this.getNext().executeLong_(frameValue, mutexValue_, durationValue_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object mutexValue, Object durationValue) {
                    return this.getNext().executeLong_(frameValue, mutexValue, durationValue);
                }

                static BaseNode_ create(SleepNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MutexNodes.SleepNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SleepNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object mutexValue, Object durationValue) {
                    return (Long)this.uninitialized((Frame)frameValue, mutexValue, durationValue);
                }

                static BaseNode_ create(SleepNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MutexNodes.SleepNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SleepNodeGen root;

                BaseNode_(SleepNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (SleepNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.mutex_, this.root.duration_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object mutexValue, Object durationValue) {
                    return this.executeLong_((VirtualFrame)frameValue, mutexValue, durationValue);
                }

                public abstract long executeLong_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object mutexValue_ = this.root.mutex_.execute(frameValue);
                    Object durationValue_ = this.executeDuration_(frameValue);
                    return this.executeLong_(frameValue, mutexValue_, durationValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public long executeLong(VirtualFrame frameValue) {
                    return (Long)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object mutexValue, Object durationValue) {
                    if (mutexValue instanceof DynamicObject && RubyTypesGen.isImplicitLong(durationValue)) {
                        return SleepNode_.create(this.root, durationValue);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeDuration_(Frame frameValue) {
                    Object object;
                    Class durationType_ = this.root.durationType_;
                    if (durationType_ == Integer.TYPE) {
                        return this.root.duration_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (durationType_ == Long.TYPE) {
                        return this.root.duration_.executeLong((VirtualFrame)frameValue);
                    }
                    if (durationType_ != null) return this.root.duration_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.duration_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.durationType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.durationType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.durationType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MutexNodes.UnlockNode.class)
    public static final class UnlockNodeFactory
    implements NodeFactory<MutexNodes.UnlockNode> {
        private static UnlockNodeFactory unlockNodeFactoryInstance;

        private UnlockNodeFactory() {
        }

        @Override
        public Class<MutexNodes.UnlockNode> getNodeClass() {
            return MutexNodes.UnlockNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class));
        }

        @Override
        public MutexNodes.UnlockNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return UnlockNodeFactory.create((RubyNode)arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MutexNodes.UnlockNode> getInstance() {
            if (unlockNodeFactoryInstance == null) {
                unlockNodeFactoryInstance = new UnlockNodeFactory();
            }
            return unlockNodeFactoryInstance;
        }

        public static MutexNodes.UnlockNode create(RubyNode operand) {
            return new UnlockNodeGen(operand);
        }

        @GeneratedBy(value=MutexNodes.UnlockNode.class)
        public static final class UnlockNodeGen
        extends MutexNodes.UnlockNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private UnlockNodeGen(RubyNode operand) {
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.unlock(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.operand_}, operandValue);
            }
        }
    }

    @GeneratedBy(value=MutexNodes.TryLockNode.class)
    public static final class TryLockNodeFactory
    implements NodeFactory<MutexNodes.TryLockNode> {
        private static TryLockNodeFactory tryLockNodeFactoryInstance;

        private TryLockNodeFactory() {
        }

        @Override
        public Class<MutexNodes.TryLockNode> getNodeClass() {
            return MutexNodes.TryLockNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class));
        }

        @Override
        public MutexNodes.TryLockNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return TryLockNodeFactory.create((RubyNode)arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MutexNodes.TryLockNode> getInstance() {
            if (tryLockNodeFactoryInstance == null) {
                tryLockNodeFactoryInstance = new TryLockNodeFactory();
            }
            return tryLockNodeFactoryInstance;
        }

        public static MutexNodes.TryLockNode create(RubyNode operand) {
            return new TryLockNodeGen(operand);
        }

        @GeneratedBy(value=MutexNodes.TryLockNode.class)
        public static final class TryLockNodeGen
        extends MutexNodes.TryLockNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode operand_;
            @Node.Child
            private BaseNode_ specialization_;

            private TryLockNodeGen(RubyNode operand) {
                this.operand_ = operand;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="tryLock(DynamicObject, ConditionProfile)", value=MutexNodes.TryLockNode.class)
            private static final class TryLockNode_
            extends BaseNode_ {
                private final ConditionProfile heldByCurrentThreadProfile;

                TryLockNode_(TryLockNodeGen root, ConditionProfile heldByCurrentThreadProfile) {
                    super(root, 1);
                    this.heldByCurrentThreadProfile = heldByCurrentThreadProfile;
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject operandValue_;
                    try {
                        operandValue_ = this.root.operand_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    return this.root.tryLock(operandValue_, this.heldByCurrentThreadProfile);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object operandValue) {
                    if (operandValue instanceof DynamicObject) {
                        DynamicObject operandValue_ = (DynamicObject)operandValue;
                        return this.root.tryLock(operandValue_, this.heldByCurrentThreadProfile);
                    }
                    return this.getNext().executeBoolean_(frameValue, operandValue);
                }

                static BaseNode_ create(TryLockNodeGen root, ConditionProfile heldByCurrentThreadProfile) {
                    return new TryLockNode_(root, heldByCurrentThreadProfile);
                }
            }

            @GeneratedBy(value=MutexNodes.TryLockNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(TryLockNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object operandValue) {
                    return (Boolean)this.uninitialized((Frame)frameValue, operandValue);
                }

                static BaseNode_ create(TryLockNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MutexNodes.TryLockNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected TryLockNodeGen root;

                BaseNode_(TryLockNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (TryLockNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.operand_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object operandValue) {
                    return this.executeBoolean_((VirtualFrame)frameValue, operandValue);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object operandValue_ = this.root.operand_.execute(frameValue);
                    return this.executeBoolean_(frameValue, operandValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object operandValue) {
                    if (operandValue instanceof DynamicObject) {
                        ConditionProfile heldByCurrentThreadProfile1 = ConditionProfile.createBinaryProfile();
                        return TryLockNode_.create(this.root, heldByCurrentThreadProfile1);
                    }
                    return null;
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=MutexNodes.IsOwnedNode.class)
    public static final class IsOwnedNodeFactory
    implements NodeFactory<MutexNodes.IsOwnedNode> {
        private static IsOwnedNodeFactory isOwnedNodeFactoryInstance;

        private IsOwnedNodeFactory() {
        }

        @Override
        public Class<MutexNodes.IsOwnedNode> getNodeClass() {
            return MutexNodes.IsOwnedNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class));
        }

        @Override
        public MutexNodes.IsOwnedNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return IsOwnedNodeFactory.create((RubyNode)arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MutexNodes.IsOwnedNode> getInstance() {
            if (isOwnedNodeFactoryInstance == null) {
                isOwnedNodeFactoryInstance = new IsOwnedNodeFactory();
            }
            return isOwnedNodeFactoryInstance;
        }

        public static MutexNodes.IsOwnedNode create(RubyNode operand) {
            return new IsOwnedNodeGen(operand);
        }

        @GeneratedBy(value=MutexNodes.IsOwnedNode.class)
        public static final class IsOwnedNodeGen
        extends MutexNodes.IsOwnedNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private IsOwnedNodeGen(RubyNode operand) {
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.isOwned(operandValue_);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.operand_}, operandValue);
            }
        }
    }

    @GeneratedBy(value=MutexNodes.IsLockedNode.class)
    public static final class IsLockedNodeFactory
    implements NodeFactory<MutexNodes.IsLockedNode> {
        private static IsLockedNodeFactory isLockedNodeFactoryInstance;

        private IsLockedNodeFactory() {
        }

        @Override
        public Class<MutexNodes.IsLockedNode> getNodeClass() {
            return MutexNodes.IsLockedNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class));
        }

        @Override
        public MutexNodes.IsLockedNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return IsLockedNodeFactory.create((RubyNode)arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MutexNodes.IsLockedNode> getInstance() {
            if (isLockedNodeFactoryInstance == null) {
                isLockedNodeFactoryInstance = new IsLockedNodeFactory();
            }
            return isLockedNodeFactoryInstance;
        }

        public static MutexNodes.IsLockedNode create(RubyNode operand) {
            return new IsLockedNodeGen(operand);
        }

        @GeneratedBy(value=MutexNodes.IsLockedNode.class)
        public static final class IsLockedNodeGen
        extends MutexNodes.IsLockedNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private IsLockedNodeGen(RubyNode operand) {
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.isLocked(operandValue_);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.operand_}, operandValue);
            }
        }
    }

    @GeneratedBy(value=MutexNodes.LockNode.class)
    public static final class LockNodeFactory
    implements NodeFactory<MutexNodes.LockNode> {
        private static LockNodeFactory lockNodeFactoryInstance;

        private LockNodeFactory() {
        }

        @Override
        public Class<MutexNodes.LockNode> getNodeClass() {
            return MutexNodes.LockNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class));
        }

        @Override
        public MutexNodes.LockNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return LockNodeFactory.create((RubyNode)arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MutexNodes.LockNode> getInstance() {
            if (lockNodeFactoryInstance == null) {
                lockNodeFactoryInstance = new LockNodeFactory();
            }
            return lockNodeFactoryInstance;
        }

        public static MutexNodes.LockNode create(RubyNode operand) {
            return new LockNodeGen(operand);
        }

        @GeneratedBy(value=MutexNodes.LockNode.class)
        public static final class LockNodeGen
        extends MutexNodes.LockNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private LockNodeGen(RubyNode operand) {
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.lock(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.operand_}, operandValue);
            }
        }
    }

    @GeneratedBy(value=MutexNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    implements NodeFactory<MutexNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
        }

        @Override
        public Class<MutexNodes.AllocateNode> getNodeClass() {
            return MutexNodes.AllocateNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyContext.class, SourceSection.class, RubyNode[].class));
        }

        @Override
        public MutexNodes.AllocateNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AllocateNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MutexNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static MutexNodes.AllocateNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AllocateNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MutexNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends MutexNodes.AllocateNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AllocateNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }
}

