/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.locals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubySourceSection;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.locals.WriteFrameSlotNode;
import org.jruby.truffle.language.locals.WriteFrameSlotNodeGen;

public class WriteDeclarationVariableNode
extends RubyNode {
    private final int frameDepth;
    private final FrameSlot frameSlot;
    @Node.Child
    private RubyNode valueNode;
    @Node.Child
    private WriteFrameSlotNode writeFrameSlotNode;

    public WriteDeclarationVariableNode(RubyContext context, RubySourceSection sourceSection, FrameSlot frameSlot, int frameDepth, RubyNode valueNode) {
        super(context, sourceSection);
        this.frameDepth = frameDepth;
        this.frameSlot = frameSlot;
        this.valueNode = valueNode;
    }

    public WriteDeclarationVariableNode(RubyContext context, SourceSection sourceSection, FrameSlot frameSlot, int frameDepth, RubyNode valueNode) {
        super(context, sourceSection);
        this.frameDepth = frameDepth;
        this.frameSlot = frameSlot;
        this.valueNode = valueNode;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        if (this.writeFrameSlotNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.writeFrameSlotNode = this.insert(WriteFrameSlotNodeGen.create(this.frameSlot));
        }
        MaterializedFrame declarationFrame = RubyArguments.getDeclarationFrame(frame, this.frameDepth);
        Object value = this.valueNode.execute(frame);
        return this.writeFrameSlotNode.executeWrite(declarationFrame, value);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.coreStrings().ASSIGNMENT.createInstance();
    }
}

