/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.methods;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.module.ModuleOperations;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.objects.MetaClassNode;
import org.jruby.truffle.language.objects.MetaClassNodeGen;

@NodeChildren(value={@NodeChild(value="self"), @NodeChild(value="name")})
public abstract class LookupMethodNode
extends RubyNode {
    private final boolean ignoreVisibility;
    private final boolean onlyLookupPublic;
    @Node.Child
    MetaClassNode metaClassNode;

    public LookupMethodNode(RubyContext context, SourceSection sourceSection, boolean ignoreVisibility, boolean onlyLookupPublic) {
        super(context, sourceSection);
        this.ignoreVisibility = ignoreVisibility;
        this.onlyLookupPublic = onlyLookupPublic;
        this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
    }

    public abstract InternalMethod executeLookupMethod(VirtualFrame var1, Object var2, String var3);

    @Specialization(guards={"metaClass(self) == selfMetaClass", "name == cachedName"}, assumptions={"getUnmodifiedAssumption(selfMetaClass)"}, limit="getCacheLimit()")
    protected InternalMethod lookupMethodCached(VirtualFrame frame, Object self, String name, @Cached(value="metaClass(self)") DynamicObject selfMetaClass, @Cached(value="name") String cachedName, @Cached(value="doLookup(frame, self, name)") InternalMethod method) {
        return method;
    }

    protected Assumption getUnmodifiedAssumption(DynamicObject module) {
        return Layouts.MODULE.getFields(module).getUnmodifiedAssumption();
    }

    @Specialization
    protected InternalMethod lookupMethodUncached(VirtualFrame frame, Object self, String name) {
        return this.doLookup(frame, self, name);
    }

    protected DynamicObject metaClass(Object object) {
        return this.metaClassNode.executeMetaClass(object);
    }

    protected InternalMethod doLookup(VirtualFrame frame, Object self, String name) {
        return LookupMethodNode.lookupMethodWithVisibility(this.getContext(), frame, self, name, this.ignoreVisibility, this.onlyLookupPublic);
    }

    @CompilerDirectives.TruffleBoundary
    protected static InternalMethod doLookup(RubyContext context, DynamicObject callerClass, Object receiver, String name, boolean ignoreVisibility, boolean onlyLookupPublic) {
        InternalMethod method = ModuleOperations.lookupMethod(context.getCoreLibrary().getMetaClass(receiver), name);
        if (method == null) {
            return null;
        }
        if (method.isUndefined()) {
            return null;
        }
        if (!ignoreVisibility && (onlyLookupPublic ? !method.getVisibility().isPublic() : !method.isVisibleTo(callerClass))) {
            return null;
        }
        return method;
    }

    protected static DynamicObject getCallerClass(RubyContext context, VirtualFrame callingFrame, boolean ignoreVisibility, boolean onlyLookupPublic) {
        if (ignoreVisibility || onlyLookupPublic) {
            return null;
        }
        InternalMethod method = RubyArguments.getMethod(callingFrame);
        if (!context.getCoreLibrary().isSend(method)) {
            return context.getCoreLibrary().getMetaClass(RubyArguments.getSelf(callingFrame));
        }
        FrameInstance instance = context.getCallStack().getCallerFrameIgnoringSend();
        Frame callerFrame = instance.getFrame(FrameInstance.FrameAccess.READ_ONLY, true);
        return context.getCoreLibrary().getMetaClass(RubyArguments.getSelf(callerFrame));
    }

    public static InternalMethod lookupMethodWithVisibility(RubyContext context, VirtualFrame callingFrame, Object receiver, String name, boolean ignoreVisibility, boolean onlyLookupPublic) {
        DynamicObject callerClass = LookupMethodNode.getCallerClass(context, callingFrame, ignoreVisibility, onlyLookupPublic);
        return LookupMethodNode.doLookup(context, callerClass, receiver, name, ignoreVisibility, onlyLookupPublic);
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().METHOD_LOOKUP_CACHE;
    }
}

